/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.enums.PackageTypeEnum;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.JsonUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.WebUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmLogService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmPackageService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.TreeData;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoImportVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmLogVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmPackageVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ProjectTmInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="projectTmInfoService")
    private ProjectTmInfoService projectTmInfoService;
    @Autowired
    @Qualifier(value="projectTmPackageService")
    private ProjectTmPackageService projectTmPackageService;
    @Autowired
    @Qualifier(value="projectTmLogService")
    private ProjectTmLogService projectTmLogService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private HttpServletRequest request;
    @Value(value="${project.tmp.path}")
    private String projectTmpPath;

    @PostMapping(value={"/project/tm/info"})
    @ResponseBody
    public ResponseData<String> insertProjectTmInfo(@RequestBody ProjectTmInfoVO inProjectTmInfoVo) {
        this.setUserInfoToVO((Object)inProjectTmInfoVo);
        if (StringUtils.isBlank((CharSequence)inProjectTmInfoVo.getProjectId())) {
            inProjectTmInfoVo.setProjectId(KeyUtil.createUniqueKey("P"));
        }
        inProjectTmInfoVo.setProjectInnerId(inProjectTmInfoVo.getProjectId());
        inProjectTmInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inProjectTmInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inProjectTmInfoVo.setTenantOrgCode(inProjectTmInfoVo.getLoginUserOrgCode());
        int outputVo = this.projectTmInfoService.insertProjectTmInfo(inProjectTmInfoVo);
        ProjectTmPackageVO ptpv = new ProjectTmPackageVO();
        ptpv.setPackageId(inProjectTmInfoVo.getProjectId());
        ptpv.setProjectId(inProjectTmInfoVo.getProjectId());
        ptpv.setPackageCode(inProjectTmInfoVo.getProjectCode());
        ptpv.setPackageName(inProjectTmInfoVo.getProjectName());
        ptpv.setPackageAbvId("0");
        ptpv.setPackageType(0);
        ptpv.setPackageDesc(inProjectTmInfoVo.getProjectName());
        ptpv.setOrderValue(ptpv.getPackageType());
        ptpv.setCreateUser(this.getUserInfo().getUserId());
        ptpv.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        ptpv.setPackageLocation(inProjectTmInfoVo.getProjectName() + "/");
        this.projectTmPackageService.insertProjectTmPackage(ptpv);
        ptpv.setPackageId(KeyUtil.createUUIDKey());
        ptpv.setPackageCode(PackageTypeEnum.TABLE.getEnname());
        ptpv.setPackageName(PackageTypeEnum.TABLE.getCnname());
        ptpv.setPackageAbvId(ptpv.getProjectId());
        ptpv.setPackageType(PackageTypeEnum.TABLE.getType());
        this.projectTmPackageService.insertProjectTmPackage(ptpv);
        ptpv.setPackageId(KeyUtil.createUUIDKey());
        ptpv.setPackageCode(PackageTypeEnum.Data.getEnname());
        ptpv.setPackageName(PackageTypeEnum.Data.getCnname());
        ptpv.setPackageAbvId(ptpv.getProjectId());
        ptpv.setPackageType(PackageTypeEnum.Data.getType());
        this.projectTmPackageService.insertProjectTmPackage(ptpv);
        ptpv.setPackageId(KeyUtil.createUUIDKey());
        ptpv.setPackageCode(PackageTypeEnum.ITEM.getEnname());
        ptpv.setPackageName(PackageTypeEnum.ITEM.getCnname());
        ptpv.setPackageAbvId(ptpv.getProjectId());
        ptpv.setPackageType(PackageTypeEnum.ITEM.getType());
        this.projectTmPackageService.insertProjectTmPackage(ptpv);
        ptpv.setPackageId(KeyUtil.createUUIDKey());
        ptpv.setPackageCode(PackageTypeEnum.OPTION.getEnname());
        ptpv.setPackageName(PackageTypeEnum.OPTION.getCnname());
        ptpv.setPackageAbvId(ptpv.getProjectId());
        ptpv.setPackageType(PackageTypeEnum.OPTION.getType());
        this.projectTmPackageService.insertProjectTmPackage(ptpv);
        ptpv.setPackageId(KeyUtil.createUUIDKey());
        ptpv.setPackageCode(PackageTypeEnum.ER.getEnname());
        ptpv.setPackageName(PackageTypeEnum.ER.getCnname());
        ptpv.setPackageAbvId(ptpv.getProjectId());
        ptpv.setPackageType(PackageTypeEnum.ER.getType());
        this.projectTmPackageService.insertProjectTmPackage(ptpv);
        ProjectTmLogVO ptlv = new ProjectTmLogVO();
        ptlv.setRecordKeyid(KeyUtil.createUUIDKey());
        ptlv.setClientIp(WebUtil.getClientIp(this.request));
        ptlv.setOperUserid(this.getUserInfo().getUserId());
        ptlv.setLogRecordTime(CurrentDateUtil.getTodayDateEx2());
        ptlv.setProjectId(inProjectTmInfoVo.getProjectId());
        ptlv.setLogContent("\u521b\u5efa\u8868\u6a21\u578b\u5de5\u7a0b");
        this.projectTmLogService.insertProjectTmLog(ptlv);
        return this.getResponseData(inProjectTmInfoVo.getProjectId());
    }

    @DeleteMapping(value={"/project/tm/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ProjectTmInfoVO inProjectTmInfoVo) {
        this.projectTmInfoService.copyToRecover(inProjectTmInfoVo.getProjectId());
        int outputVo = this.projectTmInfoService.deleteByPk(inProjectTmInfoVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/project/tm/info/withtb"})
    @ResponseBody
    public ResponseData<Integer> deleteWithModelTables(@RequestBody ProjectTmInfoVO inProjectTmInfoVo) {
        int outputVo = this.projectTmInfoService.deleteByPkWithTb(inProjectTmInfoVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/project/tm/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ProjectTmInfoVO inProjectTmInfoVo) {
        ProjectTmInfoVO oldProject = this.projectTmInfoService.queryByPk(inProjectTmInfoVo);
        inProjectTmInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inProjectTmInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.projectTmInfoService.updateByPk(inProjectTmInfoVo);
        if (oldProject.getProjectDbms() != inProjectTmInfoVo.getProjectDbms()) {
            int num = this.modelTableFieldService.updateFieldInfoWithItem(inProjectTmInfoVo.getProjectId(), inProjectTmInfoVo.getProjectDbms());
            logger.info("\u540c\u6b65\u66f4\u65b0\u8868\u6a21\u578b\u5e93\u4e0b\u6240\u6709\u5b57\u6bb5\u5bf9\u5e94\u7684dbms\u6570\u636e\u7c7b\u578b,\u5171\u8ba1{}\u6761!", (Object)num);
        }
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/project/tm/info/{projectId}"})
    @ResponseBody
    public ResponseData<ProjectTmInfoVO> queryByPk(@PathVariable(value="projectId") String projectId) {
        ProjectTmInfoVO inVo = new ProjectTmInfoVO();
        inVo.setProjectId(projectId);
        ProjectTmInfoVO outputVo = this.projectTmInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/my/project/tm/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ProjectTmInfoVO>> queryMyProjectTmInfoAll(ProjectTmInfoVO vo) {
        List<ProjectTmInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.projectTmInfoService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/info/ecss"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ProjectTmInfoVO>> queryMyProjectTmInfoWithEcsInfoAll(ProjectTmInfoVO vo) {
        List<ProjectTmInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.projectTmInfoService.queryAllByLevelOneWithEcsInfo(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/app/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ProjectTmInfoVO>> queryAllByAppByPage(ProjectTmInfoVO vo) {
        List<ProjectTmInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.projectTmInfoService.queryAllByAppByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ProjectTmInfoVO>> queryPublicProjectTmInfoAll(ProjectTmInfoVO vo) {
        List<ProjectTmInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.projectTmInfoService.queryAllByLevelTwo(vo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/project/tree/package/{projectId}"})
    public void queryTreeSWithAppId(@PathVariable(value="projectId") String projectId, HttpServletResponse response) {
        List<TreeData> treeDataList = this.projectTmInfoService.queryTreeWithPackage(projectId);
        StringBuffer jsonBuf = new StringBuffer();
        jsonBuf.append("[");
        this.recursiveJson(jsonBuf, treeDataList, "0");
        jsonBuf.append("]");
        response.setContentType("text/html; charset=utf-8");
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
            pw.write(JsonUtil.formatJson(jsonBuf.toString()));
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void recursiveJson(StringBuffer jsonBuf, List<TreeData> dataList, String parentId) {
        for (int i = 0; i < dataList.size(); ++i) {
            if (!parentId.equals(dataList.get(i).getParentid())) continue;
            jsonBuf.append("{");
            String idValue = dataList.get(i).getId();
            jsonBuf.append("\"id\":\"").append(idValue).append("\",");
            jsonBuf.append("\"text\":\"").append(dataList.get(i).getText()).append("\",");
            jsonBuf.append("\"state\":\"").append(dataList.get(i).getState()).append("\",");
            jsonBuf.append("\"checked\":\"").append(dataList.get(i).getChecked()).append("\",");
            jsonBuf.append("\"attributes\":{").append(dataList.get(i).getAttributes()).append("}");
            if (this.hasChildren(dataList, idValue)) {
                jsonBuf.append(",\"children\":");
                jsonBuf.append("[");
                this.recursiveJson(jsonBuf, dataList, idValue);
                jsonBuf.append("]");
            }
            jsonBuf.append("}");
            jsonBuf.append(",");
        }
        if (',' == jsonBuf.charAt(jsonBuf.length() - 1)) {
            jsonBuf.deleteCharAt(jsonBuf.length() - 1);
        }
    }

    private boolean hasChildren(List<TreeData> dataList, String idValue) {
        for (int i = 0; i < dataList.size(); ++i) {
            if (!idValue.equals(dataList.get(i).getParentid())) continue;
            return true;
        }
        return false;
    }

    @PostMapping(value={"/project/tm/info/import"})
    @ResponseBody
    public ResponseData<Boolean> importTableFromDB(@RequestBody ProjectTmInfoImportVO importVO) {
        ProjectTmLogVO ptlv = new ProjectTmLogVO();
        ptlv.setRecordKeyid(KeyUtil.createUUIDKey());
        ptlv.setClientIp(WebUtil.getClientIp(this.request));
        ptlv.setOperUserid(this.getUserInfo().getUserId());
        ptlv.setLogRecordTime(CurrentDateUtil.getTodayDateEx2());
        ptlv.setProjectId(importVO.getProjectId());
        ptlv.setLogContent("\u4ece\u6570\u636e\u5e93[" + importVO.getDbUrl() + "]\u5bfc\u5165\u8868\u6a21\u578b");
        this.projectTmLogService.insertProjectTmLog(ptlv);
        return this.getResponseData(true);
    }
}

