/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmPackageService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmPackageVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ProjectTmPackageController
extends AbstractController {
    @Autowired
    @Qualifier(value="projectTmPackageService")
    private ProjectTmPackageService projectTmPackageService;

    @PostMapping(value={"/project/tm/package"})
    @ResponseBody
    public ResponseData<Integer> insertProjectTmPackage(@RequestBody ProjectTmPackageVO inProjectTmPackageVo) {
        ProjectTmPackageVO inVo = new ProjectTmPackageVO();
        inVo.setPackageId(inProjectTmPackageVo.getPackageAbvId());
        ProjectTmPackageVO abvPackage = this.projectTmPackageService.queryByPk(inVo);
        inProjectTmPackageVo.setPackageId(KeyUtil.createUUIDKey());
        inProjectTmPackageVo.setCreateUser(this.getUserInfo().getUserId());
        inProjectTmPackageVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inProjectTmPackageVo.setLastModifyUser(inProjectTmPackageVo.getCreateUser());
        inProjectTmPackageVo.setLastModifyTime(inProjectTmPackageVo.getCreateTime());
        inProjectTmPackageVo.setPackageLocation(abvPackage.getPackageLocation() + inProjectTmPackageVo.getPackageName() + "/");
        int outputVo = this.projectTmPackageService.insertProjectTmPackage(inProjectTmPackageVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/project/tm/package"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ProjectTmPackageVO inProjectTmPackageVo) {
        int outputVo = this.projectTmPackageService.deleteByPk(inProjectTmPackageVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/project/tm/package"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ProjectTmPackageVO inProjectTmPackageVo) {
        ProjectTmPackageVO inVo = new ProjectTmPackageVO();
        inVo.setPackageId(inProjectTmPackageVo.getPackageAbvId());
        ProjectTmPackageVO abvPackage = this.projectTmPackageService.queryByPk(inVo);
        inProjectTmPackageVo.setLastModifyUser(this.getUserInfo().getUserId());
        inProjectTmPackageVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        inProjectTmPackageVo.setPackageLocation(abvPackage.getPackageLocation() + inProjectTmPackageVo.getPackageName() + "/");
        int outputVo = this.projectTmPackageService.updateByPk(inProjectTmPackageVo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/project/tm/package/merge"})
    @ResponseBody
    public ResponseData<Integer> packageMerge(@RequestBody ProjectTmPackageVO inProjectTmPackageVo) {
        this.setUserInfoToVO((Object)inProjectTmPackageVo);
        int outputVo = this.projectTmPackageService.packageMerge(inProjectTmPackageVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/project/tm/package/{packageId}"})
    @ResponseBody
    public ResponseData<ProjectTmPackageVO> queryByPk(@PathVariable(value="packageId") String packageId) {
        ProjectTmPackageVO inVo = new ProjectTmPackageVO();
        inVo.setPackageId(packageId);
        ProjectTmPackageVO outputVo = this.projectTmPackageService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @GetMapping(value={"/project/tm/package/check/{packageId}"})
    @ResponseBody
    public ResponseData<String> checkByPk(@PathVariable(value="packageId") String packageId) {
        ResponseData rsp = new ResponseData();
        ProjectTmPackageVO inVo = new ProjectTmPackageVO();
        inVo.setPackageId(packageId);
        ProjectTmPackageVO packageVo = this.projectTmPackageService.queryByPk(inVo);
        if (packageVo.getPackageAbvId().equals(packageVo.getProjectId())) {
            rsp.fail("\u5f53\u524d\u76ee\u5f55\u4e3a\u8868\u6a21\u578b\u6839\u76ee\u5f55,\u4e0d\u53ef\u5220\u9664!");
            return rsp;
        }
        if (this.projectTmPackageService.isHaveSubPackage(packageVo.getPackageId()) || this.projectTmPackageService.isHaveTableModel(packageVo.getPackageId())) {
            rsp.fail("\u9700\u8981\u5148\u5220\u9664\u76ee\u5f55\u4e0b\u7684\u5b50\u76ee\u5f55\u53ca\u8868\u6a21\u578b\u540e\u65b9\u53ef\u5220\u9664\u5f53\u524d\u76ee\u5f55!");
            return rsp;
        }
        return this.getResponseData("\u53ef\u4ee5\u5220\u9664!");
    }

    @RequestMapping(value={"/project/tm/packages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ProjectTmPackageVO>> queryProjectTmPackageAll(ProjectTmPackageVO vo) {
        List<ProjectTmPackageVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.projectTmPackageService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }
}

