/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDbmsDatatypeService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDbmsDatatypeVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class PubDbmsDatatypeController
extends AbstractController {
    @Autowired
    @Qualifier(value="pubDbmsDatatypeService")
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    @Qualifier(value="projectTmInfoService")
    private ProjectTmInfoService projectTmInfoService;
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;

    @PostMapping(value={"/pub/dbms/datatype"})
    @ResponseBody
    public ResponseData<Integer> insertPubDbmsDatatype(@RequestBody PubDbmsDatatypeVO inPubDbmsDatatypeVo) {
        int outputVo = this.pubDbmsDatatypeService.insertPubDbmsDatatype(inPubDbmsDatatypeVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/pub/dbms/datatype"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PubDbmsDatatypeVO inPubDbmsDatatypeVo) {
        int outputVo = this.pubDbmsDatatypeService.deleteByPk(inPubDbmsDatatypeVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/pub/dbms/datatype"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PubDbmsDatatypeVO inPubDbmsDatatypeVo) {
        int outputVo = this.pubDbmsDatatypeService.updateByPk(inPubDbmsDatatypeVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/pub/dbms/datatype/{dbmsId}/{datatypeId}"})
    @ResponseBody
    public ResponseData<PubDbmsDatatypeVO> queryByPk(@PathVariable(value="dbmsId") Integer dbmsId, @PathVariable(value="datatypeId") Integer datatypeId) {
        PubDbmsDatatypeVO inVo = new PubDbmsDatatypeVO();
        inVo.setDbmsId(dbmsId);
        inVo.setDatatypeId(datatypeId);
        PubDbmsDatatypeVO outputVo = this.pubDbmsDatatypeService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/pub/dbms/datatypes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PubDbmsDatatypeVO>> queryPubDbmsDatatypeAll(PubDbmsDatatypeVO vo) {
        List<PubDbmsDatatypeVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.pubDbmsDatatypeService.queryAllByLevelOne(vo);
        if (CollectionUtils.isNotEmpty(outputVo)) {
            for (PubDbmsDatatypeVO dd : outputVo) {
                if (dd.getDatatypeId() == null) continue;
                dd.setDatatypeName(dd.getDatatypeId().toString());
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/pub/dbms/datatypes/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PubDbmsDatatypeVO>> queryDbmsDatatypeRefByPage(PubDbmsDatatypeVO vo) {
        List<PubDbmsDatatypeVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.pubDbmsDatatypeService.queryDbmsDatatypeRefByPage(vo);
        if (CollectionUtils.isNotEmpty(outputVo)) {
            for (PubDbmsDatatypeVO dd : outputVo) {
                if (dd.getDatatypeId() == null) continue;
                dd.setDatatypeName(dd.getDatatypeId().toString());
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/pub/dbms/datatypes/objectid/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PubDbmsDatatypeVO>> queryPubDbmsDatatypeAllByObjectId(@PathVariable(value="objectId") String objectId) {
        ModelTableInfoVO tableParam = new ModelTableInfoVO();
        tableParam.setObjectId(objectId);
        tableParam = this.modelTableInfoService.queryByPk(tableParam);
        if (tableParam != null && StringUtils.isNotBlank((CharSequence)tableParam.getProjectId())) {
            ProjectTmInfoVO tmParam = new ProjectTmInfoVO();
            tmParam.setProjectId(tableParam.getProjectId());
            tmParam = this.projectTmInfoService.queryByPk(tmParam);
            if (tmParam != null) {
                PubDbmsDatatypeVO pubParam = new PubDbmsDatatypeVO();
                pubParam.setSize(1000);
                pubParam.setDbmsId(tmParam.getProjectDbms());
                List<PubDbmsDatatypeVO> dbmsTypes = this.pubDbmsDatatypeService.queryAllByLevelOne(pubParam);
                if (CollectionUtils.isNotEmpty(dbmsTypes)) {
                    ArrayList<PubDbmsDatatypeVO> list = new ArrayList<PubDbmsDatatypeVO>();
                    HashMap<String, PubDbmsDatatypeVO> map = new HashMap<String, PubDbmsDatatypeVO>();
                    for (PubDbmsDatatypeVO v : dbmsTypes) {
                        if (map.get(v.getDbmsDatatypeCode()) != null) continue;
                        list.add(v);
                        map.put(v.getDbmsDatatypeCode(), v);
                    }
                    dbmsTypes = list;
                }
                return this.getResponseData(dbmsTypes);
            }
            return this.getResponseData(new ArrayList(0));
        }
        return this.getResponseData(new ArrayList(0));
    }
}

