/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.common.util;

import java.util.Map;

public class JsonUtil {
    public static final String BEGIN_TAG = "{";
    public static final String END_TAG = "}";
    public static final String CONTENT_TAG = "\"";
    public static final String KV_SPLIT = ":";
    public static final String CELL_SPLIT = ",";
    public static final String MULTI_BEGIN = "[";
    public static final String MULTI_END = "]";

    public static final StringBuffer makeJsonContent(Map<String, Object> dataMap, boolean isJsonClosed) {
        StringBuffer sb = new StringBuffer();
        if (isJsonClosed) {
            sb.append(BEGIN_TAG);
        }
        for (Map.Entry<String, Object> stringObjectEntry : dataMap.entrySet()) {
            String key = stringObjectEntry.getKey();
            sb.append(CONTENT_TAG).append(key.toUpperCase()).append(CONTENT_TAG);
            sb.append(KV_SPLIT);
            sb.append(CONTENT_TAG).append(stringObjectEntry.getValue()).append(CONTENT_TAG);
            sb.append(CELL_SPLIT);
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (isJsonClosed) {
            sb.append(END_TAG);
        }
        return sb;
    }

    public static final String formatJson(String s) {
        StringBuffer sb = new StringBuffer();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '/': {
                    sb.append("\\/");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

