/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.plugin;

import com.irdstudio.allinpaas.console.dmcenter.plugin.DBImportPlugin;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBImportMysqlImpl
implements DBImportPlugin {
    Logger logger = LoggerFactory.getLogger(DBImportMysqlImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBImportPlugin.DBInfo readDBInfo(String url, String user, String pwd, String driverClass) {
        Connection conn = null;
        try {
            DBImportPlugin.Table tb;
            conn = this.getDBConnection(url, user, pwd, driverClass);
            String dbName = this.queryDBName(conn);
            List<DBImportPlugin.Table> tables = this.queryTables(dbName, conn);
            List<DBImportPlugin.TableField> fields = this.queryTableFields(dbName, conn);
            List<DBImportPlugin.TableIndex> indexes = this.queryTableIndexes(dbName, conn);
            DBImportPlugin.DBInfo db = new DBImportPlugin.DBInfo();
            db.setTables(tables);
            HashMap<String, DBImportPlugin.Table> tableMap = new HashMap<String, DBImportPlugin.Table>(tables.size());
            for (DBImportPlugin.Table tb2 : tables) {
                tableMap.put(tb2.getTable_name(), tb2);
                tb2.setFields(new ArrayList<DBImportPlugin.TableField>());
                tb2.setIndexes(new ArrayList<DBImportPlugin.TableIndex>());
            }
            for (DBImportPlugin.TableField field : fields) {
                tb = (DBImportPlugin.Table)tableMap.get(field.getTable_name());
                if (tb == null) continue;
                tb.getFields().add(field);
            }
            for (DBImportPlugin.TableIndex index : indexes) {
                tb = (DBImportPlugin.Table)tableMap.get(index.getTable_name());
                if (tb == null) continue;
                tb.getIndexes().add(index);
            }
            DBImportPlugin.DBInfo dBInfo = db;
            return dBInfo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private ResultSet executeSQL(String sql, List param, Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement(sql);
        if (CollectionUtils.isNotEmpty((Collection)param)) {
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    private String queryDBName(Connection conn) throws Exception {
        String dbNameSQL = new SQL(){
            {
                this.SELECT("database()");
            }
        }.toString();
        String dbName = null;
        ResultSet rs = this.executeSQL(dbNameSQL, null, conn);
        if (rs.next()) {
            dbName = rs.getString(1);
        }
        rs.close();
        return dbName;
    }

    private List<DBImportPlugin.Table> queryTables(String dbName, Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("table_name, table_comment, table_schema");
                this.FROM("information_schema.tables");
                this.WHERE("table_schema = ?");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, Arrays.asList(dbName), conn);
        ArrayList<DBImportPlugin.Table> tables = new ArrayList<DBImportPlugin.Table>();
        while (rs.next()) {
            DBImportPlugin.Table tb = new DBImportPlugin.Table();
            tb.setTable_name(rs.getString(1));
            tb.setTable_comment(rs.getString(2));
            tables.add(tb);
        }
        return tables;
    }

    private List<DBImportPlugin.TableField> queryTableFields(String dbName, Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("table_name, column_name, column_default, is_nullable, data_type, column_type, column_comment");
                this.FROM("information_schema.columns");
                this.WHERE("table_schema = ?");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, Arrays.asList(dbName), conn);
        ArrayList<DBImportPlugin.TableField> fields = new ArrayList<DBImportPlugin.TableField>();
        while (rs.next()) {
            DBImportPlugin.TableField ff = new DBImportPlugin.TableField();
            ff.setTable_name(rs.getString(1));
            ff.setColumn_name(rs.getString(2));
            ff.setColumn_default(rs.getString(3));
            ff.setIs_nullable(rs.getString(4));
            ff.setData_type(rs.getString(5));
            ff.setColumn_type(rs.getString(6));
            ff.setColumn_comment(rs.getString(7));
            fields.add(ff);
        }
        return fields;
    }

    private List<DBImportPlugin.TableIndex> queryTableIndexes(String dbName, Connection conn) throws Exception {
        String sql = new SQL(){
            {
                this.SELECT("table_name, index_name, group_concat(column_name) as columns");
                this.FROM("information_schema.STATISTICS ");
                this.WHERE("table_schema = ?");
                this.GROUP_BY("table_name, index_name");
            }
        }.toString();
        ResultSet rs = this.executeSQL(sql, Arrays.asList(dbName), conn);
        ArrayList<DBImportPlugin.TableIndex> indexes = new ArrayList<DBImportPlugin.TableIndex>();
        while (rs.next()) {
            DBImportPlugin.TableIndex ii = new DBImportPlugin.TableIndex();
            ii.setTable_name(rs.getString(1));
            ii.setIndex_name(rs.getString(2));
            ii.setColumns(rs.getString(3));
            indexes.add(ii);
        }
        return indexes;
    }
}

