/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.plugin;

import com.irdstudio.allinpaas.console.dmcenter.plugin.DBImportMysqlImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface DBImportPlugin {
    public DBInfo readDBInfo(String var1, String var2, String var3, String var4);

    default public Connection getDBConnection(String url, String user, String pwd, String driverClass) {
        Connection conn = null;
        try {
            Class.forName(driverClass);
            StringBuffer connStr = new StringBuffer(url);
            conn = DriverManager.getConnection(connStr.toString(), user, pwd);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public static class DBInfo {
        private List<Table> tables;

        public List<Table> getTables() {
            return this.tables;
        }

        public void setTables(List<Table> tables) {
            this.tables = tables;
        }
    }

    public static class TableIndex {
        private String table_name;
        private String index_name;
        private String columns;

        public List<String> getColumnList() {
            if (this.columns != null && !this.columns.equals("")) {
                String[] arr = StringUtils.split((String)this.columns, (String)",");
                return Arrays.asList(arr);
            }
            return new ArrayList<String>(0);
        }

        public String getTable_name() {
            return this.table_name;
        }

        public void setTable_name(String table_name) {
            this.table_name = table_name;
        }

        public String getIndex_name() {
            return this.index_name;
        }

        public void setIndex_name(String index_name) {
            this.index_name = index_name;
        }

        public String getColumns() {
            return this.columns;
        }

        public void setColumns(String columns) {
            this.columns = columns;
        }
    }

    public static class TableField {
        private String table_name;
        private String column_name;
        private String column_default;
        private String is_nullable;
        private String data_type;
        private String column_type;
        private String column_comment;

        public String getTable_name() {
            return this.table_name;
        }

        public void setTable_name(String table_name) {
            this.table_name = table_name;
        }

        public String getColumn_name() {
            return this.column_name;
        }

        public void setColumn_name(String column_name) {
            this.column_name = column_name;
        }

        public String getColumn_default() {
            return this.column_default;
        }

        public void setColumn_default(String column_default) {
            this.column_default = column_default;
        }

        public String getIs_nullable() {
            return this.is_nullable;
        }

        public void setIs_nullable(String is_nullable) {
            this.is_nullable = is_nullable;
        }

        public String getData_type() {
            return this.data_type;
        }

        public void setData_type(String data_type) {
            this.data_type = data_type;
        }

        public String getColumn_type() {
            return this.column_type;
        }

        public void setColumn_type(String column_type) {
            this.column_type = column_type;
        }

        public String getColumn_comment() {
            return this.column_comment;
        }

        public void setColumn_comment(String column_comment) {
            this.column_comment = column_comment;
        }
    }

    public static class Table {
        private String table_name;
        private String table_comment;
        private List<TableField> fields;
        private List<TableIndex> indexes;

        public String getTable_name() {
            return this.table_name;
        }

        public void setTable_name(String table_name) {
            this.table_name = table_name;
        }

        public String getTable_comment() {
            return this.table_comment;
        }

        public void setTable_comment(String table_comment) {
            this.table_comment = table_comment;
        }

        public List<TableField> getFields() {
            return this.fields;
        }

        public void setFields(List<TableField> fields) {
            this.fields = fields;
        }

        public List<TableIndex> getIndexes() {
            return this.indexes;
        }

        public void setIndexes(List<TableIndex> indexes) {
            this.indexes = indexes;
        }
    }

    public static class Factory {
        public static DBImportPlugin getInstance(String driverClass) {
            switch (driverClass) {
                case "com.mysql.jdbc.Driver": {
                    return new DBImportMysqlImpl();
                }
            }
            return null;
        }
    }
}

