/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DiagramBaseInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DiagramLinkedInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DiagramLinkedRelationDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DiagramNodeInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DiagramBaseInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DiagramLinkedInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DiagramLinkedRelation;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DiagramNodeInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DiagramBaseInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DiagramBaseInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DiagramNodeInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="diagramBaseInfoService")
public class DiagramBaseInfoServiceImpl
implements DiagramBaseInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(DiagramBaseInfoServiceImpl.class);
    @Autowired
    private DiagramBaseInfoDao diagramBaseInfoDao;
    @Autowired
    private DiagramLinkedInfoDao diagramLinkedInfoDao;
    @Autowired
    private DiagramLinkedRelationDao diagramLinkedRelationDao;
    @Autowired
    private DiagramNodeInfoDao diagramNodeInfoDao;
    @Autowired
    private ModelTableInfoDao modelTableInfoDao;

    @Override
    public int insertDiagramBaseInfo(DiagramBaseInfoVO inDiagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inDiagramBaseInfoVo.toString());
        int num = 0;
        try {
            DiagramBaseInfo diagramBaseInfo = new DiagramBaseInfo();
            this.beanCopy((Object)inDiagramBaseInfoVo, (Object)diagramBaseInfo);
            num = this.diagramBaseInfoDao.insertDiagramBaseInfo(diagramBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(DiagramBaseInfoVO inDiagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inDiagramBaseInfoVo));
        int num = 0;
        try {
            DiagramBaseInfo diagramBaseInfo = new DiagramBaseInfo();
            this.beanCopy((Object)inDiagramBaseInfoVo, (Object)diagramBaseInfo);
            num = this.diagramBaseInfoDao.deleteByPk(diagramBaseInfo);
            this.diagramLinkedRelationDao.deleteByDiagramId(inDiagramBaseInfoVo.getDiagramId());
            this.diagramLinkedInfoDao.deleteByDiagramId(inDiagramBaseInfoVo.getDiagramId());
            this.diagramNodeInfoDao.deleteByDiagramId(inDiagramBaseInfoVo.getDiagramId());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDiagramBaseInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(DiagramBaseInfoVO inDiagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inDiagramBaseInfoVo.toString());
        int num = 0;
        try {
            DiagramBaseInfo diagramBaseInfo = new DiagramBaseInfo();
            this.beanCopy((Object)inDiagramBaseInfoVo, (Object)diagramBaseInfo);
            num = this.diagramBaseInfoDao.updateByPk(diagramBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDiagramBaseInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public DiagramBaseInfoVO queryByPk(DiagramBaseInfoVO inDiagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inDiagramBaseInfoVo));
        try {
            DiagramBaseInfo queryDiagramBaseInfo = new DiagramBaseInfo();
            this.beanCopy((Object)inDiagramBaseInfoVo, (Object)queryDiagramBaseInfo);
            DiagramBaseInfo queryRslDiagramBaseInfo = this.diagramBaseInfoDao.queryByPk(queryDiagramBaseInfo);
            if (Objects.nonNull((Object)queryRslDiagramBaseInfo)) {
                DiagramBaseInfoVO outDiagramBaseInfoVo = (DiagramBaseInfoVO)((Object)this.beanCopy((Object)queryRslDiagramBaseInfo, (Object)new DiagramBaseInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outDiagramBaseInfoVo.toString());
                return outDiagramBaseInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<DiagramBaseInfoVO> queryAllOwner(DiagramBaseInfoVO diagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DiagramBaseInfo> diagramBaseInfos = this.diagramBaseInfoDao.queryAllOwnerByPage(diagramBaseInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + diagramBaseInfos.size());
            this.pageSet(diagramBaseInfos, diagramBaseInfoVo);
            list = this.beansCopy(diagramBaseInfos, DiagramBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DiagramBaseInfoVO> queryAllCurrOrg(DiagramBaseInfoVO diagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DiagramBaseInfo> diagramBaseInfos = this.diagramBaseInfoDao.queryAllCurrOrgByPage(diagramBaseInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + diagramBaseInfos.size());
        List list = null;
        try {
            this.pageSet(diagramBaseInfos, diagramBaseInfoVo);
            list = this.beansCopy(diagramBaseInfos, DiagramBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DiagramBaseInfoVO> queryAllCurrDownOrg(DiagramBaseInfoVO diagramBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DiagramBaseInfo> diagramBaseInfos = this.diagramBaseInfoDao.queryAllCurrDownOrgByPage(diagramBaseInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + diagramBaseInfos.size());
        List list = null;
        try {
            this.pageSet(diagramBaseInfos, diagramBaseInfoVo);
            list = this.beansCopy(diagramBaseInfos, DiagramBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Map<String, Object> queryDiagramData(DiagramBaseInfoVO diagramBaseInfoVo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DiagramBaseInfo baseParam = new DiagramBaseInfo();
        baseParam.setDiagramId(diagramBaseInfoVo.getDiagramId());
        DiagramBaseInfo baseInfo = this.diagramBaseInfoDao.queryByPk(baseParam);
        if (baseInfo != null) {
            List<DiagramLinkedInfo> linkeds = this.diagramLinkedInfoDao.queryLinkedInfosByDiagramId(diagramBaseInfoVo.getDiagramId());
            if (CollectionUtils.isNotEmpty(linkeds)) {
                for (DiagramLinkedInfo linked : linkeds) {
                    DiagramLinkedRelation relation = this.diagramLinkedRelationDao.queryOneByLinkedId(linked.getLinkedId());
                    if (relation == null) continue;
                    linked.setLinkedDesc(relation.getErRelationType());
                }
            }
            DiagramNodeInfoVO nodeParam = new DiagramNodeInfoVO();
            nodeParam.setDiagramId(diagramBaseInfoVo.getDiagramId());
            List<DiagramNodeInfo> nodes = this.diagramNodeInfoDao.queryAllOwner(nodeParam);
            result.put(DiagramBaseInfo.class.getSimpleName(), (Object)baseInfo);
            result.put(DiagramLinkedInfo.class.getSimpleName(), linkeds);
            result.put(DiagramNodeInfo.class.getSimpleName(), nodes);
        }
        return result;
    }

    @Override
    public boolean saveDiagramData(Map<String, Object> data) {
        BaseInfo checkObj;
        List linkeds = (List)data.get(DiagramLinkedInfo.class.getSimpleName());
        List nodes = (List)data.get(DiagramNodeInfo.class.getSimpleName());
        if (CollectionUtils.isNotEmpty((Collection)linkeds)) {
            List linkedList = JSON.parseArray((String)JSON.toJSONString((Object)linkeds), DiagramLinkedInfo.class);
            for (DiagramLinkedInfo linked : linkedList) {
                try {
                    checkObj = this.diagramLinkedInfoDao.queryByPk(linked);
                    if (checkObj != null) {
                        this.diagramLinkedInfoDao.updateByPk(linked);
                        continue;
                    }
                    this.diagramLinkedInfoDao.insertDiagramLinkedInfo(linked);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            List nodeList = JSON.parseArray((String)JSON.toJSONString((Object)nodes), DiagramNodeInfo.class);
            for (DiagramNodeInfo node : nodeList) {
                try {
                    checkObj = this.diagramNodeInfoDao.queryByPk(node);
                    if (checkObj != null) {
                        this.diagramNodeInfoDao.updateByPk(node);
                        continue;
                    }
                    this.diagramNodeInfoDao.insertDiagramNodeInfo(node);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return true;
    }
}

