/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.common.enums.CategoryPackagePrefix;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictCategoryInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictCategoryInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictCategoryInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictCategoryInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictCategoryInfoServiceImpl")
public class DictCategoryInfoServiceImpl
implements DictCategoryInfoService,
FrameworkService,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(DictCategoryInfoServiceImpl.class);
    private static Map<String, Queue<String>> packageIdHolder = new ConcurrentHashMap<String, Queue<String>>();
    @Autowired
    private DictCategoryInfoDao dictCategoryInfoDao;

    @Override
    public int insertDictCategoryInfo(DictCategoryInfoVO inDictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inDictCategoryInfoVo.toString());
        int num = 0;
        try {
            DictCategoryInfo dictCategoryInfo = new DictCategoryInfo();
            this.beanCopy((Object)inDictCategoryInfoVo, (Object)dictCategoryInfo);
            num = this.dictCategoryInfoDao.insertDictCategoryInfo(dictCategoryInfo);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(DictCategoryInfoVO inDictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inDictCategoryInfoVo));
        int num = 0;
        try {
            DictCategoryInfo dictCategoryInfo = new DictCategoryInfo();
            this.beanCopy((Object)inDictCategoryInfoVo, (Object)dictCategoryInfo);
            num = this.dictCategoryInfoDao.deleteByPk(dictCategoryInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictCategoryInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(DictCategoryInfoVO inDictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inDictCategoryInfoVo.toString());
        int num = 0;
        try {
            DictCategoryInfo dictCategoryInfo = new DictCategoryInfo();
            this.beanCopy((Object)inDictCategoryInfoVo, (Object)dictCategoryInfo);
            num = this.dictCategoryInfoDao.updateByPk(dictCategoryInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictCategoryInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public DictCategoryInfoVO queryByPk(DictCategoryInfoVO inDictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inDictCategoryInfoVo));
        try {
            DictCategoryInfo queryDictCategoryInfo = new DictCategoryInfo();
            this.beanCopy((Object)inDictCategoryInfoVo, (Object)queryDictCategoryInfo);
            DictCategoryInfo queryRslDictCategoryInfo = this.dictCategoryInfoDao.queryByPk(queryDictCategoryInfo);
            if (Objects.nonNull((Object)queryRslDictCategoryInfo)) {
                DictCategoryInfoVO outDictCategoryInfoVo = (DictCategoryInfoVO)((Object)this.beanCopy((Object)queryRslDictCategoryInfo, (Object)new DictCategoryInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outDictCategoryInfoVo.toString());
                return outDictCategoryInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<DictCategoryInfoVO> queryAllOwner(DictCategoryInfoVO dictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DictCategoryInfo> dictCategoryInfos = this.dictCategoryInfoDao.queryAllOwnerByPage(dictCategoryInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictCategoryInfos.size());
            this.pageSet(dictCategoryInfos, dictCategoryInfoVo);
            list = this.beansCopy(dictCategoryInfos, DictCategoryInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictCategoryInfoVO> queryAllCurrOrg(DictCategoryInfoVO dictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictCategoryInfo> dictCategoryInfos = this.dictCategoryInfoDao.queryAllCurrOrgByPage(dictCategoryInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictCategoryInfos.size());
        List list = null;
        try {
            this.pageSet(dictCategoryInfos, dictCategoryInfoVo);
            list = this.beansCopy(dictCategoryInfos, DictCategoryInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictCategoryInfoVO> queryAllCurrDownOrg(DictCategoryInfoVO dictCategoryInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictCategoryInfo> dictCategoryInfos = this.dictCategoryInfoDao.queryAllCurrDownOrgByPage(dictCategoryInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictCategoryInfos.size());
        List list = null;
        try {
            this.pageSet(dictCategoryInfos, dictCategoryInfoVo);
            list = this.beansCopy(dictCategoryInfos, DictCategoryInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Map<String, Queue<String>> map = packageIdHolder;
        synchronized (map) {
            if (packageIdHolder.size() == 0) {
                this.growUpPackage(CategoryPackagePrefix.Theme.getCode(), null);
                this.growUpPackage(CategoryPackagePrefix.FirstLevel.getCode(), null);
                this.growUpPackage(CategoryPackagePrefix.SecondLevel.getCode(), null);
                this.growUpPackage(CategoryPackagePrefix.ThirdLevel.getCode(), null);
            }
        }
    }

    private void growUpPackage(String prefix, Integer last) {
        Queue<String> queue = packageIdHolder.get(prefix);
        if (queue == null) {
            queue = new LinkedList<String>();
            packageIdHolder.put(prefix, queue);
        }
        if (queue.size() == 0) {
            Integer num = last;
            if (last != null) {
                num = last;
            } else {
                DictCategoryInfo param = new DictCategoryInfo();
                param.setPackageId(prefix);
                DictCategoryInfo max = this.dictCategoryInfoDao.queryMaxPackageId(param);
                if (max == null) {
                    max = new DictCategoryInfo();
                    max.setPackageId(prefix + "000000");
                }
                String packageId = max.getPackageId();
                num = Integer.valueOf(packageId.substring(prefix.length()));
            }
            for (int i = 1; i <= 100; ++i) {
                String suffix = StringUtils.leftPad((String)String.valueOf(num + i), (int)6, (String)"0");
                queue.add(String.format("%s%s", prefix, suffix));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSequencePackageId(String prefix) {
        Map<String, Queue<String>> map = packageIdHolder;
        synchronized (map) {
            Queue<String> queue = packageIdHolder.get(prefix);
            String id = queue.poll();
            Integer last = NumberUtils.toInt((String)id.substring(prefix.length()), (int)1);
            if (queue.size() == 0) {
                this.growUpPackage(prefix, last);
            }
            return id;
        }
    }
}

