/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemExtDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictItemExt;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictItemExtService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictItemExtVO;
import com.irdstudio.allinpaas.executor.core.plugin.datarefactor.AnalysisTableMatchItemTask;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictItemExtServiceImpl")
public class DictItemExtServiceImpl
implements DictItemExtService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(DictItemExtServiceImpl.class);
    @Autowired
    private DictItemExtDao dictItemExtDao;

    @Override
    public int insertDictItemExt(DictItemExtVO inDictItemExtVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inDictItemExtVo.toString());
        int num = 0;
        try {
            DictItemExt dictItemExt = new DictItemExt();
            this.beanCopy((Object)inDictItemExtVo, (Object)dictItemExt);
            num = this.dictItemExtDao.insertDictItemExt(dictItemExt);
            AnalysisTableMatchItemTask.pushItemListIntoCached(Arrays.asList(dictItemExt));
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(DictItemExtVO inDictItemExtVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inDictItemExtVo));
        int num = 0;
        try {
            DictItemExt dictItemExt = new DictItemExt();
            this.beanCopy((Object)inDictItemExtVo, (Object)dictItemExt);
            dictItemExt = this.dictItemExtDao.queryByPk(dictItemExt);
            num = this.dictItemExtDao.deleteByPk(dictItemExt);
            AnalysisTableMatchItemTask.removeItemCached((String)dictItemExt.getItemName());
            AnalysisTableMatchItemTask.removeItemCached((String)dictItemExt.getExtName());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictItemExtVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(DictItemExtVO inDictItemExtVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inDictItemExtVo.toString());
        int num = 0;
        try {
            DictItemExt dictItemExt = new DictItemExt();
            this.beanCopy((Object)inDictItemExtVo, (Object)dictItemExt);
            num = this.dictItemExtDao.updateByPk(dictItemExt);
            AnalysisTableMatchItemTask.pushItemListIntoCached(Arrays.asList(dictItemExt));
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictItemExtVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public DictItemExtVO queryByPk(DictItemExtVO inDictItemExtVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inDictItemExtVo));
        try {
            DictItemExt queryDictItemExt = new DictItemExt();
            this.beanCopy((Object)inDictItemExtVo, (Object)queryDictItemExt);
            DictItemExt queryRslDictItemExt = this.dictItemExtDao.queryByPk(queryDictItemExt);
            if (Objects.nonNull((Object)queryRslDictItemExt)) {
                DictItemExtVO outDictItemExtVo = (DictItemExtVO)((Object)this.beanCopy((Object)queryRslDictItemExt, (Object)new DictItemExtVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outDictItemExtVo.toString());
                return outDictItemExtVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<DictItemExtVO> queryAllOwner(DictItemExtVO dictItemExtVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DictItemExt> dictItemExts = this.dictItemExtDao.queryAllOwnerByPage(dictItemExtVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemExts.size());
            this.pageSet(dictItemExts, dictItemExtVo);
            list = this.beansCopy(dictItemExts, DictItemExtVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemExtVO> queryAllCurrOrg(DictItemExtVO dictItemExtVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemExt> dictItemExts = this.dictItemExtDao.queryAllCurrOrgByPage(dictItemExtVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemExts.size());
        List list = null;
        try {
            this.pageSet(dictItemExts, dictItemExtVo);
            list = this.beansCopy(dictItemExts, DictItemExtVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemExtVO> queryAllCurrDownOrg(DictItemExtVO dictItemExtVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemExt> dictItemExts = this.dictItemExtDao.queryAllCurrDownOrgByPage(dictItemExtVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemExts.size());
        List list = null;
        try {
            this.pageSet(dictItemExts, dictItemExtVo);
            list = this.beansCopy(dictItemExts, DictItemExtVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

