/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictCategoryInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemExtDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictItemInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableField;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictItemInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDbmsDatatypeService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictCategoryInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictItemInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDbmsDatatypeVO;
import com.irdstudio.allinpaas.executor.core.plugin.datarefactor.AnalysisTableMatchItemTask;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="dictItemInfoService")
public class DictItemInfoServiceImpl
implements DictItemInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(DictItemInfoServiceImpl.class);
    @Autowired
    private DictItemInfoDao dictItemInfoDao;
    @Autowired
    private DictItemExtDao dictItemExtDao;
    @Autowired
    private DictCategoryInfoDao dictCategoryInfoDao;
    @Autowired
    @Qualifier(value="pubDbmsDatatypeService")
    private PubDbmsDatatypeService pubDbmsDatatypeService;

    @Override
    public int insertDictItemInfo(DictItemInfoVO inDictItemInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inDictItemInfoVo.toString());
        int num = 0;
        try {
            DictItemInfo dictItemInfo = new DictItemInfo();
            this.beanCopy((Object)inDictItemInfoVo, (Object)dictItemInfo);
            num = this.dictItemInfoDao.insertDictItemInfo(dictItemInfo);
            AnalysisTableMatchItemTask.pushItemListIntoCached(Arrays.asList(dictItemInfo));
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(DictItemInfoVO inDictItemInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inDictItemInfoVo));
        int num = 0;
        try {
            DictItemInfo dictItemInfo = new DictItemInfo();
            this.beanCopy((Object)inDictItemInfoVo, (Object)dictItemInfo);
            dictItemInfo = this.dictItemInfoDao.queryByPk(dictItemInfo);
            num = this.dictItemInfoDao.deleteByPk(dictItemInfo);
            AnalysisTableMatchItemTask.removeItemCached((String)dictItemInfo.getItemName());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictItemInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(DictItemInfoVO inDictItemInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inDictItemInfoVo.toString());
        int num = 0;
        try {
            DictItemInfo dictItemInfo = new DictItemInfo();
            this.beanCopy((Object)inDictItemInfoVo, (Object)dictItemInfo);
            num = this.dictItemInfoDao.updateByPk(dictItemInfo);
            AnalysisTableMatchItemTask.pushItemListIntoCached(Arrays.asList(dictItemInfo));
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictItemInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public DictItemInfoVO queryByPk(DictItemInfoVO inDictItemInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inDictItemInfoVo));
        try {
            DictItemInfo queryDictItemInfo = new DictItemInfo();
            this.beanCopy((Object)inDictItemInfoVo, (Object)queryDictItemInfo);
            DictItemInfo queryRslDictItemInfo = this.dictItemInfoDao.queryByPk(queryDictItemInfo);
            if (Objects.nonNull((Object)queryRslDictItemInfo)) {
                DictItemInfoVO outDictItemInfoVo = (DictItemInfoVO)((Object)this.beanCopy((Object)queryRslDictItemInfo, (Object)new DictItemInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outDictItemInfoVo.toString());
                return outDictItemInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<DictItemInfoVO> queryAll(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryAll(dictItemInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
            this.pageSet(dictItemInfos, dictItemInfoVo);
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryAllByLevelOne(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryAllByLevelOneByPage(dictItemInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
            this.pageSet(dictItemInfos, dictItemInfoVo);
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryAllByLevelTwo(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryAllByLevelTwoByPage(dictItemInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = null;
        try {
            this.pageSet(dictItemInfos, dictItemInfoVo);
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryAllByLevelThree(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryAllByLevelThreeByPage(dictItemInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = null;
        try {
            this.pageSet(dictItemInfos, dictItemInfoVo);
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryAllByLevelFour(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryAllByLevelFourByPage(dictItemInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = null;
        try {
            this.pageSet(dictItemInfos, dictItemInfoVo);
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryAllByLevelFive(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryAllByLevelFiveByPage(dictItemInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = null;
        try {
            this.pageSet(dictItemInfos, dictItemInfoVo);
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryByItemNames(List<String> itemNames, String objectId) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + itemNames.toString());
        List<DictItemInfo> dictItemInfos = this.dictItemInfoDao.queryByItemNames(itemNames, null);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = null;
        try {
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictItemInfoVO> queryByItemExtNames(List<String> itemNames, String objectId) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + itemNames.toString());
        List<DictItemInfo> dictItemInfos = this.dictItemExtDao.queryByItemNames(itemNames, null);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = null;
        try {
            list = this.beansCopy(dictItemInfos, DictItemInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public DictItemInfoVO createByField(ModelTableField field) {
        ModelTableFieldVO fieldVo = new ModelTableFieldVO();
        this.beanCopy((Object)field, (Object)fieldVo);
        return this.createByField(fieldVo);
    }

    @Override
    public int excelUpload(String type, List<DictItemInfoVO> list, List<DictCategoryInfoVO> cataList) {
        List<BaseInfo> sub;
        int end;
        int i;
        int cur;
        int loop;
        int num = -1;
        if (StringUtils.equals((String)"insert", (String)type)) {
            int rs = this.dictItemInfoDao.deleteAll();
            if (rs == -1) {
                return rs;
            }
            rs = this.dictCategoryInfoDao.deleteAll();
            if (rs == -1) {
                return rs;
            }
        }
        if (list.size() < 1000) {
            num += this.dictItemInfoDao.insertBatchDictItemInfo(list);
        } else {
            loop = this.calcLoop(list.size());
            cur = 0;
            for (i = 1; i <= loop; ++i) {
                end = 1000 * i;
                if (end > list.size()) {
                    end = list.size();
                }
                sub = list.subList(cur, end);
                cur += 1000;
                num += this.dictItemInfoDao.insertBatchDictItemInfo(sub);
            }
        }
        if (CollectionUtils.isNotEmpty(cataList)) {
            if (cataList.size() < 1000) {
                num += this.dictCategoryInfoDao.insertBatchDictCategoryInfo(cataList);
            } else {
                loop = this.calcLoop(cataList.size());
                cur = 0;
                for (i = 1; i <= loop; ++i) {
                    end = 1000 * i;
                    if (end > cataList.size()) {
                        end = cataList.size();
                    }
                    sub = cataList.subList(cur, end);
                    cur += 1000;
                    num += this.dictCategoryInfoDao.insertBatchDictCategoryInfo(sub);
                }
            }
        }
        return num;
    }

    @Override
    public Map<String, Object> queryStandardSummary(Map<String, Object> param) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + param);
        try {
            Map<String, Object> result = this.dictItemInfoDao.queryStandardSummary(param);
            return result;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryStdSummaryList(Map<String, Object> param) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + param);
        try {
            List<Map<String, Object>> result = this.dictItemInfoDao.queryStdSummaryList(param);
            return result;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    private int calcLoop(int size) {
        int loop = size / 1000;
        if (size % 1000 > 0) {
            return loop + 1;
        }
        return loop;
    }

    @Override
    public DictItemInfoVO createByField(ModelTableFieldVO field) {
        if (field == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getFieldCode())) {
            return null;
        }
        DictItemInfoVO param = new DictItemInfoVO();
        param.setItemCode(field.getFieldCode());
        List<DictItemInfo> checkResults = this.dictItemInfoDao.queryAll(param);
        if (CollectionUtils.isNotEmpty(checkResults)) {
            DictItemInfoVO re = new DictItemInfoVO();
            this.beanCopy((Object)checkResults.get(0), (Object)re);
            return re;
        }
        DictItemInfo newDict = new DictItemInfo();
        newDict.setItemId(KeyUtil.createUUIDKey());
        newDict.setCreateTime(field.getCreateTime());
        newDict.setCreateUser(field.getCreateUser());
        newDict.setItemCode(field.getFieldCode());
        newDict.setItemName(field.getFieldName());
        newDict.setItemDataLength(field.getFieldLength());
        newDict.setItemDataPrecision(field.getFieldPrecision());
        newDict.setOrderValue(field.getFieldOrder());
        PubDbmsDatatypeVO dbmsType = this.pubDbmsDatatypeService.queryDbmsTypeByCode(field.getObjectId(), field.getFieldType());
        if (dbmsType != null) {
            newDict.setItemDataType(dbmsType.getDatatypeId());
        }
        this.dictItemInfoDao.insertDictItemInfo(newDict);
        DictItemInfoVO re = new DictItemInfoVO();
        this.beanCopy((Object)newDict, (Object)re);
        return re;
    }

    @Override
    public List<DictItemInfoVO> queryAllForExcelByPage(DictItemInfoVO dictItemInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictItemInfoVO> list = null;
        try {
            list = this.dictItemInfoDao.queryAllForExcelByPage(dictItemInfoVo);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public String querySeqWithPrefix(String projectId) {
        String result = "";
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        try {
            String seq;
            result = this.dictItemInfoDao.querySeqWithPrefix(projectId);
            if (StringUtils.isBlank((String)result)) {
                result = projectId + "000";
            }
            String numStr = org.apache.commons.lang3.StringUtils.replaceOnce((String)result, (String)projectId, (String)"");
            int num = Integer.parseInt(numStr);
            result = seq = projectId + org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(num + 1), (int)3, (String)"0");
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public static enum PUB_DATA_TYPE {
        PUB_DATA_TYPE_100("100", "\u5b9a\u957f\u5b57\u7b26\u4e32", "CHAR"),
        PUB_DATA_TYPE_101("101", "\u5b9a\u957f\u5b57\u7b26\u4e32(\u53cc)", "NCHAR"),
        PUB_DATA_TYPE_200("200", "\u53ef\u53d8\u957f\u5b57\u7b26\u4e32", "VARCHAR"),
        PUB_DATA_TYPE_201("201", "\u53ef\u53d8\u957f\u5b57\u7b26\u4e32(\u53cc)", "NVARCHAR"),
        PUB_DATA_TYPE_300("300", "\u6574\u6570", "INT"),
        PUB_DATA_TYPE_301("301", "\u5927\u6574\u6570", "BIGINT"),
        PUB_DATA_TYPE_302("302", "\u5c0f\u6574\u6570", ""),
        PUB_DATA_TYPE_303("303", "\u65e0\u7b26\u53f7\u6574\u6570", ""),
        PUB_DATA_TYPE_310("310", "\u9ad8\u7cbe\u5ea6\u6d6e\u70b9\u6570", "DECIMAL"),
        PUB_DATA_TYPE_311("311", "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u6570", "DOUBLE"),
        PUB_DATA_TYPE_312("312", "\u5355\u7cbe\u5ea6\u6d6e\u70b9\u6570", "FLOAT"),
        PUB_DATA_TYPE_400("400", "\u957f\u6587\u672c", "LONGTEXT"),
        PUB_DATA_TYPE_401("401", "\u77ed\u6587\u672c", "TEXT"),
        PUB_DATA_TYPE_500("500", "\u65e5\u671f", "DATE"),
        PUB_DATA_TYPE_501("501", "\u65e5\u671f\u65f6\u95f4", "DATETIME"),
        PUB_DATA_TYPE_600("600", "\u65f6\u95f4\u6233", "TIMESTAMP"),
        PUB_DATA_TYPE_601("601", "\u65f6\u95f4", "TIME"),
        PUB_DATA_TYPE_700("700", "\u5b57\u7b26\u5927\u6570\u636e", ""),
        PUB_DATA_TYPE_800("800", "\u4e8c\u8fdb\u5236\u5927\u6570\u636e", "LONGBLOB");

        private String code;
        private String name;
        private String sqlType;

        private PUB_DATA_TYPE(String code, String name, String sqlType) {
            this.code = code;
            this.name = name;
            this.sqlType = sqlType;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public static PUB_DATA_TYPE getBySqlType(String dataType) {
            if (dataType == null) {
                return null;
            }
            for (PUB_DATA_TYPE data : PUB_DATA_TYPE.values()) {
                if (!dataType.toUpperCase().startsWith(data.getSqlType())) continue;
                return data;
            }
            return null;
        }
    }
}

