/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.common.util.PinYinUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictOptionEnumDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictOptionInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictWordInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableFieldDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictOptionEnum;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictOptionInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictWordInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableField;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionEnumService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionEnumVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.SDicVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictOptionEnumService")
public class DictOptionEnumServiceImpl
implements DictOptionEnumService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(DictOptionEnumServiceImpl.class);
    @Autowired
    private DictOptionEnumDao dictOptionEnumDao;
    @Autowired
    private ModelTableInfoDao modelTableInfoDao;
    @Autowired
    private ModelTableFieldDao modelTableFieldDao;
    @Autowired
    private DictItemInfoDao dictItemInfoDao;
    @Autowired
    private DictOptionInfoDao dictOptionInfoDao;
    @Autowired
    private DictWordInfoDao dictWordInfoDao;

    @Override
    public int insertDictOptionEnum(DictOptionEnumVO inDictOptionEnumVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inDictOptionEnumVo.toString());
        int num = 0;
        try {
            DictOptionEnum dictOptionEnum = new DictOptionEnum();
            this.beanCopy((Object)inDictOptionEnumVo, (Object)dictOptionEnum);
            num = this.dictOptionEnumDao.insertDictOptionEnum(dictOptionEnum);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(DictOptionEnumVO inDictOptionEnumVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inDictOptionEnumVo));
        int num = 0;
        try {
            DictOptionEnum dictOptionEnum = new DictOptionEnum();
            this.beanCopy((Object)inDictOptionEnumVo, (Object)dictOptionEnum);
            num = this.dictOptionEnumDao.deleteByPk(dictOptionEnum);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictOptionEnumVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(DictOptionEnumVO inDictOptionEnumVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inDictOptionEnumVo.toString());
        int num = 0;
        try {
            DictOptionEnum dictOptionEnum = new DictOptionEnum();
            this.beanCopy((Object)inDictOptionEnumVo, (Object)dictOptionEnum);
            num = this.dictOptionEnumDao.updateByPk(dictOptionEnum);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictOptionEnumVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public DictOptionEnumVO queryByPk(DictOptionEnumVO inDictOptionEnumVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inDictOptionEnumVo));
        try {
            DictOptionEnum queryDictOptionEnum = new DictOptionEnum();
            this.beanCopy((Object)inDictOptionEnumVo, (Object)queryDictOptionEnum);
            DictOptionEnum queryRslDictOptionEnum = this.dictOptionEnumDao.queryByPk(queryDictOptionEnum);
            if (Objects.nonNull((Object)queryRslDictOptionEnum)) {
                DictOptionEnumVO outDictOptionEnumVo = (DictOptionEnumVO)((Object)this.beanCopy((Object)queryRslDictOptionEnum, (Object)new DictOptionEnumVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outDictOptionEnumVo.toString());
                return outDictOptionEnumVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<DictOptionEnumVO> queryAllByLevelOne(DictOptionEnumVO dictOptionEnumVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DictOptionEnum> dictOptionEnums = this.dictOptionEnumDao.queryAllByLevelOneByPage(dictOptionEnumVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionEnums.size());
            this.pageSet(dictOptionEnums, dictOptionEnumVo);
            list = this.beansCopy(dictOptionEnums, DictOptionEnumVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionEnumVO> queryAllByLevelTwo(DictOptionEnumVO dictOptionEnumVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionEnum> dictOptionEnums = this.dictOptionEnumDao.queryAllByLevelTwoByPage(dictOptionEnumVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionEnums.size());
        List list = null;
        try {
            this.pageSet(dictOptionEnums, dictOptionEnumVo);
            list = this.beansCopy(dictOptionEnums, DictOptionEnumVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionEnumVO> queryAllByLevelThree(DictOptionEnumVO dictOptionEnumVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionEnum> dictOptionEnums = this.dictOptionEnumDao.queryAllByLevelThreeByPage(dictOptionEnumVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionEnums.size());
        List list = null;
        try {
            this.pageSet(dictOptionEnums, dictOptionEnumVo);
            list = this.beansCopy(dictOptionEnums, DictOptionEnumVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionEnumVO> queryAllByLevelFour(DictOptionEnumVO dictOptionEnumVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionEnum> dictOptionEnums = this.dictOptionEnumDao.queryAllByLevelFourByPage(dictOptionEnumVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionEnums.size());
        List list = null;
        try {
            this.pageSet(dictOptionEnums, dictOptionEnumVo);
            list = this.beansCopy(dictOptionEnums, DictOptionEnumVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionEnumVO> queryAllByLevelFive(DictOptionEnumVO dictOptionEnumVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionEnum> dictOptionEnums = this.dictOptionEnumDao.queryAllByLevelFiveByPage(dictOptionEnumVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionEnums.size());
        List list = null;
        try {
            this.pageSet(dictOptionEnums, dictOptionEnumVo);
            list = this.beansCopy(dictOptionEnums, DictOptionEnumVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionEnumVO> queryAllByDictId(String dictId) {
        List<DictOptionEnum> dictOptionEnums = this.dictOptionEnumDao.queryAllByDictId(dictId);
        List list = null;
        try {
            list = this.beansCopy(dictOptionEnums, DictOptionEnumVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int deleteByDictId(String dictId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + dictId);
        int num = 0;
        try {
            num = this.dictOptionEnumDao.deleteByDictId(dictId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + dictId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public List<SDicVO> queryModelTableFieldDicts(String fieldId) {
        ModelTableField fieldParam = new ModelTableField();
        fieldParam.setFieldId(fieldId);
        ModelTableField field = this.modelTableFieldDao.queryByPk(fieldParam);
        return this.queryModelTableFieldDicts(field);
    }

    @Override
    public List<SDicVO> queryModelTableAllDicts(String tableObjectId) {
        ModelTableFieldVO fieldParam = new ModelTableFieldVO();
        fieldParam.setObjectId(tableObjectId);
        List<ModelTableField> fieldList = this.modelTableFieldDao.queryModelTableField(fieldParam);
        if (CollectionUtils.isEmpty(fieldList)) {
            return Collections.emptyList();
        }
        ArrayList<SDicVO> result = new ArrayList<SDicVO>();
        for (ModelTableField field : fieldList) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getFieldOption())) continue;
            result.addAll(this.queryModelTableFieldDicts(field));
        }
        return result;
    }

    @Override
    public int formatOptionEnumEmpty() {
        int num = 0;
        DictOptionInfoVO optionParam = new DictOptionInfoVO();
        optionParam.setSize(Integer.MAX_VALUE);
        List<DictOptionInfo> optionList = this.dictOptionInfoDao.queryAllByLevelOneByPage(optionParam);
        Pattern pattern = Pattern.compile("^[a-zA-Z\\$\\_][a-zA-Z\\$\\_0-9]{1,39}");
        if (CollectionUtils.isNotEmpty(optionList)) {
            for (DictOptionInfo option : optionList) {
                List<DictOptionEnum> enumList = this.dictOptionEnumDao.queryAllByDictId(option.getDictId());
                if (CollectionUtils.isEmpty(enumList)) continue;
                HashMap<String, DictOptionEnum> enumMap = new HashMap<String, DictOptionEnum>();
                ArrayList<DictOptionEnum> updateList = new ArrayList<DictOptionEnum>();
                for (DictOptionEnum de : enumList) {
                    Matcher m;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)de.getOptionEnum()) && (m = pattern.matcher(de.getOptionEnum())).matches()) continue;
                    try {
                        String optionName = de.getOptionName();
                        String formatName = "";
                        String pyEnum = PinYinUtil.getPinYinHeadChar(optionName);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pyEnum)) {
                            formatName = org.apache.commons.lang3.StringUtils.upperCase((String)pyEnum);
                        } else {
                            String wordEnum = this.getNewFieldCodeByCnName(optionName);
                            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wordEnum)) continue;
                            formatName = org.apache.commons.lang3.StringUtils.upperCase((String)wordEnum);
                        }
                        formatName = PinYinUtil.wrapperStr(formatName);
                        de.setOptionEnum(formatName);
                        if (enumMap.get(formatName) != null) {
                            de.setOptionEnum(String.format("%s%s", formatName, de.getOptionCode()));
                        }
                        enumMap.put(formatName, de);
                        updateList.add(de);
                    }
                    catch (Exception e) {
                        logger.error("\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
                    }
                }
                for (DictOptionEnum de : updateList) {
                    this.dictOptionEnumDao.updateByPk(de);
                }
            }
        }
        return num;
    }

    private String getNewFieldCodeByCnName(String fieldName) {
        String newFieldCode = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return newFieldCode;
        }
        String currentName = fieldName;
        int strLen = fieldName.length();
        int currentIdx = strLen - 1;
        ArrayList<String> findWords = new ArrayList<String>(strLen);
        if (currentIdx > 0) {
            List<DictWordInfo> words;
            int currentLen = currentName.length();
            ArrayList<String> itemNames = new ArrayList<String>(currentLen);
            for (int i = 0; i < currentLen; ++i) {
                itemNames.add(StringUtils.substring((String)currentName, (int)i, (int)currentLen));
            }
            if (!itemNames.isEmpty() && CollectionUtils.isNotEmpty(words = this.dictWordInfoDao.queryByCNNames(itemNames))) {
                words.sort(new Comparator<DictWordInfo>(){

                    @Override
                    public int compare(DictWordInfo o1, DictWordInfo o2) {
                        return Integer.compare(o1.getWordCnDesc().length(), o2.getWordCnDesc().length()) * -1;
                    }
                });
                DictWordInfo word = words.get(0);
                if (word.getWordCnDesc().length() == currentLen) {
                    findWords.add(word.getWordEnDesc());
                }
            }
        }
        StringBuffer newFieldCodeBf = new StringBuffer();
        for (int i = findWords.size() - 1; i >= 0; --i) {
            newFieldCodeBf.append((String)findWords.get(i));
            if (i <= 0) continue;
            newFieldCodeBf.append("_");
        }
        newFieldCode = newFieldCodeBf.toString();
        return newFieldCode;
    }

    private List<SDicVO> queryModelTableFieldDicts(ModelTableField field) {
        if (Objects.isNull((Object)field) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getDictId())) {
            return Collections.emptyList();
        }
        DictOptionInfo optionParam = new DictOptionInfo();
        optionParam.setDictId(field.getDictId());
        DictOptionInfo optionInfo = this.dictOptionInfoDao.queryByPk(optionParam);
        if (Objects.isNull((Object)optionInfo) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)optionInfo.getDictId())) {
            return Collections.emptyList();
        }
        DictOptionEnum enumParam = new DictOptionEnum();
        enumParam.setDictId(optionInfo.getDictId());
        List<DictOptionEnum> enumList = this.dictOptionEnumDao.queryAllByDictId(optionInfo.getDictId());
        if (CollectionUtils.isEmpty(enumList)) {
            return Collections.emptyList();
        }
        ArrayList<SDicVO> result = new ArrayList<SDicVO>(enumList.size());
        String opttype = optionInfo.getDictCode().toUpperCase();
        String memo = optionInfo.getDictName();
        for (DictOptionEnum dict : enumList) {
            SDicVO vo = new SDicVO();
            vo.setOpttype(opttype);
            vo.setMemo(memo);
            vo.setEnname(dict.getOptionCode());
            vo.setCnname(dict.getOptionName());
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<DictOptionVO> queryAllOptionForExcel(DictOptionEnumVO dictOptionEnum) {
        List<DictOptionVO> list = this.dictOptionEnumDao.queryAllOptionForExcelByPage(dictOptionEnum);
        return list;
    }
}

