/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.common.enums.AccessLevel;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PublishState;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictOptionEnumDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictOptionInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableFieldDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictItemInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictOptionEnum;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictOptionInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableField;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictItemInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionEnumVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictOptionInfoService")
public class DictOptionInfoServiceImpl
implements DictOptionInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(DictOptionInfoServiceImpl.class);
    @Autowired
    private DictOptionInfoDao dictOptionInfoDao;
    @Autowired
    private DictOptionEnumDao dictOptionEnumDao;
    @Autowired
    private ModelTableFieldDao modelTableFieldDao;
    @Autowired
    private DictItemInfoDao dictItemInfoDao;

    @Override
    public int insertDictOptionInfo(DictOptionInfoVO inDictOptionInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inDictOptionInfoVo.toString());
        int num = 0;
        try {
            DictOptionInfo dictOptionInfo = new DictOptionInfo();
            this.beanCopy((Object)inDictOptionInfoVo, (Object)dictOptionInfo);
            num = this.dictOptionInfoDao.insertDictOptionInfo(dictOptionInfo);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(DictOptionInfoVO inDictOptionInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inDictOptionInfoVo));
        int num = 0;
        try {
            DictOptionInfo dictOptionInfo = new DictOptionInfo();
            this.beanCopy((Object)inDictOptionInfoVo, (Object)dictOptionInfo);
            num = this.dictOptionInfoDao.deleteByPk(dictOptionInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictOptionInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(DictOptionInfoVO inDictOptionInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inDictOptionInfoVo.toString());
        int num = 0;
        try {
            DictOptionInfo dictOptionInfo = new DictOptionInfo();
            this.beanCopy((Object)inDictOptionInfoVo, (Object)dictOptionInfo);
            num = this.dictOptionInfoDao.updateByPk(dictOptionInfo);
            ModelTableField fieldUpdate = new ModelTableField();
            fieldUpdate.setDictId(inDictOptionInfoVo.getDictId());
            fieldUpdate.setFieldOption(inDictOptionInfoVo.getDictCode());
            this.modelTableFieldDao.updateByDictId(fieldUpdate);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inDictOptionInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public DictOptionInfoVO queryByPk(DictOptionInfoVO inDictOptionInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inDictOptionInfoVo));
        try {
            DictOptionInfo queryDictOptionInfo = new DictOptionInfo();
            this.beanCopy((Object)inDictOptionInfoVo, (Object)queryDictOptionInfo);
            DictOptionInfo queryRslDictOptionInfo = this.dictOptionInfoDao.queryByPk(queryDictOptionInfo);
            if (Objects.nonNull((Object)queryRslDictOptionInfo)) {
                DictOptionInfoVO outDictOptionInfoVo = (DictOptionInfoVO)((Object)this.beanCopy((Object)queryRslDictOptionInfo, (Object)new DictOptionInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outDictOptionInfoVo.toString());
                return outDictOptionInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<DictOptionInfoVO> queryAllByLevelOne(DictOptionInfoVO dictOptionInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryAllByLevelOneByPage(dictOptionInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
            this.pageSet(dictOptionInfos, dictOptionInfoVo);
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionInfoVO> queryAllByLevelTwo(DictOptionInfoVO dictOptionInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryAllByLevelTwoByPage(dictOptionInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
        List list = null;
        try {
            this.pageSet(dictOptionInfos, dictOptionInfoVo);
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionInfoVO> queryAllByLevelThree(DictOptionInfoVO dictOptionInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryAllByLevelThreeByPage(dictOptionInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
        List list = null;
        try {
            this.pageSet(dictOptionInfos, dictOptionInfoVo);
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionInfoVO> queryAllByLevelFour(DictOptionInfoVO dictOptionInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryAllByLevelFourByPage(dictOptionInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
        List list = null;
        try {
            this.pageSet(dictOptionInfos, dictOptionInfoVo);
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionInfoVO> queryAllByLevelFive(DictOptionInfoVO dictOptionInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryAllByLevelFiveByPage(dictOptionInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
        List list = null;
        try {
            this.pageSet(dictOptionInfos, dictOptionInfoVo);
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<DictOptionInfoVO> queryAllByProjectId(String projectId) {
        logger.debug("\u67e5\u8be2\u5de5\u7a0b{}\u4e0b\u6240\u6709\u5b57\u5178\u6570\u636e:", (Object)projectId);
        List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryAllByProjectId(projectId);
        List list = null;
        try {
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<DictOptionInfoVO> queryByDictNames(List<String> dictNames) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + dictNames.toString());
        List<DictOptionInfo> dictOptionInfos = this.dictOptionInfoDao.queryByDictNames(dictNames);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
        List list = null;
        try {
            list = this.beansCopy(dictOptionInfos, DictOptionInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int excelUpload(String type, List<DictOptionInfoVO> list, List<DictOptionEnumVO> enumList) {
        List<BaseInfo> sub;
        int num = -1;
        if (StringUtils.equals((String)"insert", (String)type)) {
            int end;
            int i;
            int cur;
            int loop;
            int rs = this.dictOptionInfoDao.deleteAll();
            if (rs == -1) {
                return rs;
            }
            rs = this.dictOptionEnumDao.deleteAll();
            if (rs == -1) {
                return rs;
            }
            if (list.size() < 1000) {
                num += this.dictOptionInfoDao.insertBatchDictOptionInfo(list);
            } else {
                loop = this.calcLoop(list.size());
                cur = 0;
                for (i = 1; i <= loop; ++i) {
                    end = 1000 * i;
                    if (end > list.size()) {
                        end = list.size();
                    }
                    sub = list.subList(cur, end);
                    cur += 1000;
                    num += this.dictOptionInfoDao.insertBatchDictOptionInfo(sub);
                }
            }
            if (enumList.size() <= 1000) {
                num += this.dictOptionEnumDao.insertBatchDictOptionEnum(enumList);
            } else {
                loop = this.calcLoop(enumList.size());
                cur = 0;
                for (i = 1; i <= loop; ++i) {
                    end = 1000 * i;
                    if (end > enumList.size()) {
                        end = enumList.size();
                    }
                    sub = enumList.subList(cur, end);
                    cur += 1000;
                    num += this.dictOptionEnumDao.insertBatchDictOptionEnum(sub);
                }
            }
        } else {
            ArrayList<DictOptionEnumVO> insertList = new ArrayList<DictOptionEnumVO>();
            for (DictOptionInfoVO infoVO : list) {
                DictOptionInfo info = new DictOptionInfo();
                this.beanCopy((Object)infoVO, (Object)info);
                this.dictOptionInfoDao.deleteByPk(info);
                this.dictOptionInfoDao.insertDictOptionInfo(info);
            }
            for (DictOptionEnumVO enumVO : enumList) {
                DictOptionEnumVO enumParam = new DictOptionEnumVO();
                enumParam.setDictId(enumVO.getDictId());
                enumParam.setOptionCode(enumVO.getOptionCode());
                List<DictOptionEnum> exists = this.dictOptionEnumDao.queryAllByLevelOneByPage(enumParam);
                if (CollectionUtils.isNotEmpty(exists)) {
                    DictOptionEnum existsObj = exists.get(0);
                    String optionId = existsObj.getOptionId();
                    this.beanCopy((Object)enumVO, (Object)existsObj);
                    existsObj.setOptionId(optionId);
                    this.dictOptionEnumDao.updateByPk(existsObj);
                    continue;
                }
                insertList.add(enumVO);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                if (insertList.size() <= 1000) {
                    num += this.dictOptionEnumDao.insertBatchDictOptionEnum(insertList);
                } else {
                    int loop = this.calcLoop(insertList.size());
                    int cur = 0;
                    for (int i = 1; i <= loop; ++i) {
                        int end = 1000 * i;
                        if (end > insertList.size()) {
                            end = insertList.size();
                        }
                        sub = insertList.subList(cur, end);
                        cur += 1000;
                        num += this.dictOptionEnumDao.insertBatchDictOptionEnum(sub);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(list) && org.apache.commons.lang3.StringUtils.equals((CharSequence)list.get(0).getAccessLevel(), (CharSequence)AccessLevel.PrivateLevel.getCode())) {
            ArrayList<DictItemInfoVO> insertItemList = new ArrayList<DictItemInfoVO>();
            String now = CurrentDateUtil.getTodayDateEx2();
            for (DictOptionInfoVO infoVO : list) {
                DictItemInfo itemInfo = new DictItemInfo();
                itemInfo.setItemId(infoVO.getDictId());
                DictItemInfo checkObj = this.dictItemInfoDao.queryByPk(itemInfo);
                if (checkObj == null) {
                    itemInfo = new DictItemInfo();
                    itemInfo.setCreateUser(now);
                    itemInfo.setCreateTime(infoVO.getCreateUser());
                } else {
                    itemInfo = checkObj;
                }
                itemInfo.setItemCode(infoVO.getDictCode());
                itemInfo.setItemId(infoVO.getDictId());
                itemInfo.setItemDataType(100);
                itemInfo.setItemDataLength(infoVO.getCodeLen());
                itemInfo.setAccessLevel(infoVO.getAccessLevel());
                itemInfo.setProjectId(infoVO.getProjectId());
                itemInfo.setItemName(infoVO.getDictName());
                itemInfo.setPublishState(PublishState.Publish.getCode());
                itemInfo.setLastModifyTime(now);
                itemInfo.setLastModifyUser(infoVO.getCreateUser());
                itemInfo.setSuitType("0");
                itemInfo.setDictId(infoVO.getDictId());
                itemInfo.setDictCode(infoVO.getDictCode());
                if (checkObj == null) {
                    DictItemInfoVO itemVO = new DictItemInfoVO();
                    this.beanCopy((Object)itemInfo, (Object)itemVO);
                    insertItemList.add(itemVO);
                    continue;
                }
                this.dictItemInfoDao.updateByPk(itemInfo);
            }
            if (CollectionUtils.isNotEmpty(insertItemList)) {
                this.dictItemInfoDao.insertBatchDictItemInfo(insertItemList);
            }
        }
        return num;
    }

    @Override
    public String querySeqWithPrefix(String projectId) {
        String result = "";
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        try {
            String seq;
            result = this.dictItemInfoDao.querySeqWithPrefix(projectId);
            if (StringUtils.isBlank((String)result)) {
                result = projectId + "000";
            }
            String numStr = org.apache.commons.lang3.StringUtils.replaceOnce((String)result, (String)projectId, (String)"");
            int num = Integer.parseInt(numStr);
            result = seq = projectId + org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(num + 1), (int)3, (String)"0");
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    private int calcLoop(int size) {
        int loop = size / 1000;
        if (size % 1000 > 0) {
            return loop + 1;
        }
        return loop;
    }
}

