/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.common.enums.DataStdFlag;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DataMarkFlag;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemExtDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictItemInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictOptionInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.DictWordInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableFieldDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableIndexDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.PubDbmsDatatypeDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.SrvFieldFlagDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictItemInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictOptionInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.DictWordInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableField;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.PubDbmsDatatype;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.SrvFieldFlag;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictItemInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictWordInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDbmsDatatypeVO;
import com.irdstudio.allinpaas.executor.core.plugin.datarefactor.AnalysisTableMatchItemTask;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelTableFieldService")
public class ModelTableFieldServiceImpl
implements ModelTableFieldService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(ModelTableFieldServiceImpl.class);
    public static final Integer JAVA_DBMS_ID = 901;
    @Autowired
    private ModelTableFieldDao modelTableFieldDao;
    @Autowired
    private ModelTableInfoDao modelTableInfoDao;
    @Autowired
    private ModelTableIndexDao modelTableIndexDao;
    @Autowired
    private PubDbmsDatatypeDao pubDbmsDatatypeDao;
    @Autowired
    private DictWordInfoDao dictWordInfoDao;
    @Autowired
    private DictItemInfoDao dictItemInfoDao;
    @Autowired
    private DictItemExtDao dictItemExtDao;
    @Autowired
    private DictOptionInfoDao dictOptionInfoDao;
    @Autowired
    private SrvFieldFlagDao srvFieldFlagDao;

    @Override
    public int insertModelTableField(ModelTableFieldVO inModelTableFieldVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inModelTableFieldVo.toString());
        int num = 0;
        try {
            ModelTableField modelTableField = new ModelTableField();
            this.beanCopy((Object)inModelTableFieldVo, (Object)modelTableField);
            if (modelTableField.getMiddleDataType() != null && modelTableField.getMiddleDataType() > 0) {
                PubDbmsDatatypeVO dbmsDataParam = new PubDbmsDatatypeVO();
                dbmsDataParam.setDbmsId(JAVA_DBMS_ID);
                dbmsDataParam.setDatatypeId(modelTableField.getMiddleDataType());
                List<PubDbmsDatatype> javaDatas = this.pubDbmsDatatypeDao.queryAllByLevelOneByPage(dbmsDataParam);
                if (CollectionUtils.isNotEmpty(javaDatas)) {
                    PubDbmsDatatype javaData = javaDatas.get(0);
                    modelTableField.setJavaDataType(javaData.getDbmsDatatypeCode());
                }
            }
            modelTableField.setDataStdFlag(DataStdFlag.Auto.getCode());
            num = this.modelTableFieldDao.insertModelTableField(modelTableField);
            if (StringUtils.isNotBlank((String)inModelTableFieldVo.getSrvModelCatalog()) && StringUtils.isNotBlank((String)inModelTableFieldVo.getSrvModelType())) {
                SrvFieldFlag fieldFlag = new SrvFieldFlag();
                fieldFlag.setFieldId(modelTableField.getFieldId());
                fieldFlag.setObjectId(modelTableField.getObjectId());
                fieldFlag.setSrvModelType(inModelTableFieldVo.getSrvModelType());
                fieldFlag.setSrvModelCatalog(inModelTableFieldVo.getSrvModelCatalog());
                fieldFlag.setFieldFlag(inModelTableFieldVo.getFieldFlag());
                this.srvFieldFlagDao.insertSrvFieldFlag(fieldFlag);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(ModelTableFieldVO inModelTableFieldVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inModelTableFieldVo));
        int num = 0;
        try {
            ModelTableField modelTableField = new ModelTableField();
            this.beanCopy((Object)inModelTableFieldVo, (Object)modelTableField);
            num = this.modelTableFieldDao.deleteByPk(modelTableField);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inModelTableFieldVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(ModelTableFieldVO inModelTableFieldVo) {
        return this.updateByPk(inModelTableFieldVo, true);
    }

    @Override
    public int updateByPk(ModelTableFieldVO inModelTableFieldVo, boolean updateFieldName) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inModelTableFieldVo.toString());
        int num = 0;
        try {
            ModelTableField modelTableField = new ModelTableField();
            this.beanCopy((Object)inModelTableFieldVo, (Object)modelTableField);
            ModelTableField oldField = this.modelTableFieldDao.queryByPk(modelTableField);
            if (updateFieldName) {
                if (!StringUtils.equals((String)oldField.getFieldCode(), (String)modelTableField.getFieldCode())) {
                    String oldFieldCode = "\"paramFieldCode\":\"" + oldField.getFieldCode() + "\"";
                    String newFieldCode = "\"paramFieldCode\":\"" + modelTableField.getFieldCode() + "\"";
                    this.modelTableFieldDao.updateOsrvEvalIsrvFieldCode(modelTableField.getFieldId(), oldFieldCode, newFieldCode);
                    this.modelTableFieldDao.updateIsrvValidateRuleFieldCode(modelTableField.getFieldId(), oldFieldCode, newFieldCode);
                }
                if (!StringUtils.equals((String)oldField.getFieldName(), (String)modelTableField.getFieldName())) {
                    String oldFieldName = "\"paramFieldName\":\"" + oldField.getFieldName() + "\"";
                    String newFieldName = "\"paramFieldName\":\"" + modelTableField.getFieldName() + "\"";
                    this.modelTableFieldDao.updateOsrvEvalIsrvFieldName(modelTableField.getFieldId(), oldFieldName, newFieldName);
                    this.modelTableFieldDao.updateIsrvValidateRuleFieldName(modelTableField.getFieldId(), oldFieldName, newFieldName);
                }
                ArrayList<ModelTableFieldVO> list = new ArrayList<ModelTableFieldVO>();
                list.add(inModelTableFieldVo);
                this.modelTableFieldDao.updateBacthIsrvEvalInsert(list);
                this.modelTableFieldDao.updateBacthIsrvEvalInsertDomainField(list);
                this.modelTableFieldDao.updateBacthIsrvEvalInsertWay(list);
                this.modelTableFieldDao.updateBacthIsrvEvalOut(list);
                this.modelTableFieldDao.updateBacthIsrvEvalOutDomainField(list);
                this.modelTableFieldDao.updateBacthIsrvEvalOutWay(list);
                this.modelTableFieldDao.updateBacthIsrvEvalUpdate(list);
                this.modelTableFieldDao.updateBacthIsrvEvalUpdateDomainField(list);
                this.modelTableFieldDao.updateBacthIsrvEvalUpdateWay(list);
                this.modelTableFieldDao.updateBacthIsrvSqlCond(list);
                this.modelTableFieldDao.updateBacthIsrvSqlCondDomainField(list);
                this.modelTableFieldDao.updateBacthIsrvSqlCondWay(list);
                this.modelTableFieldDao.updateBacthOsrvEvalIsrv(list);
                this.modelTableFieldDao.updateBacthOsrvEvalVar(list);
                if (modelTableField.getMiddleDataType() != null && modelTableField.getMiddleDataType() > 0 && oldField.getMiddleDataType() != modelTableField.getMiddleDataType()) {
                    PubDbmsDatatypeVO dbmsDataParam = new PubDbmsDatatypeVO();
                    dbmsDataParam.setDbmsId(JAVA_DBMS_ID);
                    dbmsDataParam.setDatatypeId(modelTableField.getMiddleDataType());
                    List<PubDbmsDatatype> javaDatas = this.pubDbmsDatatypeDao.queryAllByLevelOneByPage(dbmsDataParam);
                    if (CollectionUtils.isNotEmpty(javaDatas)) {
                        PubDbmsDatatype javaData = javaDatas.get(0);
                        modelTableField.setJavaDataType(javaData.getDbmsDatatypeCode());
                    }
                }
            }
            num = this.modelTableFieldDao.updateByPk(modelTableField);
            if (StringUtils.isNotBlank((String)inModelTableFieldVo.getSrvModelCatalog()) && StringUtils.isNotBlank((String)inModelTableFieldVo.getSrvModelType())) {
                SrvFieldFlag fieldFlag = new SrvFieldFlag();
                fieldFlag.setFieldId(modelTableField.getFieldId());
                fieldFlag.setObjectId(modelTableField.getObjectId());
                fieldFlag.setSrvModelType(inModelTableFieldVo.getSrvModelType());
                fieldFlag.setSrvModelCatalog(inModelTableFieldVo.getSrvModelCatalog());
                fieldFlag.setFieldFlag(inModelTableFieldVo.getFieldFlag());
                this.srvFieldFlagDao.insertSrvFieldFlag(fieldFlag);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inModelTableFieldVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateOsrvEvalIsrvFieldCode(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisrvFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateOsrvEvalIsrvFieldCode(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    @Override
    public int updateIsrvValidateRuleFieldCode(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisrvFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateIsrvValidateRuleFieldCode(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    @Override
    public int updateOsrvEvalIsrvFieldName(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisrvFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateOsrvEvalIsrvFieldName(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    @Override
    public int updateIsrvValidateRuleFieldName(String isrvFieldId, String oldIsrvFieldCode, String newIsrvFieldCode) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3aisurlFieldId:{},oldIsrvFieldCode:{},newIsrvFieldCode:{}:", new Object[]{isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode});
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateIsrvValidateRuleFieldName(isrvFieldId, oldIsrvFieldCode, newIsrvFieldCode);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    @Override
    public int updateBatchFieldInfo(List<ModelTableFieldVO> list) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u6570\u91cf\u4e3a:" + list.size());
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateBacthFiledInfo(list);
            this.modelTableFieldDao.updateBacthDictItem(list);
            this.modelTableFieldDao.updateBacthIsrvEvalInsert(list);
            this.modelTableFieldDao.updateBacthIsrvEvalInsertDomainField(list);
            this.modelTableFieldDao.updateBacthIsrvEvalOut(list);
            this.modelTableFieldDao.updateBacthIsrvEvalOutDomainField(list);
            this.modelTableFieldDao.updateBacthIsrvEvalUpdate(list);
            this.modelTableFieldDao.updateBacthIsrvEvalUpdateDomainField(list);
            this.modelTableFieldDao.updateBacthIsrvSqlCond(list);
            this.modelTableFieldDao.updateBacthIsrvSqlCondDomainField(list);
            this.modelTableFieldDao.updateBacthOsrvEvalIsrv(list);
            this.modelTableFieldDao.updateBacthOsrvEvalVar(list);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateBatchFieldInfoOnly(List<ModelTableFieldVO> list) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u6570\u91cf\u4e3a:" + list.size());
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateBacthFiledInfo(list);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateFieldByPk(ModelTableFieldVO inModelTableFieldVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inModelTableFieldVo.toString());
        int num = 0;
        try {
            ModelTableField modelTableField = new ModelTableField();
            this.beanCopy((Object)inModelTableFieldVo, (Object)modelTableField);
            num = this.modelTableFieldDao.updateByPk(modelTableField);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public ModelTableFieldVO queryByPk(ModelTableFieldVO inModelTableFieldVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inModelTableFieldVo));
        try {
            ModelTableField queryModelTableField = new ModelTableField();
            this.beanCopy((Object)inModelTableFieldVo, (Object)queryModelTableField);
            ModelTableField queryRslModelTableField = this.modelTableFieldDao.queryByPk(queryModelTableField);
            if (Objects.nonNull((Object)queryRslModelTableField)) {
                ModelTableFieldVO outModelTableFieldVo = (ModelTableFieldVO)((Object)this.beanCopy((Object)queryRslModelTableField, (Object)new ModelTableFieldVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outModelTableFieldVo.toString());
                return outModelTableFieldVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<ModelTableFieldVO> queryAllByLevelOne(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryAllByLevelOneByPage(modelTableFieldVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryModelTableFields(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryModelTableFields(modelTableFieldVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryAllByLevelTwo(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryAllByLevelTwoByPage(modelTableFieldVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
        List list = null;
        try {
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryAllByLevelThree(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryAllByLevelThreeByPage(modelTableFieldVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
        List list = null;
        try {
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryAllByLevelFour(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryAllByLevelFourByPage(modelTableFieldVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
        List list = null;
        try {
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryAllByLevelFive(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryAllByLevelFiveByPage(modelTableFieldVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
        List list = null;
        try {
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryModelTableField(ModelTableFieldVO mtfv) {
        logger.debug("\u67e5\u770b\u8868\u6a21\u578b\u4e0b\u7684\u5b57\u6bb5\u4fe1\u606f:");
        List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryModelTableField(mtfv);
        logger.debug("\u67e5\u770b\u8868\u6a21\u578b\u4e0b\u7684\u5b57\u6bb5\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
        List list = null;
        try {
            this.pageSet(modelTableFields, mtfv);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int getCurrentOrderValue(String objectId) {
        int maxValue = this.modelTableFieldDao.queryMaxFieldOrderValue(objectId);
        return maxValue + 1;
    }

    @Override
    public int fieldSortUp(String fieldId) {
        ModelTableField queryModelTableField = new ModelTableField();
        queryModelTableField.setFieldId(fieldId);
        ModelTableField currentField = this.modelTableFieldDao.queryByPk(queryModelTableField);
        ModelTableField preField = this.modelTableFieldDao.queryPreField(currentField);
        if (null == preField) {
            return 0;
        }
        ModelTableField currentFieldUpdate = new ModelTableField();
        currentFieldUpdate.setFieldId(currentField.getFieldId());
        currentFieldUpdate.setFieldOrder(preField.getFieldOrder());
        this.modelTableFieldDao.updateByPk(currentFieldUpdate);
        ModelTableField preFieldUpdate = new ModelTableField();
        preFieldUpdate.setFieldId(preField.getFieldId());
        preFieldUpdate.setFieldOrder(currentField.getFieldOrder());
        this.modelTableFieldDao.updateByPk(preFieldUpdate);
        return 1;
    }

    @Override
    public int doExchange(String sourceId, String targetId) {
        int num = 0;
        ModelTableField modelTableField = new ModelTableField();
        try {
            modelTableField.setFieldId(sourceId);
            ModelTableField source = this.modelTableFieldDao.queryByPk(modelTableField);
            modelTableField.setFieldId(targetId);
            ModelTableField target = this.modelTableFieldDao.queryByPk(modelTableField);
            int mid = source.getFieldOrder();
            source.setFieldOrder(target.getFieldOrder());
            target.setFieldOrder(mid);
            this.modelTableFieldDao.updateByPk(source);
            this.modelTableFieldDao.updateByPk(target);
            num = 2;
        }
        catch (Exception e) {
            logger.error("\u4ea4\u6362\u987a\u5e8f\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    @Override
    public int fieldSortDown(String fieldId) {
        ModelTableField queryModelTableField = new ModelTableField();
        queryModelTableField.setFieldId(fieldId);
        ModelTableField currentField = this.modelTableFieldDao.queryByPk(queryModelTableField);
        ModelTableField nextField = this.modelTableFieldDao.queryNextField(currentField);
        if (null == nextField) {
            return 0;
        }
        ModelTableField currentFieldUpdate = new ModelTableField();
        currentFieldUpdate.setFieldId(currentField.getFieldId());
        currentFieldUpdate.setFieldOrder(nextField.getFieldOrder());
        this.modelTableFieldDao.updateByPk(currentFieldUpdate);
        ModelTableField nextFieldUpdate = new ModelTableField();
        nextFieldUpdate.setFieldId(nextField.getFieldId());
        nextFieldUpdate.setFieldOrder(currentField.getFieldOrder());
        this.modelTableFieldDao.updateByPk(nextFieldUpdate);
        return 1;
    }

    @Override
    public int updateFieldInfoWithItem(String projectId, int projectDbms) {
        logger.debug("\u66f4\u65b0\u8868\u6a21\u578b\u5e93\u4e0b\u6240\u6709\u5b57\u6bb5\u7c7b\u578b\u76f8\u5173\u7684\u4fe1\u606f:{},{}", (Object)projectId, (Object)projectDbms);
        int num = 0;
        try {
            num = this.modelTableFieldDao.updateFieldInfoWithItem(projectId, projectDbms);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6\u66f4\u65b0\u8868\u6a21\u578b\u5e93\u4e0b\u6240\u6709\u5b57\u6bb5\u7c7b\u578b\u76f8\u5173\u7684\u4fe1\u606f\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int deleteByObjectId(String objectId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + objectId);
        int num = 0;
        try {
            num = this.modelTableFieldDao.deleteByObjectId(objectId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + objectId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int deleteByObjectIds(List<String> objectIds) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + objectIds);
        int num = 0;
        try {
            num = this.modelTableFieldDao.deleteByObjectIds(objectIds);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + objectIds + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int copyModelTableField(String objectId, String targetObjectId) {
        int num = this.modelTableFieldDao.copyModelTableField(objectId, targetObjectId);
        return num;
    }

    @Override
    public int mergeModelTableField(String objectId, String srcObjectId) {
        List<ModelTableField> fieldList = this.modelTableFieldDao.queryMergeModelTableFields(objectId, srcObjectId);
        int order = this.getCurrentOrderValue(objectId);
        if (CollectionUtils.isNotEmpty(fieldList)) {
            for (ModelTableField ff : fieldList) {
                ff.setFieldId(UUIDUtil.getUUID());
                ff.setObjectId(objectId);
                ff.setFieldOrder(order++);
                ff.setDataStdFlag(DataStdFlag.Auto.getCode());
                this.modelTableFieldDao.insertModelTableField(ff);
            }
        }
        this.modelTableFieldDao.deleteByObjectId(srcObjectId);
        this.modelTableIndexDao.deleteByObjectId(srcObjectId);
        ModelTableInfo srcTable = new ModelTableInfo();
        srcTable.setObjectId(srcObjectId);
        this.modelTableInfoDao.deleteByPk(srcTable);
        return fieldList.size();
    }

    @Override
    public List<ModelTableFieldVO> queryByItemId(String itemId) {
        logger.debug("\u67e5\u8be2\u6570\u636e\u6761\u76ee{}\u6240\u5f15\u7528\u7684\u5b57\u6bb5\u4fe1\u606f!", (Object)itemId);
        List list = null;
        try {
            List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryByItemId(itemId);
            logger.debug("\u67e5\u8be2\u6570\u636e\u6761\u76ee{}\u6240\u5f15\u7528\u7684\u5b57\u6bb5\u6570\u91cf\u4e3a{}" + itemId, (Object)modelTableFields.size());
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public String getNewFieldCodeByCnName(String fieldName) {
        String newFieldCode = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return newFieldCode;
        }
        String currentName = fieldName;
        int strLen = fieldName.length();
        int currentIdx = strLen - 1;
        ArrayList<String> findWords = new ArrayList<String>(strLen);
        while (currentIdx > 0) {
            int currentLen = currentName.length();
            ArrayList<String> itemNames = new ArrayList<String>(currentLen);
            for (int i = 0; i < currentLen; ++i) {
                itemNames.add(StringUtils.substring((String)currentName, (int)i, (int)currentLen));
            }
            if (itemNames.isEmpty()) break;
            List<DictWordInfo> list = this.dictWordInfoDao.queryByCNNames(itemNames);
            try {
                List words = this.beansCopy(list, DictWordInfoVO.class);
                if (!CollectionUtils.isNotEmpty((Collection)words)) break;
                words.sort(new Comparator<DictWordInfoVO>(){

                    @Override
                    public int compare(DictWordInfoVO o1, DictWordInfoVO o2) {
                        return Integer.compare(o1.getWordCnDesc().length(), o2.getWordCnDesc().length()) * -1;
                    }
                });
                DictWordInfoVO word = (DictWordInfoVO)((Object)words.get(0));
                if (word.getWordCnDesc().length() == currentLen) {
                    findWords.add(word.getWordEnDesc());
                    break;
                }
                currentIdx = fieldName.lastIndexOf(word.getWordCnDesc());
                int wordIdx = currentName.lastIndexOf(word.getWordCnDesc());
                currentName = StringUtils.substring((String)currentName, (int)0, (int)wordIdx);
                findWords.add(word.getWordEnDesc());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        StringBuffer newFieldCodeBf = new StringBuffer();
        for (int i = findWords.size() - 1; i >= 0; --i) {
            newFieldCodeBf.append((String)findWords.get(i));
            if (i <= 0) continue;
            newFieldCodeBf.append("_");
        }
        newFieldCode = newFieldCodeBf.toString();
        return newFieldCode;
    }

    @Override
    public DictItemInfoVO getItemByFieldName(final String fieldName, String objectId) {
        DictItemInfoVO dictItemInfo = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return dictItemInfo;
        }
        List itemNames = AnalysisTableMatchItemTask.splitName((String)fieldName);
        if (itemNames.isEmpty()) {
            return dictItemInfo;
        }
        List dictList = AnalysisTableMatchItemTask.matchItemFormCached((List)itemNames, DictItemInfoVO.class);
        if (CollectionUtils.isNotEmpty((Collection)dictList)) {
            dictItemInfo = (DictItemInfoVO)((Object)dictList.get(0));
            return dictItemInfo;
        }
        try {
            List<DictItemInfo> newList;
            List<DictItemInfo> list = this.dictItemExtDao.queryByItemNames(itemNames, null);
            dictList = this.beansCopy(list, DictItemInfoVO.class);
            if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                AnalysisTableMatchItemTask.pushItemListIntoCached((List)dictList);
                dictList.sort(new Comparator<DictItemInfoVO>(){

                    @Override
                    public int compare(DictItemInfoVO o1, DictItemInfoVO o2) {
                        if (StringUtils.equals((String)o1.getExtName(), (String)fieldName)) {
                            return -1;
                        }
                        if (StringUtils.equals((String)o2.getExtName(), (String)fieldName)) {
                            return 1;
                        }
                        return Integer.compare(o1.getExtName().length(), o2.getExtName().length()) * -1;
                    }
                });
                dictItemInfo = (DictItemInfoVO)((Object)dictList.get(0));
            }
            if (CollectionUtils.isEmpty((Collection)dictList) && CollectionUtils.isNotEmpty((Collection)(dictList = this.beansCopy(newList = this.dictItemInfoDao.queryByItemNames(itemNames, null), DictItemInfoVO.class)))) {
                AnalysisTableMatchItemTask.pushItemListIntoCached((List)dictList);
                dictList.sort(new Comparator<DictItemInfoVO>(){

                    @Override
                    public int compare(DictItemInfoVO o1, DictItemInfoVO o2) {
                        if (StringUtils.equals((String)o1.getItemName(), (String)fieldName)) {
                            return -1;
                        }
                        if (StringUtils.equals((String)o2.getItemName(), (String)fieldName)) {
                            return 1;
                        }
                        return Integer.compare(o1.getItemName().length(), o2.getItemName().length()) * -1;
                    }
                });
                dictItemInfo = (DictItemInfoVO)((Object)dictList.get(0));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return dictItemInfo;
    }

    @Override
    public DictOptionInfoVO getDictOptionByFieldName(String fieldName) {
        DictOptionInfoVO option = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return option;
        }
        int strLen = fieldName.length();
        ArrayList<String> itemNames = new ArrayList<String>(strLen);
        itemNames.add(fieldName + "\u4ee3\u7801");
        for (int i = 0; i < strLen; ++i) {
            itemNames.add(StringUtils.substring((String)fieldName, (int)i, (int)strLen));
        }
        if (itemNames.isEmpty()) {
            return option;
        }
        List<DictOptionInfo> list = this.dictOptionInfoDao.queryByDictNames(itemNames);
        try {
            List dictList = this.beansCopy(list, DictOptionInfoVO.class);
            if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                dictList.sort(new Comparator<DictOptionInfoVO>(){

                    @Override
                    public int compare(DictOptionInfoVO o1, DictOptionInfoVO o2) {
                        return Integer.compare(o1.getDictName().length(), o2.getDictName().length()) * -1;
                    }
                });
                option = (DictOptionInfoVO)((Object)dictList.get(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return option;
    }

    @Override
    public Integer fieldRefactorByObjectId(String objectId, String dataMarkFlag, String userId) {
        try {
            String now = CurrentDateUtil.getTodayDateEx2();
            ModelTableFieldVO modelTableFieldVO = new ModelTableFieldVO();
            modelTableFieldVO.setObjectId(objectId);
            modelTableFieldVO.setItemIdNotNull(true);
            List list = new ArrayList();
            ArrayList newList = new ArrayList();
            DataMarkFlag markFlag = DataMarkFlag.getByCode(dataMarkFlag);
            if (markFlag == null) {
                markFlag = DataMarkFlag.TypeToPrecision;
            }
            int num = 0;
            List<ModelTableField> tmpList = this.modelTableFieldDao.queryModelTableFields(modelTableFieldVO);
            list = this.beansCopy(tmpList, ModelTableFieldVO.class);
            if (list.size() > 0) {
                List<PubDbmsDatatype> pubDbmsDatatypeVOS = this.pubDbmsDatatypeDao.queryDbmsTypeByModelTableInfoObjectId(objectId);
                HashMap<String, String> pubDbmsDatMap = new HashMap<String, String>();
                for (PubDbmsDatatype pd : pubDbmsDatatypeVOS) {
                    pubDbmsDatMap.put(String.valueOf(pd.getDatatypeId()), pd.getDbmsDatatypeCode());
                }
                for (ModelTableFieldVO field : list) {
                    if (StringUtils.equals((String)field.getDataStdFlag(), (String)DataStdFlag.NOT.getCode())) continue;
                    if (StringUtils.isEmpty((String)field.getDataMarkFlag()) || "\u672a\u843d\u6807".equals(field.getDataMarkFlag())) {
                        field.setPreFieldCode(field.getFieldCode());
                        field.setPreFieldLength(field.getFieldLength());
                        field.setPreFieldName(field.getFieldName());
                        field.setPreFieldType(field.getFieldType());
                        field.setPreFieldPrecision(field.getFieldPrecision());
                        field.setPreDictId(field.getDictId());
                    }
                    boolean needUpdate = false;
                    String fieldName = field.getFieldName();
                    DictItemInfo matchItemInfo = new DictItemInfo();
                    matchItemInfo.setItemId(field.getItemId());
                    matchItemInfo = this.dictItemInfoDao.queryByPk(matchItemInfo);
                    if (matchItemInfo != null) {
                        String fieldType;
                        field.setItemCode(matchItemInfo.getItemCode());
                        field.setItemName(matchItemInfo.getItemName());
                        field.setItemId(matchItemInfo.getItemId());
                        field.setMiddleDataType(matchItemInfo.getItemDataType());
                        if (DataMarkFlag.NameToOption == markFlag) {
                            field.setFieldName(matchItemInfo.getItemName());
                        }
                        if (StringUtils.isNotBlank((String)(fieldType = (String)pubDbmsDatMap.get(String.valueOf(matchItemInfo.getItemDataType()))))) {
                            field.setFieldType(fieldType);
                        }
                        field.setFieldLength(matchItemInfo.getItemDataLength());
                        field.setFieldPrecision(matchItemInfo.getItemDataPrecision());
                        if ((DataMarkFlag.NameToOption == markFlag || DataMarkFlag.TypeToOption == markFlag) && StringUtils.isNotBlank((String)matchItemInfo.getDictId())) {
                            field.setDictId(matchItemInfo.getDictId());
                            field.setFieldOption(matchItemInfo.getDictCode());
                        }
                        field.setDataMarkFlag(markFlag.getCode());
                        needUpdate = true;
                    } else {
                        field.setItemId("");
                        field.setItemCode("");
                        field.setItemName("");
                        field.setDataMarkFlag("");
                        needUpdate = true;
                    }
                    if (!needUpdate) continue;
                    field.setFieldSelectFlag(1);
                    field.setLastModifyUser(userId);
                    field.setLastModifyTime(now);
                    this.updateByPk(field, DataMarkFlag.NameToOption == markFlag);
                }
            }
            return num;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    @Override
    public List<ModelTableFieldVO> queryExistsFieldByPage(ModelTableFieldVO modelTableFieldVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryExistsFieldByPage(modelTableFieldVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            this.pageSet(modelTableFields, modelTableFieldVo);
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableFieldVO> queryFieldWithFieldFlag(String objectId, String srvModelCatalog, String srvModelType) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryFieldWithFieldFlag(objectId, srvModelCatalog, srvModelType);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableFields.size());
            list = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

