/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.common.enums.DataStdFlag;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PackageTypeEnum;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.TmModelUtil;
import com.irdstudio.allinpaas.console.dmcenter.plugin.DBImportPlugin;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableFieldDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableIndexDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ProjectTmInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ProjectTmPackageDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableField;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableIndex;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ProjectTmInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ProjectTmPackage;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.AnalysisFieldExcelData;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.AnalysisIndexExcelData;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.AnalysisTableExcelData;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableIndexVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableStructVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoImportVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmPackageVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="modelTableInfoService")
public class ModelTableInfoServiceImpl
implements ModelTableInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(ModelTableInfoServiceImpl.class);
    @Autowired
    private ModelTableInfoDao modelTableInfoDao;
    @Autowired
    private ModelTableFieldDao modelTableFieldDao;
    @Autowired
    private ModelTableIndexDao modelTableIndexDao;
    @Autowired
    private ProjectTmPackageDao projectTmPackageDao;
    @Autowired
    private ProjectTmInfoDao projectTmInfoDao;

    @Override
    public int insertModelTableInfo(ModelTableInfoVO inModelTableInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inModelTableInfoVo.toString());
        int num = 0;
        try {
            ModelTableInfo modelTableInfo = new ModelTableInfo();
            this.beanCopy((Object)inModelTableInfoVo, (Object)modelTableInfo);
            num = this.modelTableInfoDao.insertModelTableInfo(modelTableInfo);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(ModelTableInfoVO inModelTableInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inModelTableInfoVo));
        int num = 0;
        try {
            ModelTableInfo modelTableInfo = new ModelTableInfo();
            this.beanCopy((Object)inModelTableInfoVo, (Object)modelTableInfo);
            num = this.modelTableInfoDao.deleteByPk(modelTableInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inModelTableInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int deleteByTableModelIds(List<String> tableModelIds) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + tableModelIds);
        int num = 0;
        try {
            num = this.modelTableInfoDao.deleteByTableModelIds(tableModelIds);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + tableModelIds + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(ModelTableInfoVO inModelTableInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inModelTableInfoVo.toString());
        int num = 0;
        try {
            ModelTableInfo oldTableInfo = new ModelTableInfo();
            oldTableInfo.setObjectId(inModelTableInfoVo.getObjectId());
            oldTableInfo = this.modelTableInfoDao.queryByPk(oldTableInfo);
            ModelTableInfo modelTableInfo = new ModelTableInfo();
            this.beanCopy((Object)inModelTableInfoVo, (Object)modelTableInfo);
            if (!StringUtils.equals((CharSequence)oldTableInfo.getPackageId(), (CharSequence)modelTableInfo.getPackageId())) {
                ProjectTmPackage targetPackage = new ProjectTmPackage();
                targetPackage.setPackageId(modelTableInfo.getPackageId());
                targetPackage = this.projectTmPackageDao.queryByPk(targetPackage);
                if (targetPackage != null) {
                    if (targetPackage.getPackageType().equals(PackageTypeEnum.Data.getType())) {
                        modelTableInfo.setObjectType(Integer.valueOf(targetPackage.getPackageCode()));
                    } else if (targetPackage.getPackageType().equals(PackageTypeEnum.TABLE.getType())) {
                        modelTableInfo.setObjectType(1201);
                    }
                }
            }
            num = this.modelTableInfoDao.updateByPk(modelTableInfo);
            this.modelTableInfoDao.updateSrvModelInoutByTableModelId(modelTableInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inModelTableInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public ModelTableInfoVO queryByPk(ModelTableInfoVO inModelTableInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inModelTableInfoVo));
        try {
            ModelTableInfo queryModelTableInfo = new ModelTableInfo();
            this.beanCopy((Object)inModelTableInfoVo, (Object)queryModelTableInfo);
            ModelTableInfo queryRslModelTableInfo = this.modelTableInfoDao.queryByPk(queryModelTableInfo);
            if (Objects.nonNull((Object)queryRslModelTableInfo)) {
                ModelTableInfoVO outModelTableInfoVo = (ModelTableInfoVO)((Object)this.beanCopy((Object)queryRslModelTableInfo, (Object)new ModelTableInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outModelTableInfoVo.toString());
                return outModelTableInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<ModelTableInfoVO> queryAllNotPage(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllNotPage(modelTableInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByLevelOne(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByLevelOneByPage(modelTableInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllIsolateTableByPage(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllIsolateTableByPage(modelTableInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllIsolateTable(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllIsolateTable(modelTableInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByLevelOneWithSrv(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByLevelOneWithSrvByPage(modelTableInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByLevelTwo(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByLevelTwoByPage(modelTableInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = null;
        try {
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByLevelThree(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByLevelThreeByPage(modelTableInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = null;
        try {
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByLevelFour(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByLevelFourByPage(modelTableInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = null;
        try {
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByLevelFive(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByLevelFiveByPage(modelTableInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = null;
        try {
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByProject(String projectId) {
        logger.debug("\u6839\u636e\u5de5\u7a0b\u6807\u8bc6[{}]\u67e5\u8be2\u5de5\u7a0b\u4e0b\u6240\u6709\u8868\u6a21\u578b\u4fe1\u606f...", (Object)projectId);
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByProject(projectId);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = null;
        try {
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public ModelTableInfoBo getModelTableInfo(String tableModelId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + tableModelId);
        try {
            ModelTableInfo queryModelTableInfo = new ModelTableInfo();
            queryModelTableInfo.setObjectId(tableModelId);
            ModelTableInfo mti = this.modelTableInfoDao.queryByPk(queryModelTableInfo);
            if (Objects.nonNull((Object)mti)) {
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + mti.toString());
                ModelTableInfoBo mtib = new ModelTableInfoBo();
                mtib.setTableId(mti.getObjectId());
                mtib.setTableCode(mti.getObjectCode());
                mtib.setTableName(mti.getObjectName());
                mtib.setModelClassName(TmModelUtil.tableCodeToClassName(mti.getObjectCode()));
                mtib.setJavaPropertyName(TmModelUtil.fieldToProperty(mti.getObjectCode()));
                return mtib;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<ModelTableFieldVO> queryAllByItemId(ModelTableFieldVO paramVO) {
        logger.debug("\u6839\u636e\u6761\u76ee\u6807\u8bc6[{}]\u67e5\u8be2\u4e0b\u8868\u6a21\u578b\u4fe1\u606f...", (Object)paramVO.getItemId());
        List<ModelTableFieldVO> modelTableInfos = this.modelTableInfoDao.queryAllByItemIdByPage(paramVO);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        this.pageSet(modelTableInfos, paramVO);
        return modelTableInfos;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByDictId(String dictId) {
        logger.debug("\u6839\u636e\u9009\u9879\u6807\u8bc6[{}]\u67e5\u8be2\u4e0b\u8868\u6a21\u578b\u4fe1\u606f...", (Object)dictId);
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByDictId(dictId);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        for (ModelTableInfo mti : modelTableInfos) {
            mti.setTotal(modelTableInfos.size());
        }
        List list = null;
        try {
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableStructVO> queryModelTableStructByProjectId(String projectId) {
        ArrayList<ModelTableStructVO> sqlScripts = new ArrayList<ModelTableStructVO>();
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryModeltableInfosByProjectId(projectId);
        List<ModelTableField> modelTableFields = this.modelTableFieldDao.queryModelTableFieldsByProjectId(projectId);
        List<ModelTableIndex> modelTableIndexs = this.modelTableIndexDao.queryModelTableIndexByProjectId(projectId);
        List tableInfoVOs = null;
        List tableFieldVOs = null;
        List tableIndexVOs = null;
        try {
            tableInfoVOs = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
            tableFieldVOs = this.beansCopy(modelTableFields, ModelTableFieldVO.class);
            tableIndexVOs = this.beansCopy(modelTableIndexs, ModelTableIndexVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        ModelTableStructVO sqlScript = null;
        ArrayList<ModelTableFieldVO> tableFieldVOs2 = null;
        for (ModelTableInfoVO tableInfoVO : tableInfoVOs) {
            sqlScript = new ModelTableStructVO();
            sqlScript.setTable(tableInfoVO);
            sqlScript.setIndexs(new ArrayList<ModelTableIndexVO>());
            tableFieldVOs2 = new ArrayList<ModelTableFieldVO>();
            for (int i = 0; i < tableFieldVOs.size(); ++i) {
                if (!((ModelTableFieldVO)((Object)tableFieldVOs.get(i))).getObjectId().equals(tableInfoVO.getObjectId())) continue;
                tableFieldVOs2.add((ModelTableFieldVO)((Object)tableFieldVOs.get(i)));
                tableFieldVOs.remove(i);
                --i;
            }
            for (int k = 0; k < tableIndexVOs.size(); ++k) {
                if (!tableInfoVO.getObjectId().equals(((ModelTableIndexVO)((Object)tableIndexVOs.get(k))).getObjectId())) continue;
                sqlScript.getIndexs().add((ModelTableIndexVO)((Object)tableIndexVOs.get(k)));
                tableIndexVOs.remove(k);
                --k;
            }
            sqlScript.setFields(tableFieldVOs2);
            sqlScripts.add(sqlScript);
        }
        return sqlScripts;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByObjectCode(String objectCode) {
        List list = null;
        logger.debug("\u6839\u636e\u5bf9\u8c61code\u67e5\u8be2\u4e0b\u8868\u6a21\u578b\u4fe1\u606f..." + objectCode);
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByObjectCode(objectCode);
            logger.debug("\u67e5\u8be2\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ModelTableInfoVO> queryAllByTableInfo(ModelTableInfoVO modelTableInfoVO) {
        logger.debug("\u6839\u636e\u5de5\u7a0b\u6807\u8bc6[{}]\u67e5\u8be2\u5de5\u7a0b\u4e0b\u6240\u6709\u8868\u6a21\u578b\u4fe1\u606f...", (Object)modelTableInfoVO.getProjectId());
        List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllByTableInfo(modelTableInfoVO);
        logger.debug("\u3010 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
        List list = null;
        try {
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public ModelTableInfoVO copyModelTableInfo(ModelTableInfoVO copyTable) {
        ModelTableInfo newTable = new ModelTableInfo();
        newTable.setObjectId(copyTable.getObjectId());
        newTable = this.modelTableInfoDao.queryByPk(newTable);
        if (newTable == null) {
            return null;
        }
        newTable.setObjectId(KeyUtil.createUUIDKey());
        newTable.setCreateUser(copyTable.getCreateUser());
        newTable.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        newTable.setObjectCode(newTable.getObjectCode() + "_copy");
        this.modelTableInfoDao.insertModelTableInfo(newTable);
        ModelTableInfoVO newTbVO = new ModelTableInfoVO();
        this.beanCopy((Object)newTable, (Object)newTbVO);
        ModelTableIndexVO indexParam = new ModelTableIndexVO();
        indexParam.setObjectId(copyTable.getObjectId());
        List<ModelTableIndex> indexs = this.modelTableIndexDao.queryAll(indexParam);
        if (CollectionUtils.isNotEmpty(indexs)) {
            for (ModelTableIndex index : indexs) {
                index.setObjectId(newTable.getObjectId());
                index.setCreateTime(newTable.getCreateTime());
                index.setCreateUser(newTable.getCreateUser());
                index.setIndexName(index.getIndexName() + "_copy");
                this.modelTableIndexDao.insertModelTableIndex(index);
            }
        }
        ModelTableFieldVO fieldParam = new ModelTableFieldVO();
        fieldParam.setObjectId(copyTable.getObjectId());
        List<ModelTableField> fields = this.modelTableFieldDao.queryModelTableField(fieldParam);
        if (CollectionUtils.isNotEmpty(fields)) {
            for (ModelTableField field : fields) {
                field.setFieldId(KeyUtil.createUUIDKey());
                field.setCreateTime(newTable.getCreateTime());
                field.setCreateUser(newTable.getCreateUser());
                field.setObjectId(newTable.getObjectId());
                field.setDataStdFlag(DataStdFlag.Auto.getCode());
                this.modelTableFieldDao.insertModelTableField(field);
            }
        }
        return newTbVO;
    }

    private String trimBackquote(String str) {
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeStart((String)str, (String)"`");
        }
        if (StringUtils.endsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeEnd((String)str, (String)"`");
        }
        return str.toLowerCase();
    }

    @Override
    public ModelTableInfoVO createModelTableInfoBySQL(String projectId, String packageId, String objectType, String userId, String sql) {
        String createTime = CurrentDateUtil.getTodayDateEx2();
        String createUser = userId;
        if (StringUtils.isBlank((CharSequence)sql)) {
            return null;
        }
        sql = sql.replaceFirst("##", "--");
        try {
            Statement sqlParse = CCJSqlParserUtil.parse((String)sql);
            if (sqlParse instanceof CreateTable) {
                CreateTable createTb = (CreateTable)sqlParse;
                ModelTableInfoVO newTable = new ModelTableInfoVO();
                newTable.setObjectId(KeyUtil.createUUIDKey());
                newTable.setProjectId(projectId);
                newTable.setPackageId(packageId);
                newTable.setObjectType(Integer.valueOf(objectType));
                newTable.setCreateUser(createUser);
                newTable.setCreateTime(createTime);
                newTable.setLastModifyUser(createUser);
                newTable.setLastModifyTime(createTime);
                newTable.setObjectCode(this.trimBackquote(createTb.getTable().getName()));
                if (createTb.getTableOptionsStrings() != null) {
                    for (int i = 0; i < createTb.getTableOptionsStrings().size(); ++i) {
                        String val = ((String)createTb.getTableOptionsStrings().get(i)).toString();
                        if (val == null || !val.equalsIgnoreCase("COMMENT") || i + 2 >= createTb.getTableOptionsStrings().size()) continue;
                        String comment = ((String)createTb.getTableOptionsStrings().get(i + 2)).toString();
                        comment = comment.replaceAll("'", "");
                        newTable.setObjectName(comment);
                        break;
                    }
                }
                if (StringUtils.isBlank((CharSequence)newTable.getObjectName())) {
                    newTable.setObjectName(newTable.getObjectCode());
                }
                this.insertModelTableInfo(newTable);
                ModelTableIndex primaryKey = null;
                if (createTb.getIndexes() != null) {
                    for (Index index : createTb.getIndexes()) {
                        ModelTableIndex modelTableIndex = new ModelTableIndex();
                        modelTableIndex.setObjectId(newTable.getObjectId());
                        modelTableIndex.setCreateTime(createTime);
                        modelTableIndex.setCreateUser(createUser);
                        modelTableIndex.setIndexName(index.getName());
                        ArrayList<String> indexCols = new ArrayList<String>();
                        for (String col : index.getColumnsNames()) {
                            indexCols.add(this.trimBackquote(col));
                        }
                        modelTableIndex.setIndexFields(StringUtils.join(indexCols, (String)",").toLowerCase());
                        if (index.getType().toUpperCase().startsWith("PRIMARY ")) {
                            modelTableIndex.setIndexTypePrimary("Y");
                            modelTableIndex.setIndexTypeUnique("N");
                            modelTableIndex.setIndexName(String.format("PK_%s", newTable.getObjectCode()).toUpperCase());
                            primaryKey = modelTableIndex;
                        } else if (index.getType().toUpperCase().startsWith("UNIQUE ")) {
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("Y");
                            if (StringUtils.isBlank((CharSequence)index.getName())) {
                                modelTableIndex.setIndexName(String.format("UK_%s_%s", newTable.getObjectCode(), StringUtils.join(indexCols, (String)"_")).toUpperCase());
                            }
                        } else {
                            modelTableIndex.setIndexTypePrimary("N");
                            modelTableIndex.setIndexTypeUnique("N");
                        }
                        this.modelTableIndexDao.insertModelTableIndex(modelTableIndex);
                    }
                }
                if (createTb.getColumnDefinitions() != null) {
                    int order = 1;
                    for (ColumnDefinition col : createTb.getColumnDefinitions()) {
                        ModelTableField field = new ModelTableField();
                        field.setFieldId(KeyUtil.createUUIDKey());
                        field.setObjectId(newTable.getObjectId());
                        field.setCreateUser(createUser);
                        field.setCreateTime(createTime);
                        field.setFieldCode(this.trimBackquote(col.getColumnName()));
                        field.setFieldOrder(order++);
                        field.setIsAllowNull("Y");
                        if (col.getColumnSpecs() != null) {
                            for (int i = 0; i < col.getColumnSpecs().size(); ++i) {
                                String val = (String)col.getColumnSpecs().get(i);
                                if (val != null && val.equalsIgnoreCase("NOT") && ((String)col.getColumnSpecs().get(i + 1)).equalsIgnoreCase("NULL")) {
                                    field.setIsAllowNull("N");
                                    ++i;
                                    continue;
                                }
                                if (val != null && val.equalsIgnoreCase("NULL")) {
                                    field.setIsAllowNull("Y");
                                    continue;
                                }
                                if (val == null || !val.equalsIgnoreCase("COMMENT") || i + 1 >= col.getColumnSpecs().size()) continue;
                                val = (String)col.getColumnSpecs().get(i + 1);
                                val = val.replaceAll("'", "");
                                field.setFieldName(val);
                                field.setFieldDesc(val);
                                ++i;
                            }
                        }
                        field.setFieldType(col.getColDataType().getDataType());
                        if (col.getColDataType().getArgumentsStringList() != null && col.getColDataType().getArgumentsStringList().size() > 0) {
                            String len = (String)col.getColDataType().getArgumentsStringList().get(0);
                            field.setFieldLength(Integer.valueOf(len));
                            if (col.getColDataType().getArgumentsStringList().size() > 1) {
                                field.setFieldPrecision(Integer.valueOf((String)col.getColDataType().getArgumentsStringList().get(1)));
                            }
                        }
                        if (primaryKey != null && primaryKey.getIndexFields().contains(field.getFieldCode().toLowerCase())) {
                            field.setIsPk("Y");
                        } else {
                            field.setIsPk("N");
                        }
                        field.setDataStdFlag(DataStdFlag.Auto.getCode());
                        this.modelTableFieldDao.insertModelTableField(field);
                    }
                }
                return newTable;
            }
            logger.error("sql \u4e0d\u662fcreate table\u8bed\u6cd5 {}", (Object)sql);
            return null;
        }
        catch (JSQLParserException e) {
            logger.error("sql \u89e3\u6790\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean importTableFromDB(ProjectTmInfoImportVO importVO, UserInfo userInfo) {
        String driverClass = "com.mysql.jdbc.Driver";
        switch (importVO.getDbms()) {
            case "425": {
                driverClass = "com.mysql.jdbc.Driver";
                break;
            }
            case "125": {
                driverClass = "oracle.jdbc.driver.OracleDriver";
                break;
            }
            default: {
                driverClass = "com.mysql.jdbc.Driver";
            }
        }
        DBImportPlugin readPlugin = DBImportPlugin.Factory.getInstance(driverClass);
        DBImportPlugin.DBInfo db = readPlugin.readDBInfo(importVO.getDbUrl(), importVO.getDbUser(), importVO.getDbPwd(), driverClass);
        if (db != null) {
            String conflict = importVO.getConflict();
            String projectId = importVO.getProjectId();
            String createTime = CurrentDateUtil.getTodayDateEx2();
            Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
            for (DBImportPlugin.Table tb : db.getTables()) {
                ModelTableInfoVO modelTb = new ModelTableInfoVO();
                modelTb.setProjectId(projectId);
                modelTb.setObjectCode(tb.getTable_name());
                modelTb.setObjectName(tb.getTable_comment());
                List<ModelTableInfo> exists = this.modelTableInfoDao.queryAllNotPage(modelTb);
                ModelTableInfo model = null;
                if (CollectionUtils.isNotEmpty(exists)) {
                    if (conflict.equals(ConflictType.skip.getCode())) {
                        logger.info("{}\u6a21\u578b\u5e93\u4e2d\u5b58\u5728{}, \u4e14\u5904\u7406\u65b9\u5f0f\u4e3a\u8df3\u8fc7", (Object)projectId, (Object)tb.getTable_name());
                        continue;
                    }
                    model = exists.get(0);
                    this.modelTableFieldDao.deleteByObjectId(model.getObjectId());
                    this.modelTableIndexDao.deleteByObjectId(model.getObjectId());
                } else {
                    model = new ModelTableInfo();
                    model.setObjectId(KeyUtil.createUUIDKey());
                    model.setObjectCode(tb.getTable_name());
                    model.setObjectName(tb.getTable_comment());
                    model.setProjectId(projectId);
                    model.setPackageId(projectId);
                    model.setObjectDesc(tb.getTable_comment());
                    model.setObjectType(1201);
                    model.setObjectState(0);
                    model.setSubjectId("0");
                    model.setTableDataCycle("00");
                    model.setCreateTime(createTime);
                    model.setCreateUser(userInfo.getUserId());
                    this.modelTableInfoDao.insertModelTableInfo(model);
                }
                DBImportPlugin.TableIndex pkKey = null;
                for (DBImportPlugin.TableIndex ii : tb.getIndexes()) {
                    ModelTableIndex index = new ModelTableIndex();
                    index.setObjectId(model.getObjectId());
                    index.setIndexFields(ii.getColumns());
                    index.setCreateTime(createTime);
                    index.setCreateUser(userInfo.getUserId());
                    if ("PRIMARY".equals(ii.getIndex_name())) {
                        index.setIndexTypePrimary("Y");
                        index.setIndexTypeUnique("N");
                        index.setIndexName(String.format("PK_%s", ii.getTable_name().toUpperCase()));
                        pkKey = ii;
                    } else {
                        index.setIndexTypePrimary("N");
                        index.setIndexName(ii.getIndex_name());
                    }
                    this.modelTableIndexDao.insertModelTableIndex(index);
                }
                int fieldOrder = 2;
                for (DBImportPlugin.TableField ff : tb.getFields()) {
                    ModelTableField field = new ModelTableField();
                    field.setObjectId(model.getObjectId());
                    field.setFieldId(KeyUtil.createUUIDKey());
                    field.setCreateTime(createTime);
                    field.setCreateUser(userInfo.getUserId());
                    field.setFieldCode(ff.getColumn_name());
                    if (StringUtils.isNotBlank((CharSequence)ff.getIs_nullable()) && ff.getIs_nullable().equals("YES")) {
                        field.setIsAllowNull("Y");
                    } else {
                        field.setIsAllowNull("N");
                    }
                    field.setFieldDesc(ff.getColumn_comment());
                    field.setFieldName(ff.getColumn_comment());
                    field.setDefValue(ff.getColumn_default());
                    field.setFieldType(ff.getData_type());
                    if (pkKey != null) {
                        if (pkKey.getColumns().contains(ff.getColumn_name())) {
                            field.setIsPk("Y");
                            field.setFieldOrder(1);
                        } else {
                            field.setIsPk("N");
                            field.setFieldOrder(fieldOrder++);
                        }
                    } else {
                        field.setIsPk("N");
                        field.setFieldOrder(fieldOrder++);
                    }
                    Matcher matcher = pattern.matcher(ff.getColumn_type());
                    if (matcher.matches()) {
                        field.setFieldLength(Integer.valueOf(matcher.group(1)));
                        if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                            field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getFieldName()) && field.getFieldName().length() > 80) {
                        field.setFieldName(field.getFieldName().substring(0, 80));
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getFieldDesc()) && field.getFieldDesc().length() > 254) {
                        field.setFieldDesc(field.getFieldDesc().substring(0, 254));
                    }
                    field.setDataStdFlag(DataStdFlag.Auto.getCode());
                    this.modelTableFieldDao.insertModelTableField(field);
                }
            }
            return true;
        }
        logger.error("\u8bfb\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25 " + importVO.getDbUrl());
        return false;
    }

    @Override
    public int mergeAppByProjectId(String originProjectId, String targetProjectId, List<Map<String, Object>> adjustContentList) {
        ModelTableInfoVO modelParam = new ModelTableInfoVO();
        modelParam.setSize(50);
        modelParam.setProjectId(originProjectId);
        List<ModelTableInfo> modelList = this.modelTableInfoDao.queryAllByLevelOneByPage(modelParam);
        ProjectTmInfo originProj = new ProjectTmInfo();
        originProj.setProjectId(originProjectId);
        originProj = this.projectTmInfoDao.queryByPk(originProj);
        ProjectTmInfo targetProj = new ProjectTmInfo();
        targetProj.setProjectId(targetProjectId);
        targetProj = this.projectTmInfoDao.queryByPk(targetProj);
        if (CollectionUtils.isNotEmpty(modelList)) {
            for (ModelTableInfo m : modelList) {
                HashMap<String, String> content = new HashMap<String, String>();
                content.put("desc", "\u8868\u6a21\u578b");
                content.put("beforeContent", String.format("%s[%s]\u8868\u6a21\u578b%s[%s]", originProj.getProjectName(), originProj.getProjectCode(), m.getObjectName(), m.getObjectCode()));
                content.put("afterContent", String.format("%s[%s]\u8868\u6a21\u578b%s[%s]", targetProj.getProjectName(), targetProj.getProjectCode(), m.getObjectName(), m.getObjectCode()));
                adjustContentList.add(content);
            }
        }
        ProjectTmPackageVO oriPackage = new ProjectTmPackageVO();
        oriPackage.setProjectId(originProjectId);
        List<ProjectTmPackage> oriPackageList = this.projectTmPackageDao.queryAll(oriPackage);
        ProjectTmPackageVO targetPackage = new ProjectTmPackageVO();
        targetPackage.setProjectId(targetProjectId);
        List<ProjectTmPackage> targetPackageList = this.projectTmPackageDao.queryAll(targetPackage);
        return this.modelTableInfoDao.mergeAppByProjectId(originProjectId, targetProjectId);
    }

    @Override
    public List<ModelTableInfoVO> queryAllSubsModelTableInfoByPage(ModelTableInfoVO modelTableInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ModelTableInfo> modelTableInfos = this.modelTableInfoDao.queryAllSubsModelTableInfoByPage(modelTableInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + modelTableInfos.size());
            this.pageSet(modelTableInfos, modelTableInfoVo);
            list = this.beansCopy(modelTableInfos, ModelTableInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public AnalysisIndexExcelData querySysAnalysisIndexData(String subsCode, String appId) {
        AnalysisIndexExcelData data = new AnalysisIndexExcelData();
        data.setSubsCode(subsCode);
        data.setTableNum(this.modelTableInfoDao.querySysTableNum(subsCode, appId));
        data.setFieldNum(this.modelTableInfoDao.querySysFieldNum(subsCode, appId));
        data.setItemFieldNum(this.modelTableInfoDao.querySysFieldItemNum(subsCode, appId));
        data.setMissTbCNNum(this.modelTableInfoDao.querySysMissCNNum(subsCode, appId));
        data.setMissFieldCNNum(this.modelTableInfoDao.querySysMissFieldCNNum(subsCode, appId));
        data.setMessyTbNum(this.modelTableInfoDao.querySysMessyTbNum(subsCode, appId));
        data.setMessyFieldNum(this.modelTableInfoDao.querySysMessyFieldNum(subsCode, appId));
        data.setFieldTypeNum(this.modelTableInfoDao.querySysFieldTypeNum(subsCode, appId));
        data.setFieldLengthNum(this.modelTableInfoDao.querySysFieldLengthNum(subsCode, appId));
        data.setFieldCNNum(this.modelTableInfoDao.querySysFieldCNNum(subsCode, appId));
        data.setFieldStdFlagNum(this.modelTableInfoDao.querySysFieldStdFlagNum(subsCode, appId));
        data.setFieldMarkFlagNum(this.modelTableInfoDao.querySysFieldMarkFlagNum(subsCode, appId));
        return data;
    }

    @Override
    public List<AnalysisFieldExcelData> querySysFieldCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisFieldExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysFieldCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AnalysisTableExcelData> querySysTableCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisTableExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysTableCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AnalysisFieldExcelData> querySysFieldMissNameCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisFieldExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysFieldMissNameCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AnalysisFieldExcelData> querySysFieldDiffNameCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisFieldExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysFieldDiffNameCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AnalysisFieldExcelData> querySysFieldDiffENCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisFieldExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysFieldDiffENCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AnalysisFieldExcelData> querySysFieldDiffLenCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisFieldExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysFieldDiffLenCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AnalysisFieldExcelData> querySysFieldMessyNameCheckByPage(ModelTableInfoVO paramVO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<AnalysisFieldExcelData> list = null;
        try {
            list = this.modelTableInfoDao.querySysFieldMessyNameCheckByPage(paramVO);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + list.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int updateTableOrder(ModelTableInfoVO tableInfo, boolean upFlag) {
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = tableInfo.getLoginUserId();
        ModelTableInfo model = new ModelTableInfo();
        this.beanCopy((Object)tableInfo, (Object)model);
        model = this.modelTableInfoDao.queryByPk(model);
        if (model != null && model.getOrderValue() == null) {
            ModelTableInfoVO fixedTableOrder = new ModelTableInfoVO();
            fixedTableOrder.setProjectId(model.getProjectId());
            fixedTableOrder.setPackageId(model.getPackageId());
            List<ModelTableInfo> orderTbList = this.modelTableInfoDao.queryAllNotPage(fixedTableOrder);
            if (CollectionUtils.isNotEmpty(orderTbList)) {
                for (int i = 0; i < orderTbList.size(); ++i) {
                    ModelTableInfo tb = orderTbList.get(i);
                    if (tb.getOrderValue() == null) {
                        tb.setOrderValue(i + 1);
                        this.modelTableInfoDao.updateByPk(tb);
                    }
                    if (!model.getObjectId().equals(tb.getObjectId())) continue;
                    model.setOrderValue(tb.getOrderValue());
                }
            }
        }
        ModelTableInfo closetModel = null;
        closetModel = upFlag ? this.modelTableInfoDao.queryPreTable(model) : this.modelTableInfoDao.queryNextTable(model);
        if (closetModel != null) {
            int selfOrder = model.getOrderValue();
            int yourOrder = closetModel.getOrderValue();
            if (yourOrder == selfOrder) {
                selfOrder = upFlag ? --selfOrder : ++selfOrder;
            }
            model.setOrderValue(yourOrder);
            model.setLastModifyTime(now);
            model.setLastModifyUser(userId);
            this.modelTableInfoDao.updateByPk(model);
            closetModel.setOrderValue(selfOrder);
            closetModel.setLastModifyTime(now);
            closetModel.setLastModifyUser(userId);
            this.modelTableInfoDao.updateByPk(closetModel);
            return 1;
        }
        int selfOrder = model.getOrderValue();
        selfOrder = upFlag ? --selfOrder : ++selfOrder;
        model.setOrderValue(selfOrder);
        model.setLastModifyTime(now);
        model.setLastModifyUser(userId);
        this.modelTableInfoDao.updateByPk(model);
        return 1;
    }

    public static enum ConflictType {
        skip("skip", "\u8df3\u8fc7"),
        recover("skip", "\u8986\u76d6");

        private String code;
        private String name;

        private ConflictType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }
}

