/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableFieldDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ModelTableInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ProjectTmCheckDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ProjectTmInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableField;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ModelTableInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ProjectTmCheck;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ProjectTmInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmCheckService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmCheckVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTmCheckService")
public class ProjectTmCheckServiceImpl
implements ProjectTmCheckService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(ProjectTmCheckServiceImpl.class);
    @Autowired
    private ProjectTmInfoDao projectTmInfoDao;
    @Autowired
    private ProjectTmCheckDao projectTmCheckDao;
    @Autowired
    private ModelTableInfoDao modelTableInfoDao;
    @Autowired
    private ModelTableFieldDao modelTableFieldDao;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;

    @Override
    public int insertProjectTmCheck(ProjectTmCheckVO inProjectTmCheckVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inProjectTmCheckVo.toString());
        int num = 0;
        try {
            ProjectTmCheck projectTmCheck = new ProjectTmCheck();
            this.beanCopy((Object)inProjectTmCheckVo, (Object)projectTmCheck);
            num = this.projectTmCheckDao.insertProjectTmCheck(projectTmCheck);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(ProjectTmCheckVO inProjectTmCheckVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inProjectTmCheckVo));
        int num = 0;
        try {
            ProjectTmCheck projectTmCheck = new ProjectTmCheck();
            this.beanCopy((Object)inProjectTmCheckVo, (Object)projectTmCheck);
            num = this.projectTmCheckDao.deleteByPk(projectTmCheck);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inProjectTmCheckVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(ProjectTmCheckVO inProjectTmCheckVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inProjectTmCheckVo.toString());
        int num = 0;
        try {
            ProjectTmCheck projectTmCheck = new ProjectTmCheck();
            this.beanCopy((Object)inProjectTmCheckVo, (Object)projectTmCheck);
            num = this.projectTmCheckDao.updateByPk(projectTmCheck);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inProjectTmCheckVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public ProjectTmCheckVO queryByPk(ProjectTmCheckVO inProjectTmCheckVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inProjectTmCheckVo));
        try {
            ProjectTmCheck queryProjectTmCheck = new ProjectTmCheck();
            this.beanCopy((Object)inProjectTmCheckVo, (Object)queryProjectTmCheck);
            ProjectTmCheck queryRslProjectTmCheck = this.projectTmCheckDao.queryByPk(queryProjectTmCheck);
            if (Objects.nonNull((Object)queryRslProjectTmCheck)) {
                ProjectTmCheckVO outProjectTmCheckVo = (ProjectTmCheckVO)((Object)this.beanCopy((Object)queryRslProjectTmCheck, (Object)new ProjectTmCheckVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outProjectTmCheckVo.toString());
                return outProjectTmCheckVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public int projectModelTableCheck(final ProjectTmCheckVO projectTmCheckVO) {
        logger.debug("\u542f\u52a8\u7ebf\u7a0b \u6821\u9a8c\u8868\u6a21\u578b:" + projectTmCheckVO.getProjectId());
        this.applicationThreadPool.add((Callable)new Callable<ExecuteRtnInfo>(){

            @Override
            public ExecuteRtnInfo call() throws Exception {
                ExecuteRtnInfo rtn = new ExecuteRtnInfo();
                logger.debug("\u6821\u9a8c\u8868\u6a21\u578b:" + projectTmCheckVO.getProjectId());
                try {
                    List<ModelTableField> list;
                    List<ModelTableInfo> list2;
                    ProjectTmCheck error;
                    List<ModelTableField> duplicateFields;
                    ArrayList<ProjectTmCheck> checkList = new ArrayList<ProjectTmCheck>();
                    String projectId = projectTmCheckVO.getProjectId();
                    if (StringUtils.isBlank((String)projectId)) {
                        rtn.setFailCode("9999");
                        rtn.setFailReason("\u9879\u76ee\u4ee3\u7801\u4e3a\u7a7a");
                        rtn.setRtn(ExecuteRtnInfo.ExecuteRtn.FAILURE);
                        return rtn;
                    }
                    ProjectTmCheckServiceImpl.this.projectTmCheckDao.deleteByProjectId(projectId);
                    List<ModelTableInfo> duplicateTables = ProjectTmCheckServiceImpl.this.modelTableInfoDao.queryDuplicateTable(projectId);
                    if (CollectionUtils.isNotEmpty(duplicateTables)) {
                        for (ModelTableInfo modelTableInfo : duplicateTables) {
                            ProjectTmCheck projectTmCheck = new ProjectTmCheck();
                            projectTmCheck.setRecordKeyid(KeyUtil.createUUIDKey());
                            projectTmCheck.setProjectId(projectId);
                            projectTmCheck.setObjectCode(modelTableInfo.getObjectCode());
                            projectTmCheck.setCheckDesc(String.format("\u5b58\u5728\u76f8\u540c\u7684\u8868\u6a21\u578b\uff0c%s!", modelTableInfo.getObjectCode()));
                            projectTmCheck.setOperUserid(projectTmCheckVO.getOperUserid());
                            projectTmCheck.setOperTime(CurrentDateUtil.getTodayDateEx2());
                            projectTmCheck.setCheckResult("F");
                            checkList.add(projectTmCheck);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(duplicateFields = ProjectTmCheckServiceImpl.this.modelTableFieldDao.queryDuplicatField(projectId))) {
                        for (ModelTableField modelTableField : duplicateFields) {
                            ModelTableInfo table = new ModelTableInfo();
                            table.setObjectId(modelTableField.getObjectId());
                            table = ProjectTmCheckServiceImpl.this.modelTableInfoDao.queryByPk(table);
                            error = new ProjectTmCheck();
                            error.setRecordKeyid(KeyUtil.createUUIDKey());
                            error.setProjectId(projectId);
                            error.setObjectId(modelTableField.getObjectId());
                            error.setObjectCode(modelTableField.getFieldCode());
                            error.setCheckDesc(String.format("%s\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5,%s!", table.getObjectName(), modelTableField.getFieldCode()));
                            error.setOperUserid(projectTmCheckVO.getOperUserid());
                            error.setOperTime(CurrentDateUtil.getTodayDateEx2());
                            error.setCheckResult("F");
                            checkList.add(error);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(list2 = ProjectTmCheckServiceImpl.this.modelTableInfoDao.queryWithoutPkTable(projectId))) {
                        for (ModelTableInfo table : list2) {
                            error = new ProjectTmCheck();
                            error.setRecordKeyid(KeyUtil.createUUIDKey());
                            error.setProjectId(projectId);
                            error.setObjectId(table.getObjectId());
                            error.setObjectCode(table.getObjectCode());
                            error.setObjectName(table.getObjectName());
                            error.setCheckDesc(String.format("%s\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5!", table.getObjectName()));
                            error.setOperUserid(projectTmCheckVO.getOperUserid());
                            error.setOperTime(CurrentDateUtil.getTodayDateEx2());
                            error.setCheckResult("F");
                            checkList.add(error);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(list = ProjectTmCheckServiceImpl.this.modelTableFieldDao.queryFieldWithoutFieldLength(projectId))) {
                        for (ModelTableField field : list) {
                            ProjectTmCheck error3 = new ProjectTmCheck();
                            error3.setRecordKeyid(KeyUtil.createUUIDKey());
                            error3.setProjectId(projectId);
                            error3.setObjectId(field.getObjectId());
                            error3.setObjectCode(field.getObjectCode());
                            error3.setObjectName(field.getObjectName());
                            error3.setCheckDesc(String.format("%s[%s]\u5b57\u6bb5%s[%s]\u9700\u8981\u5b57\u6bb5\u957f\u5ea6!", field.getObjectName(), field.getObjectCode(), field.getFieldName(), field.getFieldCode()));
                            error3.setOperUserid(projectTmCheckVO.getOperUserid());
                            error3.setOperTime(CurrentDateUtil.getTodayDateEx2());
                            error3.setCheckResult("F");
                            checkList.add(error3);
                        }
                    }
                    for (ProjectTmCheck check : checkList) {
                        ProjectTmCheckServiceImpl.this.projectTmCheckDao.insertProjectTmCheck(check);
                    }
                    rtn.setSuccessFlag(true);
                    rtn.setRtn(ExecuteRtnInfo.ExecuteRtn.SUCCESS);
                    return rtn;
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
                    rtn.setFailCode("9999");
                    rtn.setFailReason(e.getMessage());
                    rtn.setEx((Throwable)e);
                    rtn.setRtn(ExecuteRtnInfo.ExecuteRtn.FAILURE);
                    return rtn;
                }
            }
        });
        logger.debug("\u542f\u52a8\u6821\u9a8c\u7ebf\u7a0b\u5b8c\u6210 " + projectTmCheckVO.getProjectId());
        return 1;
    }

    @Override
    public int projectModelTableCheckGroup(final ProjectTmCheckVO projectTmCheckVO) {
        logger.debug("\u542f\u52a8\u7ebf\u7a0b \u6821\u9a8c\u8868\u6a21\u578b:" + projectTmCheckVO.getBizDbName());
        this.applicationThreadPool.add((Callable)new Callable<ExecuteRtnInfo>(){

            @Override
            public ExecuteRtnInfo call() throws Exception {
                ExecuteRtnInfo rtn = new ExecuteRtnInfo();
                logger.debug("\u6821\u9a8c\u8868\u6a21\u578b:" + projectTmCheckVO.getBizDbName());
                try {
                    ArrayList<ProjectTmCheck> checkList = new ArrayList<ProjectTmCheck>();
                    String bizDbName = projectTmCheckVO.getBizDbName();
                    String subsId = projectTmCheckVO.getSubsId();
                    if (StringUtils.isBlank((String)subsId) || StringUtils.isBlank((String)bizDbName)) {
                        rtn.setFailCode("9999");
                        rtn.setFailReason("\u5931\u8d25\u8bf7\u6c42\u53c2\u6570");
                        rtn.setRtn(ExecuteRtnInfo.ExecuteRtn.FAILURE);
                        return rtn;
                    }
                    ProjectTmInfoVO prjParam = new ProjectTmInfoVO();
                    prjParam.setSubsId(subsId);
                    prjParam.setBizDbName(bizDbName);
                    List<ProjectTmInfo> prjList = ProjectTmCheckServiceImpl.this.projectTmInfoDao.queryAllGroupProject(prjParam);
                    if (CollectionUtils.isNotEmpty(prjList)) {
                        for (ProjectTmInfo prj : prjList) {
                            List<ModelTableField> withoutFieldLengthList;
                            List<ModelTableInfo> list;
                            ProjectTmCheck error;
                            List<ModelTableField> duplicateFields;
                            String projectId = prj.getProjectId();
                            ProjectTmCheckServiceImpl.this.projectTmCheckDao.deleteByProjectId(projectId);
                            List<ModelTableInfo> duplicateTables = ProjectTmCheckServiceImpl.this.modelTableInfoDao.queryDuplicateTable(projectId);
                            if (CollectionUtils.isNotEmpty(duplicateTables)) {
                                for (ModelTableInfo modelTableInfo : duplicateTables) {
                                    ProjectTmCheck error2 = new ProjectTmCheck();
                                    error2.setRecordKeyid(KeyUtil.createUUIDKey());
                                    error2.setProjectId(projectId);
                                    error2.setObjectCode(modelTableInfo.getObjectCode());
                                    error2.setCheckDesc(String.format("\u5b58\u5728\u76f8\u540c\u7684\u8868\u6a21\u578b\uff0c%s!", modelTableInfo.getObjectCode()));
                                    error2.setOperUserid(projectTmCheckVO.getOperUserid());
                                    error2.setOperTime(CurrentDateUtil.getTodayDateEx2());
                                    error2.setCheckResult("F");
                                    checkList.add(error2);
                                }
                            }
                            if (CollectionUtils.isNotEmpty(duplicateFields = ProjectTmCheckServiceImpl.this.modelTableFieldDao.queryDuplicatField(projectId))) {
                                for (Object field : duplicateFields) {
                                    ModelTableInfo table2 = new ModelTableInfo();
                                    table2.setObjectId(((ModelTableField)((Object)field)).getObjectId());
                                    table2 = ProjectTmCheckServiceImpl.this.modelTableInfoDao.queryByPk(table2);
                                    error = new ProjectTmCheck();
                                    error.setRecordKeyid(KeyUtil.createUUIDKey());
                                    error.setProjectId(projectId);
                                    error.setObjectId(((ModelTableField)((Object)field)).getObjectId());
                                    error.setObjectCode(((ModelTableField)((Object)field)).getFieldCode());
                                    error.setCheckDesc(String.format("%s\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5,%s!", table2.getObjectName(), ((ModelTableField)((Object)field)).getFieldCode()));
                                    error.setOperUserid(projectTmCheckVO.getOperUserid());
                                    error.setOperTime(CurrentDateUtil.getTodayDateEx2());
                                    error.setCheckResult("F");
                                    checkList.add(error);
                                }
                            }
                            if (CollectionUtils.isNotEmpty(list = ProjectTmCheckServiceImpl.this.modelTableInfoDao.queryWithoutPkTable(projectId))) {
                                Object field;
                                field = list.iterator();
                                while (field.hasNext()) {
                                    ModelTableInfo table = (ModelTableInfo)((Object)field.next());
                                    error = new ProjectTmCheck();
                                    error.setRecordKeyid(KeyUtil.createUUIDKey());
                                    error.setProjectId(projectId);
                                    error.setObjectId(table.getObjectId());
                                    error.setObjectCode(table.getObjectCode());
                                    error.setObjectName(table.getObjectName());
                                    error.setCheckDesc(String.format("%s\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5!", table.getObjectName()));
                                    error.setOperUserid(projectTmCheckVO.getOperUserid());
                                    error.setOperTime(CurrentDateUtil.getTodayDateEx2());
                                    error.setCheckResult("F");
                                    checkList.add(error);
                                }
                            }
                            if (!CollectionUtils.isNotEmpty(withoutFieldLengthList = ProjectTmCheckServiceImpl.this.modelTableFieldDao.queryFieldWithoutFieldLength(projectId))) continue;
                            for (ModelTableField field : withoutFieldLengthList) {
                                ProjectTmCheck error3 = new ProjectTmCheck();
                                error3.setRecordKeyid(KeyUtil.createUUIDKey());
                                error3.setProjectId(projectId);
                                error3.setObjectId(field.getObjectId());
                                error3.setObjectCode(field.getObjectCode());
                                error3.setObjectName(field.getObjectName());
                                error3.setCheckDesc(String.format("%s[%s]\u5b57\u6bb5%s[%s]\u9700\u8981\u5b57\u6bb5\u957f\u5ea6!", field.getObjectName(), field.getObjectCode(), field.getFieldName(), field.getFieldCode()));
                                error3.setOperUserid(projectTmCheckVO.getOperUserid());
                                error3.setOperTime(CurrentDateUtil.getTodayDateEx2());
                                error3.setCheckResult("F");
                                checkList.add(error3);
                            }
                        }
                    }
                    for (ProjectTmCheck check : checkList) {
                        ProjectTmCheckServiceImpl.this.projectTmCheckDao.insertProjectTmCheck(check);
                    }
                    rtn.setSuccessFlag(true);
                    rtn.setRtn(ExecuteRtnInfo.ExecuteRtn.SUCCESS);
                    return rtn;
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
                    rtn.setFailCode("9999");
                    rtn.setFailReason(e.getMessage());
                    rtn.setEx((Throwable)e);
                    rtn.setRtn(ExecuteRtnInfo.ExecuteRtn.FAILURE);
                    return rtn;
                }
            }
        });
        logger.debug("\u542f\u52a8\u6821\u9a8c\u7ebf\u7a0b\u5b8c\u6210 " + projectTmCheckVO.getProjectId());
        return 1;
    }

    @Override
    public List<ProjectTmCheckVO> queryAllOwner(ProjectTmCheckVO projectTmCheckVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ProjectTmCheck> projectTmChecks = this.projectTmCheckDao.queryAllOwnerByPage(projectTmCheckVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmChecks.size());
            this.pageSet(projectTmChecks, projectTmCheckVo);
            list = this.beansCopy(projectTmChecks, ProjectTmCheckVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmCheckVO> queryAllCurrOrg(ProjectTmCheckVO projectTmCheckVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ProjectTmCheck> projectTmChecks = this.projectTmCheckDao.queryAllCurrOrgByPage(projectTmCheckVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmChecks.size());
        List list = null;
        try {
            this.pageSet(projectTmChecks, projectTmCheckVo);
            list = this.beansCopy(projectTmChecks, ProjectTmCheckVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmCheckVO> queryAllCurrDownOrg(ProjectTmCheckVO projectTmCheckVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ProjectTmCheck> projectTmChecks = this.projectTmCheckDao.queryAllCurrDownOrgByPage(projectTmCheckVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmChecks.size());
        List list = null;
        try {
            this.pageSet(projectTmChecks, projectTmCheckVo);
            list = this.beansCopy(projectTmChecks, ProjectTmCheckVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

