/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.ProjectTmPackageDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.ProjectTmPackage;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmPackageService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmPackageVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTmPackageService")
public class ProjectTmPackageServiceImpl
implements ProjectTmPackageService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(ProjectTmPackageServiceImpl.class);
    @Autowired
    private ProjectTmPackageDao projectTmPackageDao;
    @Autowired
    private ModelTableInfoService modelTableInfoService;

    @Override
    public int insertProjectTmPackage(ProjectTmPackageVO inProjectTmPackageVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inProjectTmPackageVo.toString());
        int num = 0;
        try {
            ProjectTmPackage projectTmPackage = new ProjectTmPackage();
            this.beanCopy((Object)inProjectTmPackageVo, (Object)projectTmPackage);
            int order = this.projectTmPackageDao.queryMaxOrderValue(inProjectTmPackageVo.getPackageAbvId());
            projectTmPackage.setOrderValue(order + 1);
            num = this.projectTmPackageDao.insertProjectTmPackage(projectTmPackage);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(ProjectTmPackageVO inProjectTmPackageVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inProjectTmPackageVo));
        int num = 0;
        try {
            ProjectTmPackage projectTmPackage = new ProjectTmPackage();
            this.beanCopy((Object)inProjectTmPackageVo, (Object)projectTmPackage);
            num = this.projectTmPackageDao.deleteByPk(projectTmPackage);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inProjectTmPackageVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(ProjectTmPackageVO inProjectTmPackageVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inProjectTmPackageVo.toString());
        int num = 0;
        try {
            ProjectTmPackage projectTmPackage = new ProjectTmPackage();
            this.beanCopy((Object)inProjectTmPackageVo, (Object)projectTmPackage);
            num = this.projectTmPackageDao.updateByPk(projectTmPackage);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inProjectTmPackageVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public ProjectTmPackageVO queryByPk(ProjectTmPackageVO inProjectTmPackageVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inProjectTmPackageVo));
        try {
            ProjectTmPackage queryProjectTmPackage = new ProjectTmPackage();
            this.beanCopy((Object)inProjectTmPackageVo, (Object)queryProjectTmPackage);
            ProjectTmPackage queryRslProjectTmPackage = this.projectTmPackageDao.queryByPk(queryProjectTmPackage);
            if (Objects.nonNull((Object)queryRslProjectTmPackage)) {
                ProjectTmPackageVO outProjectTmPackageVo = (ProjectTmPackageVO)((Object)this.beanCopy((Object)queryRslProjectTmPackage, (Object)new ProjectTmPackageVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outProjectTmPackageVo.toString());
                return outProjectTmPackageVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<ProjectTmPackageVO> queryAllByLevelOne(ProjectTmPackageVO projectTmPackageVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ProjectTmPackage> projectTmPackages = this.projectTmPackageDao.queryAllByLevelOneByPage(projectTmPackageVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmPackages.size());
            this.pageSet(projectTmPackages, projectTmPackageVo);
            list = this.beansCopy(projectTmPackages, ProjectTmPackageVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmPackageVO> queryAll(ProjectTmPackageVO projectTmPackageVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<ProjectTmPackage> projectTmPackages = this.projectTmPackageDao.queryAll(projectTmPackageVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmPackages.size());
            this.pageSet(projectTmPackages, projectTmPackageVo);
            list = this.beansCopy(projectTmPackages, ProjectTmPackageVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmPackageVO> queryAllByLevelTwo(ProjectTmPackageVO projectTmPackageVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ProjectTmPackage> projectTmPackages = this.projectTmPackageDao.queryAllByLevelTwoByPage(projectTmPackageVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmPackages.size());
        List list = null;
        try {
            this.pageSet(projectTmPackages, projectTmPackageVo);
            list = this.beansCopy(projectTmPackages, ProjectTmPackageVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmPackageVO> queryAllByLevelThree(ProjectTmPackageVO projectTmPackageVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ProjectTmPackage> projectTmPackages = this.projectTmPackageDao.queryAllByLevelThreeByPage(projectTmPackageVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmPackages.size());
        List list = null;
        try {
            this.pageSet(projectTmPackages, projectTmPackageVo);
            list = this.beansCopy(projectTmPackages, ProjectTmPackageVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmPackageVO> queryAllByLevelFour(ProjectTmPackageVO projectTmPackageVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ProjectTmPackage> projectTmPackages = this.projectTmPackageDao.queryAllByLevelFourByPage(projectTmPackageVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmPackages.size());
        List list = null;
        try {
            this.pageSet(projectTmPackages, projectTmPackageVo);
            list = this.beansCopy(projectTmPackages, ProjectTmPackageVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<ProjectTmPackageVO> queryAllByLevelFive(ProjectTmPackageVO projectTmPackageVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<ProjectTmPackage> projectTmPackages = this.projectTmPackageDao.queryAllByLevelFiveByPage(projectTmPackageVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + projectTmPackages.size());
        List list = null;
        try {
            this.pageSet(projectTmPackages, projectTmPackageVo);
            list = this.beansCopy(projectTmPackages, ProjectTmPackageVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public boolean isHaveSubPackage(String packageId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u6761\u4ef6\u4e3a:" + packageId);
        int num = 0;
        try {
            num = this.projectTmPackageDao.countSubPackage(packageId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + packageId + "\u67e5\u8be2\u7684\u6570\u636e\u603b\u6570\u4e3a" + num);
        return num > 0;
    }

    @Override
    public boolean isHaveTableModel(String packageId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u6761\u4ef6\u4e3a:" + packageId);
        int num = 0;
        try {
            num = this.projectTmPackageDao.countTableModel(packageId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + packageId + "\u67e5\u8be2\u7684\u6570\u636e\u603b\u6570\u4e3a" + num);
        return num > 0;
    }

    @Override
    public int packageMerge(ProjectTmPackageVO projectTmPackageVo) {
        if (StringUtils.isBlank((String)projectTmPackageVo.getPackageId()) || StringUtils.isBlank((String)projectTmPackageVo.getPackageAbvId())) {
            return -1;
        }
        String srcPackageId = projectTmPackageVo.getPackageId();
        String targetPackageId = projectTmPackageVo.getPackageAbvId();
        ProjectTmPackageVO srcPackageParam = new ProjectTmPackageVO();
        srcPackageParam.setPackageAbvId(srcPackageId);
        List<ProjectTmPackageVO> subPackageList = this.queryAll(srcPackageParam);
        if (CollectionUtils.isNotEmpty(subPackageList)) {
            for (ProjectTmPackageVO sub : subPackageList) {
                sub.setPackageAbvId(targetPackageId);
                this.updateByPk(sub);
            }
        }
        ModelTableInfoVO tableParam = new ModelTableInfoVO();
        tableParam.setPackageId(srcPackageId);
        tableParam.setSize(Integer.MAX_VALUE);
        List<ModelTableInfoVO> tableList = this.modelTableInfoService.queryAllByLevelOne(tableParam);
        if (CollectionUtils.isNotEmpty(tableList)) {
            for (ModelTableInfoVO table : tableList) {
                table.setPackageId(targetPackageId);
                table.setLastModifyUser(projectTmPackageVo.getLoginUserId());
                table.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                this.modelTableInfoService.updateByPk(table);
            }
        }
        ProjectTmPackageVO deleteSrc = new ProjectTmPackageVO();
        deleteSrc.setPackageId(srcPackageId);
        this.deleteByPk(deleteSrc);
        return 0;
    }
}

