/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.service.impl;

import com.irdstudio.allinpaas.console.dmcenter.service.dao.PubDbmsDatatypeDao;
import com.irdstudio.allinpaas.console.dmcenter.service.dao.PubDbmsInfoDao;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.PubDbmsDatatype;
import com.irdstudio.allinpaas.console.dmcenter.service.domain.PubDbmsInfo;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDbmsInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDbmsInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pubDbmsInfoService")
public class PubDbmsInfoServiceImpl
implements PubDbmsInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(PubDbmsInfoServiceImpl.class);
    @Autowired
    private PubDbmsInfoDao pubDbmsInfoDao;
    @Autowired
    private PubDbmsDatatypeDao pubDbmsDatatypeDao;

    @Override
    public int insertPubDbmsInfo(PubDbmsInfoVO inPubDbmsInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inPubDbmsInfoVo.toString());
        int num = 0;
        try {
            PubDbmsInfo pubDbmsInfo = new PubDbmsInfo();
            this.beanCopy((Object)inPubDbmsInfoVo, (Object)pubDbmsInfo);
            num = this.pubDbmsInfoDao.insertPubDbmsInfo(pubDbmsInfo);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(PubDbmsInfoVO inPubDbmsInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inPubDbmsInfoVo));
        int num = 0;
        try {
            PubDbmsInfo pubDbmsInfo = new PubDbmsInfo();
            this.beanCopy((Object)inPubDbmsInfoVo, (Object)pubDbmsInfo);
            num = this.pubDbmsInfoDao.deleteByPk(pubDbmsInfo);
            PubDbmsDatatype dataTypeParam = new PubDbmsDatatype();
            dataTypeParam.setDbmsId(inPubDbmsInfoVo.getDbmsId());
            this.pubDbmsDatatypeDao.deleteByDbmsId(dataTypeParam);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inPubDbmsInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(PubDbmsInfoVO inPubDbmsInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inPubDbmsInfoVo.toString());
        int num = 0;
        try {
            PubDbmsInfo pubDbmsInfo = new PubDbmsInfo();
            this.beanCopy((Object)inPubDbmsInfoVo, (Object)pubDbmsInfo);
            num = this.pubDbmsInfoDao.updateByPk(pubDbmsInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inPubDbmsInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public PubDbmsInfoVO queryByPk(PubDbmsInfoVO inPubDbmsInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inPubDbmsInfoVo));
        try {
            PubDbmsInfo queryPubDbmsInfo = new PubDbmsInfo();
            this.beanCopy((Object)inPubDbmsInfoVo, (Object)queryPubDbmsInfo);
            PubDbmsInfo queryRslPubDbmsInfo = this.pubDbmsInfoDao.queryByPk(queryPubDbmsInfo);
            if (Objects.nonNull((Object)queryRslPubDbmsInfo)) {
                PubDbmsInfoVO outPubDbmsInfoVo = (PubDbmsInfoVO)((Object)this.beanCopy((Object)queryRslPubDbmsInfo, (Object)new PubDbmsInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outPubDbmsInfoVo.toString());
                return outPubDbmsInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<PubDbmsInfoVO> queryAllByLevelOne(PubDbmsInfoVO pubDbmsInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<PubDbmsInfo> pubDbmsInfos = this.pubDbmsInfoDao.queryAllByLevelOneByPage(pubDbmsInfoVo);
            logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + pubDbmsInfos.size());
            this.pageSet(pubDbmsInfos, pubDbmsInfoVo);
            list = this.beansCopy(pubDbmsInfos, PubDbmsInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<PubDbmsInfoVO> queryAllByLevelTwo(PubDbmsInfoVO pubDbmsInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<PubDbmsInfo> pubDbmsInfos = this.pubDbmsInfoDao.queryAllByLevelTwoByPage(pubDbmsInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + pubDbmsInfos.size());
        List list = null;
        try {
            this.pageSet(pubDbmsInfos, pubDbmsInfoVo);
            list = this.beansCopy(pubDbmsInfos, PubDbmsInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<PubDbmsInfoVO> queryAllByLevelThree(PubDbmsInfoVO pubDbmsInfoVo) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<PubDbmsInfo> pubDbmsInfos = this.pubDbmsInfoDao.queryAllByLevelThreeByPage(pubDbmsInfoVo);
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + pubDbmsInfos.size());
        List list = null;
        try {
            this.pageSet(pubDbmsInfos, pubDbmsInfoVo);
            list = this.beansCopy(pubDbmsInfos, PubDbmsInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<PubDbmsInfoVO> queryAllByLevelFour(PubDbmsInfoVO pubDbmsInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<PubDbmsInfo> pubDbmsInfos = this.pubDbmsInfoDao.queryAllByLevelFourByPage(pubDbmsInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + pubDbmsInfos.size());
        List list = null;
        try {
            this.pageSet(pubDbmsInfos, pubDbmsInfoVo);
            list = this.beansCopy(pubDbmsInfos, PubDbmsInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<PubDbmsInfoVO> queryAllByLevelFive(PubDbmsInfoVO pubDbmsInfoVo) {
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<PubDbmsInfo> pubDbmsInfos = this.pubDbmsInfoDao.queryAllByLevelFiveByPage(pubDbmsInfoVo);
        logger.debug("\u3010\u9884\u7559\uff0c\u4fbf\u4e8e\u540e\u7eed\u81ea\u5b9a\u4e49 \u3011\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + pubDbmsInfos.size());
        List list = null;
        try {
            this.pageSet(pubDbmsInfos, pubDbmsInfoVo);
            list = this.beansCopy(pubDbmsInfos, PubDbmsInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public PubDbmsInfoVO queryPubDbmsInfoByProjectId(String projectId) {
        logger.debug("\u6839\u636ePROJECT_ID[{}]\u67e5\u8be2DBMS......", (Object)projectId);
        if (StringUtil.isStrEmpty((String)projectId)) {
            return null;
        }
        PubDbmsInfoVO pubDbmsInfoVO = new PubDbmsInfoVO();
        PubDbmsInfo pubDbmsInfo = this.pubDbmsInfoDao.queryPubDbmsInfoByProjectId(projectId);
        this.beanCopy((Object)pubDbmsInfo, (Object)pubDbmsInfoVO);
        return pubDbmsInfoVO;
    }
}

