/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.facenter.service.impl;

import com.irdstudio.allinpaas.console.facenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.facenter.common.util.PathUtil;
import com.irdstudio.allinpaas.console.facenter.common.util.ZipUtil;
import com.irdstudio.allinpaas.console.facenter.service.bo.CodeProduceInfoBo;
import com.irdstudio.allinpaas.console.facenter.service.bo.CodeTemplateFileBo;
import com.irdstudio.allinpaas.console.facenter.service.facade.CodeProduceService;
import com.irdstudio.allinpaas.console.facenter.service.util.FreemarkerUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="codeProduceService")
public class CodeProduceServiceImpl
implements CodeProduceService {
    private static Logger logger = LogManager.getLogger(CodeProduceServiceImpl.class);
    private static final String TABLE_VAR_NOSPLIT = "XXX";
    private static final String TABLE_VAR_SPLIT = "X-X-X";
    @Value(value="${facenter.template.path:}")
    private String templatePath;
    @Value(value="${facenter.code.path:}")
    private String codePath;

    @Override
    public boolean produceModelBeanCode(String author, CodeProduceInfoBo cpib, TmProjectInfoBo mpib, ModelTableInfoBo mtib, List<CodeTemplateFileBo> ctfbList) {
        logger.info("\u5f00\u59cb\u751f\u6210\u4ee3\u7801,\u6a21\u677f\u6587\u4ef6\u76ee\u5f55" + this.templatePath + "...");
        String temporaryPath = this.codePath + cpib.getProduceId();
        File dir = new File(temporaryPath);
        if (dir.exists()) {
            dir.delete();
            System.out.println("\u5220\u9664\u5b58\u5728\u7684\u76ee\u5f55\uff1a" + temporaryPath + "!");
        } else {
            dir.mkdir();
        }
        if (!temporaryPath.endsWith(File.separator)) {
            temporaryPath = temporaryPath + File.separator;
        }
        PathUtil.checkAndCreate(temporaryPath);
        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
        ctdb.setMainTableModel(mtib);
        ctdb.setTmProjectInfo(mpib);
        ctdb.getEnvBo().setAuthor(author);
        ctdb.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        ctdb.getEnvBo().setDesc(mtib.getTableName());
        for (CodeTemplateFileBo ctfb : ctfbList) {
            logger.info("\u6a21\u677f\u6587\u4ef6\uff1a" + this.templatePath + File.separator + ctfb.getTemplateId() + File.separator + ctfb.getTemplateFile());
            String fileNameResult = ctfb.getTemplateFile().replaceAll(TABLE_VAR_NOSPLIT, mtib.getModelClassName());
            fileNameResult = fileNameResult.replaceAll(TABLE_VAR_SPLIT, mtib.getTableCode().replace("_", "-"));
            String outputFileName = temporaryPath + fileNameResult;
            logger.info("\u4ee3\u7801\u6587\u4ef6\uff1a" + outputFileName);
            FreemarkerUtil.produceSingleFile(ctdb, this.templatePath + File.separator + ctfb.getTemplateId(), ctfb.getTemplateFile() + ".vm", outputFileName);
        }
        try {
            FileOutputStream fos1 = new FileOutputStream(new File(this.codePath + cpib.getProduceId() + ".zip"));
            ZipUtil.toZip(temporaryPath, fos1, false);
        }
        catch (FileNotFoundException e) {
            logger.info("\u538b\u7f29\u4ee3\u7801\u6587\u4ef6\u5931\u8d25!");
            e.printStackTrace();
        }
        return true;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getCodePath() {
        return this.codePath;
    }

    public void setCodePath(String codePath) {
        this.codePath = codePath;
    }
}

