/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.tdpaas.cloud.member.common.bean;

import com.irdstudio.tdpaas.cloud.member.common.bean.MemberDataBo;
import com.irdstudio.tdpaas.cloud.member.common.util.MemberPageUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberSaasBean {
    private static final Logger logger = LoggerFactory.getLogger(MemberSaasBean.class);
    private String memberEnvPath;

    public MemberSaasBean(String memberEnvPath) {
        this.memberEnvPath = memberEnvPath;
        logger.info("\u4f1a\u5458\u73af\u5883\u6240\u5728\u8def\u5f84\uff1a" + memberEnvPath);
    }

    public void initMemberSaasPortal(String tenantId) {
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458SAAS\u95e8\u6237...");
        String srcDir = this.memberEnvPath + File.separator + "portal.template";
        String dstDir = this.memberEnvPath + File.separator + tenantId;
        File dstFile = new File(dstDir);
        if (dstFile.exists()) {
            return;
        }
        try {
            FileUtils.copyDirectory((File)new File(srcDir), (File)dstFile);
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.lastIndexOf("windows") == -1) {
                logger.info("\u975ewindows\u64cd\u4f5c\u7cfb\u7edf,\u6267\u884c\u76ee\u5f55\u6388\u6743\u547d\u4ee4,\u4ee5\u9632\u6b62\u53d1\u751fnginx\u7684403\u9519\u8bef...");
                Runtime.getRuntime().exec("chmod 777 -R " + dstDir);
            }
        }
        catch (IOException e) {
            logger.info("\u590d\u5236\u6a21\u677f\u76ee\u5f55\u4e3a\u4f1a\u5458SAAS\u95e8\u6237\u76ee\u5f55\u65f6\u51fa\u9519!");
            e.printStackTrace();
        }
    }

    public void initMemberSaasPage(MemberDataBo mdb) {
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458\u4e2a\u6027\u5316\u9875\u9762...");
        String templatePath = this.memberEnvPath + File.separator + "portal.template";
        String outputFileName = this.memberEnvPath + File.separator + mdb.getMemberEnvBo().getMemberid() + File.separator + "login.html";
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458\u767b\u5f55\u9875\u9762...");
        logger.info("Src:" + templatePath + File.separator + "login.html");
        logger.info("Dst:" + outputFileName);
        MemberPageUtil.produceSingleFile(mdb, templatePath, "login.html", outputFileName);
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458\u95e8\u6237\u9996\u9875...");
        outputFileName = this.memberEnvPath + File.separator + mdb.getMemberEnvBo().getMemberid() + File.separator + "index.html";
        logger.info("Src:" + templatePath + File.separator + "index.html");
        logger.info("Dst:" + outputFileName);
        MemberPageUtil.produceSingleFile(mdb, templatePath, "index.html", outputFileName);
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458\u4f01\u4e1a\u7ba1\u7406\u9875\u9762...");
        outputFileName = this.memberEnvPath + File.separator + mdb.getMemberEnvBo().getMemberid() + File.separator + "esaas_em.html";
        logger.info("Src:" + templatePath + File.separator + "esaas_em.html");
        logger.info("Dst:" + outputFileName);
        MemberPageUtil.produceSingleFile(mdb, templatePath, "esaas_em.html", outputFileName);
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458\u91d1\u878d\u4e1a\u52a1\u9875\u9762...");
        outputFileName = this.memberEnvPath + File.separator + mdb.getMemberEnvBo().getMemberid() + File.separator + "esaas_efs.html";
        logger.info("Src:" + templatePath + File.separator + "esaas_efs.html");
        logger.info("Dst:" + outputFileName);
        MemberPageUtil.produceSingleFile(mdb, templatePath, "esaas_efs.html", outputFileName);
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458\u6570\u636e\u4e1a\u52a1\u9875\u9762...");
        outputFileName = this.memberEnvPath + File.separator + mdb.getMemberEnvBo().getMemberid() + File.separator + "esaas_daas.html";
        logger.info("Src:" + templatePath + File.separator + "esaas_daas.html");
        logger.info("Dst:" + outputFileName);
        MemberPageUtil.produceSingleFile(mdb, templatePath, "esaas_daas.html", outputFileName);
        logger.info("\u521d\u59cb\u5316\u4f1a\u5458IT\u4e1a\u52a1\u9875\u9762...");
        outputFileName = this.memberEnvPath + File.separator + mdb.getMemberEnvBo().getMemberid() + File.separator + "esaas_it.html";
        logger.info("Src:" + templatePath + File.separator + "esaas_it.html");
        logger.info("Dst:" + outputFileName);
        MemberPageUtil.produceSingleFile(mdb, templatePath, "esaas_it.html", outputFileName);
    }
}

