/*
 * Decompiled with CFR 0.152.
 */
package main.com.mingtech.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import main.com.mingtech.domain.DocNode;
import main.com.mingtech.domain.FileBean;
import main.com.mingtech.domain.ResultBean;
import main.com.mingtech.util.HttpClientUtils;
import main.com.mingtech.util.StringUtils;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.log4j.Logger;

public class ECMClient {
    private static final Logger logger = Logger.getLogger(ECMClient.class);
    private static ECMClient instance = null;
    public static String LOGIN = "/ecm-management/login";
    public static String DOCUMENT_INIT = "/ecm-management/document/init";
    public static String ORDER_NUM = "/ecm-capture/file/last/ordernum";
    public static String UPLOAD = "/ecm-capture/uploadfile";
    public static final String DEL_URL = "/ecm-imagevw/executeDel";
    public static final String LOGIN_URL = "/ecm-management/login";
    public static final String QUERY_RUL = "/ecm-imagevw/executeQuery";
    public static final String QUERY_URLPrimaryKeys = "/ecm-imagevw/executeQueryByPrimaryKeys";

    public static synchronized ECMClient getInstance() {
        if (instance == null) {
            instance = new ECMClient();
        }
        return instance;
    }

    public static ResultBean uploadFile(FileBean fileBean) {
        try {
            if (!StringUtils.isNotBlank(fileBean.getIp())) {
                return new ResultBean("1011", "IP\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isNotBlank(fileBean.getDocId())) {
                return new ResultBean("1012", "docid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HttpClientUtils client = new HttpClientUtils();
            HashMap<String, String> headMap = new HashMap<String, String>();
            String url = "http://" + fileBean.getIp() + LOGIN + "?username=" + fileBean.getUsername() + "&password=" + fileBean.getPassword();
            String res = client.httpPost(url);
            if (res.indexOf("502") != -1) {
                return new ResultBean("1019", "\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25!");
            }
            JSONObject resJson = JSONObject.parseObject((String)res);
            if ("200".equals(resJson.getString("resultCode"))) {
                headMap.put("Authorization", resJson.getJSONObject("data").getString("Authorization"));
                logger.debug((Object)("\u83b7\u53d6token:" + res));
                url = "http://" + fileBean.getIp() + DOCUMENT_INIT;
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                JSONObject json = new JSONObject();
                json.put("top_outsystem_code", (Object)fileBean.getTopOutCode());
                JSONObject indexjson = new JSONObject();
                Map mp = fileBean.getIndex();
                Iterator it = mp.keySet().iterator();
                boolean bool_key = true;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    indexjson.put(key, mp.get(key));
                }
                json.put("index", (Object)indexjson);
                JSONArray jarr = new JSONArray();
                jarr.add((Object)json);
                paramsMap.put("para", jarr.toJSONString());
                res = client.httpPost(url, paramsMap, headMap);
                if (!StringUtils.isNotBlank(res)) {
                    return new ResultBean("1016", "\u4fdd\u5b58\u7d22\u5f15\u4fe1\u606f\uff0c\u8fd4\u56dejson\u7ed3\u679c\u4e3anull\u6216\u7a7a\u4e32!");
                }
                logger.info((Object)("res:" + res));
                resJson = JSONObject.parseObject((String)res);
                JSONArray listarr = resJson.getJSONArray("data");
                if (listarr != null) {
                    resJson = listarr.getJSONObject(0);
                    paramsMap = new HashMap();
                    if (!(resJson.containsKey((Object)"scanId") && resJson.containsKey((Object)"tn") && resJson.containsKey((Object)"code"))) {
                        logger.error((Object)("\u83b7\u53d6\u6700\u5927\u5e8f\u53f7\u53c2\u6570\u7f3a\u5931\u3002error:" + res));
                        return new ResultBean("1014", "\u83b7\u53d6\u6700\u5927\u5e8f\u53f7\u53c2\u6570\u6709\u8bef\uff0c\u4e0d\u80fd\u4e0a\u4f20");
                    }
                    HashMap outCodeMap = new HashMap();
                    int i = 0;
                    while (i < listarr.size()) {
                        JSONObject js = listarr.getJSONObject(i);
                        ECMClient.initFileTypeMap(outCodeMap, js);
                        ++i;
                    }
                    List<DocNode> ll = fileBean.getDocNodeList();
                    String uplaodurl = "http://" + fileBean.getIp() + UPLOAD;
                    int i2 = 0;
                    while (i2 < ll.size()) {
                        File file;
                        DocNode doc = ll.get(i2);
                        url = "http://" + fileBean.getIp() + ORDER_NUM + "?scanId=" + resJson.getString("scanId") + "&tn=" + resJson.getString("tn") + "&fileCode=" + outCodeMap.get(doc.getFileTypeCode());
                        res = client.httpGet(url, headMap);
                        if (res == null) {
                            res = "0";
                            logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u6700\u5927\u5e8f\u53f7\uff0c\u9ed8\u8ba40");
                        }
                        int order = Integer.valueOf(res);
                        paramsMap.clear();
                        paramsMap.put("scanId", resJson.getString("scanId"));
                        paramsMap.put("tn", resJson.getString("tn"));
                        if (outCodeMap.get(doc.getFileTypeCode()) == null) {
                            return new ResultBean("1018", "\u6839\u8282\u70b9\u5bf9\u5e94\u7684\u5c0f\u8282\u70b9\u4e0d\u5b58\u5728");
                        }
                        paramsMap.put("fileCode", (String)outCodeMap.get(doc.getFileTypeCode()));
                        paramsMap.put("outCode", doc.getFileTypeCode());
                        InetAddress ia = InetAddress.getLocalHost();
                        paramsMap.put("uploadIp", ia.getHostAddress());
                        paramsMap.put("isCut", "0");
                        paramsMap.put("isSeal", "0");
                        List<File> fileList = doc.getImageList();
                        int j = 0;
                        int k = 0;
                        int l = 0;
                        j = 0;
                        while (j < fileList.size()) {
                            file = fileList.get(j);
                            paramsMap.put("lastOrderNum", String.valueOf(order + j));
                            byte[] bt = null;
                            if (fileBean.isThumbnail()) {
                                bt = ECMClient.createThumbnail(file, fileBean.getWidth(), fileBean.getHeight());
                            }
                            logger.info((Object)("\u4e0a\u4f20\u56fe\u7247:" + file.getName()));
                            res = file.length() > 0x100000L ? client.httpPostFile(uplaodurl, paramsMap, headMap, ECMClient.fileToByte(file, fileBean.getImgScale(), fileBean.getImgQuality()), bt, file.getName()) : client.httpPostFile(uplaodurl, paramsMap, headMap, file, bt);
                            logger.debug((Object)res);
                            if (!StringUtils.isNotBlank(res) || !res.equals("1")) {
                                return new ResultBean("9999", "\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff0cdocid\uff1a" + fileBean.getDocId());
                            }
                            logger.info((Object)("\u4e0a\u4f20:" + file.getName() + "\u6210\u529f\uff01  docid:" + fileBean.getDocId()));
                            ++j;
                        }
                        fileList = doc.getDocList();
                        k = 0;
                        while (k < fileList.size()) {
                            file = fileList.get(k);
                            paramsMap.put("lastOrderNum", String.valueOf(order + j + k));
                            logger.info((Object)("\u4e0a\u4f20\u6587\u6863:" + file.getName()));
                            res = client.httpPostFile(uplaodurl, paramsMap, headMap, file, null);
                            if (!StringUtils.isNotBlank(res) || !res.equals("1")) {
                                return new ResultBean("9999", "\u4e0a\u4f20\u6587\u6863\u5931\u8d25\uff0cdocid\uff1a" + fileBean.getDocId());
                            }
                            logger.info((Object)("\u4e0a\u4f20:" + file.getName() + "\u6210\u529f\uff01  docid:" + fileBean.getDocId()));
                            ++k;
                        }
                        fileList = doc.getAviList();
                        l = 0;
                        while (l < fileList.size()) {
                            file = fileList.get(l);
                            paramsMap.put("lastOrderNum", String.valueOf(order + j + k + l));
                            logger.info((Object)("\u4e0a\u4f20\u89c6\u9891:" + file.getName()));
                            res = client.httpPostFile(uplaodurl, paramsMap, headMap, file, null);
                            if (!StringUtils.isNotBlank(res) || !res.equals("1")) {
                                return new ResultBean("9999", "\u4e0a\u4f20\u89c6\u9891\u5931\u8d25\uff0cdocid\uff1a" + fileBean.getDocId());
                            }
                            logger.info((Object)("\u4e0a\u4f20:" + file.getName() + "\u6210\u529f\uff01  docid:" + fileBean.getDocId()));
                            ++l;
                        }
                        ++i2;
                    }
                    return new ResultBean("0000", "\u4e0a\u4f20\u6210\u529f");
                }
                return new ResultBean("9999", "\u4fdd\u5b58\u7d22\u5f15\u4fe1\u606f\u5931\u8d25\uff1a" + json.toJSONString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultBean("9999", "\u4e0a\u4f20\u5931\u8d25,uploadFile.error:" + e);
        }
        return new ResultBean("9999", "\u4e0a\u4f20\u5931\u8d25");
    }

    private static void initFileTypeMap(Map outCodeMap, JSONObject json) {
        if (json.containsKey((Object)"childs")) {
            JSONArray chils = json.getJSONArray("childs");
            int j = 0;
            while (j < chils.size()) {
                JSONObject js = chils.getJSONObject(j);
                outCodeMap.put(json.get((Object)"outCode"), json.get((Object)"code"));
                ECMClient.initFileTypeMap(outCodeMap, js);
                ++j;
            }
        } else {
            outCodeMap.put(json.get((Object)"outCode"), json.get((Object)"code"));
        }
    }

    public static byte[] createThumbnail(File file, int width, int height) {
        byte[] bt = null;
        try {
            BufferedImage input = ImageIO.read(file);
            BufferedImage bi = Thumbnails.of((BufferedImage[])new BufferedImage[]{input}).size(width, height).keepAspectRatio(false).outputFormat("jpg").asBufferedImage();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", os);
            bt = os.toByteArray();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)("\u751f\u6210\u7f29\u7565\u56fe\u5f02\u5e38" + e));
        }
        return bt;
    }

    public ResultBean deleteFile(FileBean fileBean) {
        HttpClientUtils client = new HttpClientUtils();
        HashMap<String, String> headMap = new HashMap<String, String>();
        String url = "http://" + fileBean.getIp() + LOGIN + "?username=" + fileBean.getUsername() + "&password=" + fileBean.getPassword();
        String res = client.httpPost(url);
        JSONObject resJson = JSONObject.parseObject((String)res);
        if ("200".equals(resJson.getString("resultCode"))) {
            headMap.put("Authorization", resJson.getJSONObject("data").getString("Authorization"));
            logger.debug((Object)("\u83b7\u53d6token:" + res));
            url = "http://" + fileBean.getIp() + DEL_URL;
            JSONObject paraJson = new JSONObject();
            paraJson.put("docId", (Object)fileBean.getDocId());
            paraJson.put("outCode", (Object)fileBean.getTopOutCode());
            paraJson.put("isSlice", (Object)fileBean.isSlice());
            paraJson.put("isStampCheck", (Object)fileBean.isStampCheck());
            paraJson.put("ids", (Object)fileBean.getDelIds());
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("jsonPara", paraJson.toJSONString());
            res = client.httpPost(url, paraMap, headMap);
            if (!StringUtils.isNotBlank(res)) {
                logger.error((Object)("\u5220\u9664\u5931\u8d25\uff0cdocid\uff1a" + fileBean.getDocId()));
                return new ResultBean("1017", "\u5220\u9664\u5931\u8d25\uff01");
            }
            JSONObject result = JSONObject.parseObject((String)res);
            ResultBean rb = new ResultBean("0000", result.getString("resultDesc"));
            return rb;
        }
        return new ResultBean("9999", "\u5220\u9664\u5931\u8d25");
    }

    public ResultBean findFile(FileBean fileBean) {
        HttpClientUtils client = new HttpClientUtils();
        HashMap<String, String> headMap = new HashMap<String, String>();
        String url = "http://" + fileBean.getIp() + LOGIN + "?username=" + fileBean.getUsername() + "&password=" + fileBean.getPassword();
        String res = client.httpPost(url);
        JSONObject resJson = JSONObject.parseObject((String)res);
        if ("200".equals(resJson.getString("resultCode"))) {
            headMap.put("Authorization", resJson.getJSONObject("data").getString("Authorization"));
            logger.debug((Object)("\u83b7\u53d6token:" + res));
            url = "http://" + fileBean.getIp() + QUERY_RUL;
            JSONObject paraJson = new JSONObject();
            paraJson.put("docId", (Object)fileBean.getDocId());
            paraJson.put("outCode", (Object)fileBean.getTopOutCode());
            paraJson.put("isSlice", (Object)fileBean.isSlice());
            paraJson.put("isStampCheck", (Object)fileBean.isStampCheck());
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("jsonPara", paraJson.toJSONString());
            res = client.httpPost(url, paraMap, headMap);
            if (!StringUtils.isNotBlank(res)) {
                logger.error((Object)("\u67e5\u8be2\u5931\u8d25\uff0cdocid\uff1a" + fileBean.getDocId()));
                return new ResultBean("1015", "\u67e5\u8be2\u5931\u8d25!");
            }
            ResultBean rb = new ResultBean("0000", "OK");
            JSONObject source = JSONObject.parseObject((String)res);
            rb.setJsonData(JSONObject.parseObject((String)res));
            return rb;
        }
        return new ResultBean("9999", "\u67e5\u8be2\u5f02\u5e38");
    }

    public ResultBean findFileByPrimaryKeys(FileBean fileBean) {
        HttpClientUtils client = new HttpClientUtils();
        HashMap<String, String> headMap = new HashMap<String, String>();
        String url = "http://" + fileBean.getIp() + LOGIN + "?username=" + fileBean.getUsername() + "&password=" + fileBean.getPassword();
        String res = client.httpPost(url);
        JSONObject resJson = JSONObject.parseObject((String)res);
        if ("200".equals(resJson.getString("resultCode"))) {
            JSONObject indexjson = new JSONObject();
            Map mp = fileBean.getIndex();
            Iterator it = mp.keySet().iterator();
            boolean bool_key = true;
            while (it.hasNext()) {
                String key = (String)it.next();
                indexjson.put(key, mp.get(key));
            }
            headMap.put("Authorization", resJson.getJSONObject("data").getString("Authorization"));
            logger.debug((Object)("\u83b7\u53d6token:" + res));
            url = "http://" + fileBean.getIp() + QUERY_URLPrimaryKeys;
            JSONObject paraJson = new JSONObject();
            paraJson.put("docId", (Object)fileBean.getDocId());
            paraJson.put("index", (Object)indexjson);
            paraJson.put("outCode", (Object)fileBean.getTopOutCode());
            paraJson.put("isSlice", (Object)fileBean.isSlice());
            paraJson.put("isStampCheck", (Object)fileBean.isStampCheck());
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("jsonPara", paraJson.toJSONString());
            res = client.httpPost(url, paraMap, headMap);
            if (!StringUtils.isNotBlank(res)) {
                logger.error((Object)("\u67e5\u8be2\u5931\u8d25\uff0cdocid\uff1a" + fileBean.getDocId()));
                return new ResultBean("1015", "\u67e5\u8be2\u5931\u8d25!");
            }
            ResultBean rb = new ResultBean("0000", "OK");
            JSONObject source = JSONObject.parseObject((String)res);
            rb.setJsonData(JSONObject.parseObject((String)res));
            return rb;
        }
        return new ResultBean("9999", "\u67e5\u8be2\u5f02\u5e38");
    }

    public static byte[] fileToByte(File file, float scale, float quality) throws IOException {
        BufferedImage bi = Thumbnails.of((File[])new File[]{file}).useExifOrientation(false).scale((double)scale).outputQuality(quality).asBufferedImage();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, file.getName().substring(file.getName().lastIndexOf(".") + 1), os);
        byte[] bt = os.toByteArray();
        os.close();
        return bt;
    }
}

