/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientConfiguration {
    private static final String[] DEFAULT_RESOURCE = new String[]{"clientConfig.properties"};
    private static volatile boolean INIT = false;
    private static Properties props;
    private static String[] RESOURCES;
    private static final Logger LOG;

    static {
        RESOURCES = DEFAULT_RESOURCE;
        LOG = Logger.getLogger(ClientConfiguration.class);
    }

    public static String get(String key) {
        return props.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public static float getFloat(String name, float defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int getInt(String name, int defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(String name, long defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void init() {
        block14: {
            if (INIT) {
                return;
            }
            props = new Properties();
            InputStream in = null;
            try {
                try {
                    String[] stringArray = RESOURCES;
                    int n = RESOURCES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String resource = stringArray[n2];
                        LOG.info((Object)("load resource:" + resource));
                        in = ClientConfiguration.class.getClassLoader().getResourceAsStream(resource);
                        props.load(in);
                        in.close();
                        ++n2;
                    }
                    INIT = true;
                }
                catch (Exception e) {
                    INIT = false;
                    ClientConfiguration.clear();
                    LOG.warn((Object)("Failed to init conf, resource:" + Arrays.toString(RESOURCES)));
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void init(String[] resource) {
        RESOURCES = resource;
        ClientConfiguration.init();
    }

    public static void clear() {
        props.clear();
    }
}

