/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.conn;

import com.sunyard.client.conn.TransConn;
import com.sunyard.ws.client.WSAccessClient;
import com.sunyard.ws.comm.Base64Coder;
import com.sunyard.ws.internalapi.SunEcmAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class WSConn
implements TransConn {
    private Logger log = Logger.getLogger(WSConn.class);
    private static SunEcmAccess access;
    private static WSAccessClient wsAccessClient;
    private String returnMsg = "";

    static {
        wsAccessClient = new WSAccessClient();
    }

    private String getReturnMsg() {
        return this.returnMsg;
    }

    private void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public WSConn(String ip, int httpPort, String serverName) {
        String url = "http://" + ip + ":" + httpPort + "/" + serverName + "/webservices/WsInterface";
        this.log.info((Object)("--WSConn-->WSConn-->\u5efa\u7acbWEBSERVICE\u8fde\u63a5:" + url));
        access = wsAccessClient.getAccessClient(url, 300000L);
    }

    @Override
    public void destroy() {
    }

    @Override
    public String receiveMsg() {
        return this.getReturnMsg();
    }

    @Override
    public boolean sendFileData(String filePath, String contentID, String transType) throws IOException {
        File file;
        this.log.info((Object)("WEBSERVICE\u53d1\u9001\u6587\u4ef6,\u6587\u4ef6\u8def\u5f84:" + filePath + ",\u5185\u5bb9ID:" + contentID));
        int i = filePath.lastIndexOf(46);
        String format = "";
        if (i > -1 && i < filePath.length()) {
            format = filePath.substring(i + 1, filePath.length());
        }
        if (!(file = new File(filePath)).exists()) {
            this.log.debug((Object)("\u6587\u4ef6\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84:" + filePath));
            return false;
        }
        long fileSize = file.length();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("FILENAME=" + file.getName() + ",FILESIZE=" + Long.toString(fileSize) + ",FILEPATH=" + filePath + ",CONTENTID = " + contentID + ",FORMAT=" + format + ",FILE=");
        try {
            byte[] fileBytes = WSConn.getBytesFromFile(file);
            char[] fileChars = Base64Coder.encode((byte[])fileBytes);
            sbuf.append(fileChars);
            access.receiveFileFromClient(sbuf.toString());
            return true;
        }
        catch (IOException e) {
            this.log.error((Object)("-->WSConn-->sendFileData-->SunECMException-->" + e.toString()));
            throw new IOException(e.toString());
        }
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            throw new IOException("File is to large " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            ((InputStream)is).close();
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    @Override
    public void sendMsg(String msg) {
        this.log.info((Object)"WEBSERVICE\u53d1\u9001\u6d88\u606f");
        String returnMsg = access.receiveMsgFromClient(msg);
        this.setReturnMsg(returnMsg);
    }
}

