/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptUtil {
    private Key key = null;
    private Cipher cipher;
    public static Logger logger = Logger.getLogger(EncryptUtil.class);
    private static volatile Map<String, EncryptUtil> encryptMap = new HashMap<String, EncryptUtil>();

    public static synchronized EncryptUtil getInstance(String keyFile) {
        EncryptUtil imp = null;
        try {
            imp = encryptMap.get(keyFile);
            if (imp == null) {
                imp = new EncryptUtil(keyFile);
                encryptMap.put(keyFile, imp);
            }
            return imp;
        }
        catch (Exception e) {
            logger.error((Object)("key file" + keyFile), (Throwable)e);
            return imp;
        }
    }

    private EncryptUtil(String keyFile) {
        if (this.key == null) {
            SecretKeySpec keyspec = this.readInformation(keyFile);
            this.key = keyspec;
        }
        try {
            this.cipher = Cipher.getInstance("DESede");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("\u5b9e\u4f8b\u5316\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage()));
            logger.error((Object)"NoSuchAlgorithmException\uff1a", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)("\u5b9e\u4f8b\u5316\u52a0\u5bc6\u89e3\u5bc6\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage()));
            logger.error((Object)"NoSuchPaddingException\uff1a", (Throwable)e);
        }
    }

    public synchronized String Encrypt(String str) {
        String encStr = "";
        byte[] encryptArray = new byte[]{};
        try {
            this.cipher.init(1, this.key);
            byte[] arrayStr = str.getBytes("UTF-8");
            encryptArray = this.cipher.doFinal(arrayStr);
            encStr = this.byteArrayToString(encryptArray);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("\u52a0\u5bc6\u7b97\u6cd5|\u5bc6\u94a5\u65e0\u6548\uff1a" + e.getMessage()));
            logger.error((Object)"InvalidKeyException\uff1a", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)("\u52a0\u5bc6\u7b97\u6cd5\uff1a" + e.getMessage()));
            logger.error((Object)"IllegalBlockSizeException\uff1a", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)("\u52a0\u5bc6\u7b97\u6cd5\uff1a" + e.getMessage()));
            logger.error((Object)"BadPaddingException\uff1a", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("\u52a0\u5bc6\u7b97\u6cd5|\u5b57\u7b26\u96c6\u7f16\u7801\u4e0d\u652f\u6301\uff1a" + e.getMessage()));
            logger.error((Object)"UnsupportedEncodingException\uff1a", (Throwable)e);
        }
        return encStr;
    }

    public synchronized String deEncrypt(String obj) {
        byte[] dencryptArray = new byte[]{};
        try {
            String value = new String(obj.getBytes("UTF-8"));
            byte[] dencStr = this.stringToByteArray(value);
            this.cipher.init(2, this.key);
            dencryptArray = this.cipher.doFinal(dencStr);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("\u89e3\u5bc6\u7b97\u6cd5|\u5bc6\u94a5\u65e0\u6548\uff1a" + e.getMessage()));
            logger.error((Object)"InvalidKeyException\uff1a", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)("\u89e3\u5bc6\u7b97\u6cd5\uff1a" + e.getMessage()));
            logger.error((Object)"IllegalBlockSizeException\uff1a", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)("\u89e3\u5bc6\u7b97\u6cd5\uff1a" + e.getMessage()));
            logger.error((Object)"BadPaddingException\uff1a", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("\u89e3\u5bc6\u7b97\u6cd5|\u5b57\u7b26\u96c6\u7f16\u7801\u4e0d\u652f\u6301\uff1a" + e.getMessage()));
            logger.error((Object)"UnsupportedEncodingException\uff1a", (Throwable)e);
        }
        return new String(dencryptArray);
    }

    public byte[] stringToByteArray(String serializerStr) {
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] strByte = null;
        try {
            strByte = decoder.decodeBuffer(serializerStr);
        }
        catch (IOException e) {
            logger.error((Object)("\u5c06String\u8f6c\u5316\u4e3aByte\u6570\u7ec4" + e.getMessage()));
            logger.error((Object)"IOException\uff1a", (Throwable)e);
        }
        return strByte;
    }

    public String byteArrayToString(byte[] stream) {
        BASE64Encoder enc = new BASE64Encoder();
        return enc.encode(stream);
    }

    public SecretKeySpec readInformation(String keyFile) {
        SecretKeySpec keyGenerator = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(EncryptUtil.class.getClassLoader().getResourceAsStream(keyFile));
            keyGenerator = (SecretKeySpec)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("\u627e\u4e0d\u5230\u7c7b\uff1a" + e.getMessage()));
            logger.error((Object)"ClassNotFoundException\uff1a", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + e.getMessage()));
            logger.error((Object)"FileNotFoundException\uff1a", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("IO\u6d41\u5f02\u5e38\uff1a" + e.getMessage()));
            logger.error((Object)"IOException\uff1a", (Throwable)e);
        }
        return keyGenerator;
    }

    public static void writeInformation(String allpath, Object obj) throws IOException {
        FileOutputStream fos = new FileOutputStream(allpath);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
    }

    public static void main(String[] strs) {
        System.out.println(EncryptUtil.getInstance("UK.dvc").deEncrypt("5VroJVmANCNZca4XjSkxUFwoXjs7g0XNBuROZst+nA9ldcVdZKs7Na5a3rMLXtyaoWXTGHhxLAtM&#xd;lkaQ1XWlsMLoDH0xXTPUTt/wZGC/FDiqUJX5Qa8ta1lFmVjgUwhP/GOTZ6AiNELCqJPzxreHN7pi&#xd;yxSLoTWP3Pw6oP0q2CDX/D7rm/VoSyvn7zH+rSDWVER+LrjzCVTBs9685sJRuG3CtYvYEl8VMmWj&#xd;oiUmxWU="));
    }
}

