/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.exception.SunECMException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);
    private static final Map mFileTypes = new HashMap();

    static {
        mFileTypes.put("FFD8FF", "jpg");
        mFileTypes.put("FFD8FFEO", "jpg");
        mFileTypes.put("89504E47", "png");
        mFileTypes.put("424D4296", "png");
        mFileTypes.put("47494638", "gif");
        mFileTypes.put("49492A00", "tif");
        mFileTypes.put("424D", "bmp");
        mFileTypes.put("41433130", "dwg");
        mFileTypes.put("38425053", "psd");
        mFileTypes.put("7B5C727466", "rtf");
        mFileTypes.put("3C3F786D6C", "xml");
        mFileTypes.put("68746D6C3E", "html");
        mFileTypes.put("44656C69766572792D646174653A", "eml");
        mFileTypes.put("D0CF11E0", "doc");
        mFileTypes.put("5374616E64617264204A", "mdb");
        mFileTypes.put("252150532D41646F6265", "ps");
        mFileTypes.put("255044462D312E", "pdf");
        mFileTypes.put("25504446", "pdf");
        mFileTypes.put("504B0304", "docx");
        mFileTypes.put("52617221", "rar");
        mFileTypes.put("57415645", "wav");
        mFileTypes.put("41564920", "avi");
        mFileTypes.put("2E524D46", "rm");
        mFileTypes.put("000001BA", "mpg");
        mFileTypes.put("000001B3", "mpg");
        mFileTypes.put("6D6F6F76", "mov");
        mFileTypes.put("3026B2758E66CF11", "asf");
        mFileTypes.put("4D546864", "mid");
        mFileTypes.put("1F8B08", "gz");
        mFileTypes.put("377ABCAF", "7z");
        mFileTypes.put("44656C69766572792D646174653A", "eml");
        mFileTypes.put("CFAD12FEC5FD746F", "dbx");
        mFileTypes.put("FF575043", "wpd");
        mFileTypes.put("AC9EBD8F", "qdf");
        mFileTypes.put("E3828596", "pwl");
        mFileTypes.put("504B0304", "zip");
        mFileTypes.put("2E7261FD", "ram");
        mFileTypes.put("2142444E", "pst");
    }

    public static String getRandomFolder() {
        return FileUtil.getRandomFolder(1000);
    }

    public static String getLayerRandomFolder() {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(random.nextInt(1000));
    }

    public static String getRandomFolder(int max) {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(String.valueOf(random.nextInt(max))) + File.separator + String.valueOf(random.nextInt(max));
    }

    public static String getLayerRandomFolder(int max) {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(random.nextInt(max));
    }

    public static boolean creatFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String fileNameOption(String fileId, String fileName) {
        int index = fileName.indexOf(".");
        if (index < 0) {
            return fileId;
        }
        return String.valueOf(fileId) + fileName.substring(index);
    }

    public static boolean existsFile(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static void copyFile(String oldRootPath, String newRootPath, String filePath) throws Exception {
        File oldPathFile = new File(String.valueOf(oldRootPath) + filePath);
        String oldPath = oldPathFile.getParent();
        File oldFile = new File(oldRootPath);
        String s = oldFile.getName();
        oldPath = oldPath.substring(oldPath.indexOf(s) + s.length());
        String newPath = String.valueOf(newRootPath) + oldPath;
        while (!FileUtil.creatFolder(newPath)) {
        }
        FileUtil.copyFile(String.valueOf(oldRootPath) + filePath, String.valueOf(newRootPath) + filePath);
    }

    public static void copyFile(String oldPath, String newPath) throws Exception {
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        FileUtil.forChannel(oldFile, newFile);
    }

    public static void forChannel(File f1, File f2) throws Exception {
        int length = 0x200000;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        FileChannel inC = in.getChannel();
        FileChannel outC = out.getChannel();
        ByteBuffer b = null;
        try {
            while (inC.position() != inC.size()) {
                length = inC.size() - inC.position() < (long)length ? (int)(inC.size() - inC.position()) : 0x200000;
                b = ByteBuffer.allocateDirect(length);
                inC.read(b);
                b.flip();
                outC.write(b);
                outC.force(false);
            }
        }
        finally {
            inC.close();
            outC.close();
            in.close();
            out.close();
        }
    }

    public static boolean deleteFile(String filePath) {
        boolean result;
        File file;
        block5: {
            file = new File(filePath);
            try {
                if (!file.exists()) break block5;
                int i = 0;
                while (i < 10) {
                    file.delete();
                    if (file.exists()) {
                        Thread.sleep(100L);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.warn((Object)("delete file:" + filePath), (Throwable)e);
            }
        }
        if (result = file.exists()) {
            log.warn((Object)("file can not delete:" + filePath));
        }
        return result;
    }

    public static boolean isFileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static Properties readProperties(String path) {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static BufferedInputStream getFile(String filePath) throws SunECMException, FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SunECMException(707, "getFile: \u627e\u4e0d\u5230\u6587\u4ef6");
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        return inputStream;
    }

    public static String readXml(String path) throws IOException, SunECMException {
        File file = new File(path);
        InputStream in = null;
        long date1 = System.currentTimeMillis();
        StringBuffer buffer = new StringBuffer();
        if (file.isFile()) {
            try {
                try {
                    byte[] tempbytes = new byte[1024];
                    in = new FileInputStream(file);
                    int len = 0;
                    while ((len = in.read(tempbytes)) != -1) {
                        buffer.append(new String(tempbytes, 0, len));
                    }
                }
                catch (FileNotFoundException e) {
                    throw new SunECMException(707, "FileUtil-->readXml: " + e.toString());
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            String anStr = buffer.toString();
            long date2 = System.currentTimeMillis();
            log.debug((Object)("\u8bfb\u53d6\u4e00\u4e2a\u6279\u6ce8xml\u6587\u4ef6\u82b1\u8d39\u65f6\u95f4\uff1a " + (date2 - date1) + "\u6beb\u79d2"));
            return anStr;
        }
        throw new SunECMException(707, "FileUtil-->readXml...path is not file name ...");
    }

    public static void writeXML(String xml, String filePath, String fileName) throws SunECMException {
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        File file = new File(String.valueOf(filePath) + fileName + ".xml");
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(xml.getBytes());
            }
            catch (FileNotFoundException e) {
                throw new SunECMException(707, "FileUtil-->writeXML: " + e.toString());
            }
            catch (IOException e) {
                throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
            }
        }
    }

    public static String createSaveName(String filePath, String fileNO) {
        if (!FileUtil.isFileExists(String.valueOf(filePath) + fileNO)) {
            return fileNO;
        }
        int i = 1;
        while (FileUtil.isFileExists(String.valueOf(filePath) + fileNO + "-" + i)) {
            ++i;
        }
        return String.valueOf(fileNO) + "-" + i;
    }

    public static String getFileHeader(InputStream inputStream) throws IOException {
        String value = null;
        try {
            try {
                byte[] b = new byte[4];
                inputStream.read(b, 0, b.length);
                value = FileUtil.bytesToHexString(b);
                log.debug((Object)("\u6587\u4ef6\u540e\u7f00:" + value));
                value = (String)mFileTypes.get(value);
                System.out.println("\u6587\u4ef6\u540e\u7f00:" + value);
            }
            catch (Exception exception) {
                inputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return value;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            String hv = Integer.toHexString(src[i] & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
            ++i;
        }
        return builder.toString();
    }

    public static void readFileMethod(InputStream is, String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            log.debug((Object)"\u78c1\u76d8\u4e2d\u6709\u91cd\u590d\u6587\u4ef6");
            return;
        }
        file.createNewFile();
        FileOutputStream fw = new FileOutputStream(file);
        int i = 0;
        while ((i = is.read()) != -1) {
            fw.write(i);
        }
        log.debug((Object)("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5b8c\u6bd5finish!" + path));
        is.close();
        fw.flush();
        fw.close();
    }

    public static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

