/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util.ecm3_1;

import com.sunyard.client.conn.HttpConn;
import com.sunyard.ecm.server.bean.LifeCycleStrategyBean;
import com.sunyard.ecm.server.bean.NodeInfo;
import com.sunyard.ecm.server.cache.LazySingleton;
import com.sunyard.exception.SunECMException;
import com.sunyard.initialization.LoadConfigFile;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DMInGroupUtil {
    private static Logger log = Logger.getLogger(DMInGroupUtil.class);
    private static final String agreement = LazySingleton.getInstance().load.getConfigBean().getAgreement();

    public static NodeInfo getNodeInfoByGroupID(String groupID) throws SunECMException {
        if (groupID == null) {
            return null;
        }
        ArrayList<NodeInfo> abandonedNodes = new ArrayList<NodeInfo>();
        NodeInfo resultServer = DMInGroupUtil.getGroupNodeList(groupID, abandonedNodes);
        if (resultServer == null) {
            log.warn((Object)("--DMInGroupUtil-->getNodeInfoByGroupID-->\u670d\u52a1\u5668\u7ec4\u540d\u79f0\u4f20\u5165[" + groupID + "]\u4e0d\u6b63\u786e,\u6216\u7edf\u4e00\u63a5\u5165\u672a\u4eceConsole\u63a5\u6536\u5230\u8be5\u670d\u52a1\u5668\u7ec4\u7684\u914d\u7f6e\u4fe1\u606f,\u6216\u6240\u67e5\u8be2\u7684\u5167\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7ec4[" + groupID + "]\u4e0b\u6240\u6709\u670d\u52a1\u5668\u5747\u5df2\u505c\u7528"));
            throw new SunECMException(744, "--DMInGroupUtil-->getNodeInfoByGroupID-->\u670d\u52a1\u5668\u7ec4\u540d\u79f0\u4e0d\u6b63\u786e,\u7edf\u4e00\u63a5\u5165\u672a\u4eceConsole\u63a5\u6536\u5230\u8be5[" + groupID + "]\u670d\u52a1\u5668\u7ec4\u7684\u914d\u7f6e\u4fe1\u606f,\u6240\u67e5\u8a62\u7684\u5167\u5bb9\u5b58\u5132\u670d\u52a1\u5668\u7ec4\u6240\u6709\u670d\u52a1\u5668\u5747\u5df2\u505c\u7528");
        }
        return resultServer;
    }

    private static NodeInfo getGroupNodeList(String groupID, List<NodeInfo> abandonedNodeList) throws SunECMException {
        Map totalNode = LazySingleton.getInstance().allNodeInfoTable.getAllNodeInfoTable();
        ArrayList<NodeInfo> servers = new ArrayList<NodeInfo>();
        Map<String, NodeInfo> map = DMInGroupUtil.removeAbandonedNode(totalNode, abandonedNodeList);
        Set<String> set = map.keySet();
        int total = 0;
        boolean flag = true;
        for (String serverID : set) {
            NodeInfo server = map.get(serverID);
            if (server.getGroup_name() == null || !groupID.equals(server.getGroup_id()) || !"1".equals(server.getState())) continue;
            servers.add(server);
            total += Integer.valueOf(server.getWetght()).intValue();
            flag = false;
        }
        if (flag) {
            throw new SunECMException(744, "\u670d\u52a1\u5668\u7ec4\u540d\u79f0\u4e0d\u6b63\u786e,\u672a\u4eceConsole\u63a5\u6536\u5230\u8be5\u670d\u52a1\u5668\u7ec4\u7684\u914d\u7f6e\u4fe1\u606f,\u6240\u67e5\u8a62\u7684\u5167\u5bb9\u5b58\u5132\u670d\u52a1\u5668\u7ec4\u6240\u6709\u670d\u52a1\u5668\u5747\u5df2\u505c\u7528");
        }
        double start = 0.0;
        double end = 0.0;
        double randomNumber = Math.random() * (double)total;
        NodeInfo resultServer = null;
        int i = 0;
        while (i < servers.size()) {
            end += Double.valueOf(((NodeInfo)servers.get(i)).getWetght()).doubleValue();
            if (randomNumber >= start && randomNumber <= end) {
                resultServer = (NodeInfo)servers.get(i);
                break;
            }
            start = end;
            ++i;
        }
        if (resultServer != null) {
            log.debug((Object)("\u627e\u5230groupID[" + groupID + "]\u4e0b\u53ef\u8fde\u63a5\u7684\u5185\u5bb9\u670d\u52a1\u5668[" + resultServer.getServer_name() + "]"));
        } else {
            log.debug((Object)("\u672a\u627e\u5230groupID[" + groupID + "]\u4e0b\u53ef\u8fde\u63a5\u7684\u5185\u5bb9\u670d\u52a1\u5668"));
        }
        return resultServer;
    }

    private static Map<String, NodeInfo> removeAbandonedNode(Map<String, NodeInfo> totalNode, List<NodeInfo> abandonedNodeList) {
        for (NodeInfo nodeInfo : abandonedNodeList) {
            totalNode.remove(nodeInfo.getServer_id());
        }
        return totalNode;
    }

    public static boolean isDMOnLive(NodeInfo node) throws SunECMException {
        log.info((Object)"--DMInGroupUtil-->isDMOnLive-->\u6821\u9a8cDM\u662f\u5426\u53ef\u4ee5\u8fde\u901a");
        if ("http".equals(agreement)) {
            return DMInGroupUtil.isHttpLive(node);
        }
        return DMInGroupUtil.isSocketLive(node);
    }

    public static boolean isHttpLive(NodeInfo node) throws SunECMException {
        log.debug((Object)("DM\u6d4b\u8bd5\u8fde\u63a5\u76ee\u6807\u5185\u5bb9\u5b58\u50a8\u5668[" + node.getServer_name() + "]\u7684http\u8fde\u63a5,IP\u4e3a[" + node.getServer_ip() + "],http\u7aef\u53e3\u4e3a[" + node.getHttp_port() + "]"));
        int connectretrytimes = 5;
        String host = node.getServer_ip();
        int port = Integer.valueOf(node.getHttp_port());
        int i = 0;
        while (i < 5) {
            if (DMInGroupUtil.newhttpHost(host, port)) {
                return true;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.debug((Object)("\u5f53\u524d\u8fde\u63a5\u6b21\u6570\uff1a" + (i + 1)));
            }
            if (i == 4) {
                throw new SunECMException(736, "HTTP\u8fde\u63a5\u4e3b\u673a\uff1a" + host + " \u7aef\u53e3:" + port + "\u5931\u8d25");
            }
            ++i;
        }
        return false;
    }

    public static boolean isSocketLive(NodeInfo node) throws SunECMException {
        log.debug((Object)("DM\u6d4b\u8bd5\u8fde\u63a5\u76ee\u6807\u5185\u5bb9\u5b58\u50a8\u5668[" + node.getServer_name() + "]\u7684socket\u8fde\u63a5,IP\u4e3a[" + node.getServer_ip() + "],socket\u7aef\u53e3\u4e3a[" + node.getSocket_port() + "]"));
        int connectretrytimes = 5;
        String host = node.getServer_ip();
        int port = Integer.valueOf(node.getSocket_port());
        int i = 0;
        while (i < 5) {
            if (DMInGroupUtil.newSocketHost(host, port)) {
                return true;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.debug((Object)("\u5f53\u524d\u8fde\u63a5\u6b21\u6570\uff1a" + (i + 1)));
            }
            if (i == 4) {
                throw new SunECMException(736, "SOCKET\u8fde\u63a5\u4e3b\u673a\uff1a" + host + " \u7aef\u53e3:" + port + "\u5931\u8d25");
            }
            ++i;
        }
        return false;
    }

    private static boolean newSocketHost(String ip, int socketPort) {
        log.debug((Object)("\u5c1d\u8bd5\u5411\u76ee\u6807\u670d\u52a1\u5668\u5efa\u7acbsocekt\u8fde\u63a5,IP\u5730\u5740\u4e3a[" + ip + "],socket\u7aef\u53e3\u4e3a[" + socketPort + "]"));
        Socket socket = null;
        try {
            socket = new Socket(ip, socketPort);
        }
        catch (UnknownHostException e) {
            log.warn((Object)("\u627e\u4e0d\u5230\u76ee\u6807\u670d\u52a1\u5668,\u5efa\u7acbsocekt\u8fde\u63a5\u5931\u8d25,IP\u5730\u5740\u4e3a[" + ip + "],socket\u7aef\u53e3\u4e3a[" + socketPort + "]"));
            return false;
        }
        catch (IOException e) {
            log.warn((Object)("IO\u5f02\u5e38,\u5efa\u7acbsocekt\u8fde\u63a5\u5931\u8d25,IP\u5730\u5740\u4e3a[" + ip + "],socket\u7aef\u53e3\u4e3a[" + socketPort + "]"));
            return false;
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            log.error((Object)("IO\u5f02\u5e38,DM\u6d4b\u8bd5socekt\u8fde\u63a5\u6210\u529f\u540e\u5173\u95ed\u8fde\u63a5\u5931\u8d25,IP\u5730\u5740\u4e3a[" + ip + "],socket\u7aef\u53e3\u4e3a[" + socketPort + "]"));
        }
        return true;
    }

    private static boolean newhttpHost(String ip, int httpPort) {
        log.debug((Object)("\u5c1d\u8bd5\u5411\u76ee\u6807\u670d\u52a1\u5668\u5efa\u7acbhttp\u8fde\u63a5,IP\u5730\u5740\u4e3a[" + ip + "],http\u7aef\u53e3\u4e3a[" + httpPort + "]"));
        String serverName = LoadConfigFile.getInstance().getConfigBean().getLocalName();
        int connTimeOut = 30000;
        int reqTimeOut = 30000;
        try {
            String url = "http://" + ip + ":" + httpPort + "/" + serverName + "/servlet/httpReqDispacher";
            log.debug((Object)("HTTP\u8fde\u63a5\u5730\u5740\uff1a[" + url + "]"));
            new HttpConn(url, connTimeOut, reqTimeOut);
        }
        catch (Exception e) {
            log.warn((Object)("\u5efa\u7acbhttp\u8fde\u63a5,IP\u5730\u5740\u4e3a[" + ip + "],http\u7aef\u53e3\u4e3a[" + httpPort + "],\u8fde\u63a5\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\u4e3a" + e.toString()));
            return false;
        }
        log.debug((Object)("\u5efa\u7acbhttp\u8fde\u63a5,IP\u5730\u5740\u4e3a[" + ip + "],http\u7aef\u53e3\u4e3a[" + httpPort + "],\u8fde\u63a5\u6210\u529f..."));
        return true;
    }

    public static String getSuperGroupNodeID(String modeCode) {
        log.info((Object)"--DMInGroupUtil-->getSuperGroupNodeID-->\u636e\u5185\u5bb9\u6a21\u578b\u83b7\u53d6\u751f\u547d\u5468\u671f\u914d\u7f6e\u7684\u4e0a\u7ea7\u670d\u52a1\u5668\u8282\u70b9ID");
        NodeInfo localNode = LazySingleton.getInstance().load.getNodeInfoBean();
        Map map = LazySingleton.getInstance().lifeCycleStrategy.getLifeMap();
        log.debug((Object)("\u83b7\u53d6[" + modeCode + "]\u7684\u8fc1\u79fb\u4efb\u52a1,\u5f53\u524d\u8282\u70b9\u4e3a[" + localNode.getGroup_id() + "]"));
        Set keyset = map.keySet();
        for (String key : keyset) {
            LifeCycleStrategyBean lifeCycle = (LifeCycleStrategyBean)map.get(key);
            if (!localNode.getGroup_id().equals(lifeCycle.getGroup_id()) || !lifeCycle.getModel_code().equals(modeCode) || !"1".equals(lifeCycle.getTask_state()) || !"2".equals(lifeCycle.getTask_no())) continue;
            String params = lifeCycle.getParameters();
            Map<String, Object> paramMap = DMInGroupUtil.getParameters(params);
            log.debug((Object)("\u5167\u5bb9\u6a21\u578b[" + modeCode + "]\u7684\u8fc1\u79fb\u4efb\u52a1,\u53c2\u6570\u914d\u7f6e\u4e3a[" + lifeCycle.getParameters() + "]"));
            String superGroupID = String.valueOf(paramMap.get("SUPER_GROUPID"));
            return superGroupID;
        }
        log.warn((Object)("\u672a\u4eceCONSOLE\u63a5\u6536\u5230\u8be5[" + modeCode + "]\u5185\u5bb9\u6a21\u578b\u7684\u8fc1\u79fb\u4efb\u52a1\u4fe1\u606f,\u6216\u8005\u8fc1\u79fb\u4efb\u52a1\u5df2\u505c\u7528,\u6216\u8005\u672c\u8282\u70b9[" + localNode.getServer_name() + "][" + localNode.getGroup_name() + "]\u5df2\u662f\u8fc1\u79fb\u7684\u6700\u9ad8\u94fe\u8def\u8282\u70b9"));
        return null;
    }

    public static boolean hasLowerGroupNodeID(String modeCode) {
        log.info((Object)"--DMInGroupUtil-->getSuperGroupNodeID-->\u636e\u5185\u5bb9\u6a21\u578b\u83b7\u53d6\u751f\u547d\u5468\u671f\u914d\u7f6e\u7684\u4e0a\u7ea7\u670d\u52a1\u5668\u8282\u70b9ID");
        NodeInfo localNode = LazySingleton.getInstance().load.getNodeInfoBean();
        Map map = LazySingleton.getInstance().lifeCycleStrategy.getLifeMap();
        log.debug((Object)("\u83b7\u53d6[" + modeCode + "]\u7684\u8fc1\u79fb\u4efb\u52a1,\u5f53\u524d\u8282\u70b9\u4e3a[" + localNode.getGroup_id() + "]"));
        Set keyset = map.keySet();
        for (String key : keyset) {
            LifeCycleStrategyBean lifeCycle = (LifeCycleStrategyBean)map.get(key);
            if (!lifeCycle.getModel_code().equals(modeCode) || !"1".equals(lifeCycle.getTask_state()) || !"2".equals(lifeCycle.getTask_no())) continue;
            String params = lifeCycle.getParameters();
            Map<String, Object> paramMap = DMInGroupUtil.getParameters(params);
            String superGroupID = String.valueOf(paramMap.get("SUPER_GROUPID"));
            if (!localNode.getGroup_id().equals(superGroupID)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Object> getParameters(String parameters) {
        if (parameters == null || parameters.length() == 0 || "null".equals(parameters)) {
            return new HashMap<String, Object>();
        }
        String[] paras = parameters.split(";");
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < paras.length) {
            String one = paras[i];
            String[] para = one.split("=");
            if (para.length != 2) {
                log.error((Object)("BAD PARAMETER :[" + one + "]"));
            } else {
                map.put(para[0].trim(), para[1].trim());
            }
            ++i;
        }
        return map;
    }
}

