/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.resources.services.client.jaxrs;

import fr.opensagres.xdocreport.remoting.resources.domain.BinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Filter;
import fr.opensagres.xdocreport.remoting.resources.domain.LargeBinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Resource;
import fr.opensagres.xdocreport.remoting.resources.services.ResourcesException;
import fr.opensagres.xdocreport.remoting.resources.services.ResourcesServiceName;
import fr.opensagres.xdocreport.remoting.resources.services.jaxrs.JAXRSResourcesService;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public class JAXRSResourcesServiceClient
implements JAXRSResourcesService {
    private final WebTarget target;

    public JAXRSResourcesServiceClient(Client client, String baseAddress) {
        this.target = client.target(baseAddress);
    }

    public String getName() {
        this.reset();
        return (String)this.target.path(ResourcesServiceName.name.name()).request().accept(new String[]{"text/plain"}).get(String.class);
    }

    public Resource getRoot() {
        this.reset();
        return (Resource)this.target.path(ResourcesServiceName.root.name()).request().accept(new String[]{"application/json"}).get(Resource.class);
    }

    public Resource getRootWithFilter(Filter filter) {
        this.reset();
        return null;
    }

    public List<BinaryData> downloadMultiple(List<String> resourceIds) {
        this.reset();
        return null;
    }

    public BinaryData download(String resourceId) {
        this.reset();
        return (BinaryData)this.target.path(ResourcesServiceName.download.name()).queryParam("resourceId", new Object[]{resourceId}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(BinaryData.class);
    }

    public void upload(BinaryData data) {
        this.reset();
        this.target.path(ResourcesServiceName.upload.name()).request().accept(new String[]{"text/plain"}).post(Entity.entity((Object)data, (String)"application/json"));
    }

    protected void reset() {
    }

    public LargeBinaryData downloadLarge(String resourceId) throws ResourcesException {
        this.reset();
        return (LargeBinaryData)this.target.path(ResourcesServiceName.downloadLarge.name()).queryParam("resourceId", new Object[]{resourceId}).request().accept(new String[]{"*/*"}).get(LargeBinaryData.class);
    }

    public void uploadLarge(LargeBinaryData data) throws ResourcesException {
        this.reset();
        this.target.path(ResourcesServiceName.uploadLarge.name()).request().accept(new String[]{"text/plain"}).post(Entity.entity((Object)data, (String)"application/json"));
    }
}

