/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.resources.services.client.jaxws;

import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.remoting.resources.domain.BinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Filter;
import fr.opensagres.xdocreport.remoting.resources.domain.Resource;
import fr.opensagres.xdocreport.remoting.resources.services.ResourcesException;
import fr.opensagres.xdocreport.remoting.resources.services.jaxws.JAXWSResourcesService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class JAXWSResourcesServiceClient
implements JAXWSResourcesService {
    private static final Logger LOGGER = LogUtils.getLogger((String)JAXWSResourcesServiceClient.class.getName());
    private final JAXWSResourcesService client;

    public JAXWSResourcesServiceClient(String baseAddress, String user, String password, Long connectionTimeout, Boolean allowChunking) {
        QName serviceName = new QName("http://services.resources.remoting.xdocreport.opensagres.fr/", "ResourcesServiceService");
        QName portName = new QName("http://services.resources.remoting.xdocreport.opensagres.fr/", "ResourcesServicePort");
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", baseAddress);
        this.client = (JAXWSResourcesService)service.getPort(portName, JAXWSResourcesService.class);
        this.initializeClient(user, password, connectionTimeout, allowChunking);
    }

    private void initializeClient(String user, String password, Long connectionTimeout, Boolean allowChunking) {
        boolean hasPolicy;
        Client cxfClient = ClientProxy.getClient((Object)this.client);
        boolean bl = hasPolicy = connectionTimeout != null || allowChunking != null;
        if (StringUtils.isNotEmpty((String)user) || hasPolicy) {
            HTTPConduit http = (HTTPConduit)cxfClient.getConduit();
            if (hasPolicy) {
                HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
                if (connectionTimeout != null) {
                    httpClientPolicy.setConnectionTimeout(connectionTimeout.longValue());
                }
                if (allowChunking != null) {
                    httpClientPolicy.setAllowChunking(allowChunking.booleanValue());
                }
                http.setClient(httpClientPolicy);
            }
            AuthorizationPolicy authorizationPolicy = http.getAuthorization();
            if (StringUtils.isNotEmpty((String)user)) {
                authorizationPolicy.setUserName(user);
            }
            if (StringUtils.isNotEmpty((String)password)) {
                authorizationPolicy.setPassword(password);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            cxfClient.getEndpoint().getInInterceptors().add(new LoggingInInterceptor());
            cxfClient.getEndpoint().getOutInterceptors().add(new LoggingOutInterceptor());
        }
    }

    public String getName() {
        return this.client.getName();
    }

    public Resource getRoot() {
        return this.client.getRoot();
    }

    public Resource getRootWithFilter(Filter filter) throws ResourcesException {
        return this.client.getRootWithFilter(filter);
    }

    public List<BinaryData> downloadMultiple(List<String> resourceIds) throws ResourcesException {
        return this.client.downloadMultiple(resourceIds);
    }

    public BinaryData download(String resourceId) throws ResourcesException {
        return this.client.download(resourceId);
    }

    public void upload(BinaryData data) throws ResourcesException {
        this.client.upload(data);
    }
}

