/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.resources.services.server.file;

import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.remoting.resources.domain.BinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Filter;
import fr.opensagres.xdocreport.remoting.resources.domain.LargeBinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Resource;
import fr.opensagres.xdocreport.remoting.resources.domain.ResourceFactory;
import fr.opensagres.xdocreport.remoting.resources.domain.ResourceType;
import fr.opensagres.xdocreport.remoting.resources.services.AbstractResourcesService;
import fr.opensagres.xdocreport.remoting.resources.services.ResourcesException;
import fr.opensagres.xdocreport.remoting.resources.services.jaxrs.JAXRSResourcesService;
import fr.opensagres.xdocreport.remoting.resources.services.jaxws.JAXWSResourcesService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FileResourcesService
extends AbstractResourcesService
implements JAXRSResourcesService,
JAXWSResourcesService {
    private final File rootFolder;
    private final boolean templateHierarchy;

    public FileResourcesService(File rootFolder) {
        this(rootFolder, false);
    }

    public FileResourcesService(File rootFolder, boolean templateHierarchy) {
        this.rootFolder = rootFolder;
        this.templateHierarchy = templateHierarchy;
    }

    public Resource getRootWithFilter(Filter filter) {
        return this.toResource(this.getRootFolder(), null);
    }

    public BinaryData download(String resourceId) throws ResourcesException {
        String resourcePath = this.getResourcePath(resourceId);
        File file = new File(this.getRootFolder(), resourcePath);
        try {
            FileInputStream input = new FileInputStream(file);
            byte[] content = IOUtils.toByteArray((InputStream)input);
            BinaryData data = new BinaryData();
            data.setContent(content);
            data.setFileName(file.getName());
            data.setResourceId(resourceId);
            return data;
        }
        catch (Exception e) {
            throw new ResourcesException((Throwable)e);
        }
    }

    protected String getResourcePath(String resourceId) {
        return StringUtils.replaceAll((String)resourceId, (String)"____", (String)"/");
    }

    public LargeBinaryData downloadLarge(String resourceId) throws ResourcesException {
        String resourcePath = this.getResourcePath(resourceId);
        File file = new File(this.getRootFolder(), resourcePath);
        try {
            FileInputStream input = new FileInputStream(file);
            LargeBinaryData data = new LargeBinaryData();
            data.setContent((InputStream)input);
            data.setFileName(file.getName());
            data.setResourceId(resourceId);
            return data;
        }
        catch (Exception e) {
            throw new ResourcesException((Throwable)e);
        }
    }

    public void uploadLarge(LargeBinaryData data) throws ResourcesException {
        String resourceId = data.getResourceId();
        InputStream input = data.getContent();
        String resourcePath = this.getResourcePath(resourceId);
        File file = new File(this.getRootFolder(), resourcePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            IOUtils.copyLarge((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            throw new ResourcesException((Throwable)e);
        }
        finally {
            if (input != null) {
                IOUtils.closeQuietly((InputStream)input);
            }
            if (output != null) {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
    }

    public void upload(BinaryData data) throws ResourcesException {
        String resourceId = data.getResourceId();
        byte[] input = data.getContent();
        String resourcePath = this.getResourcePath(resourceId);
        File file = new File(this.getRootFolder(), resourcePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            IOUtils.write((byte[])input, (OutputStream)output);
        }
        catch (IOException e) {
            throw new ResourcesException((Throwable)e);
        }
        finally {
            if (output != null) {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Resource toSimpleResource(File file, Resource parent) {
        File[] files;
        boolean directory = file.isDirectory();
        Resource resource = ResourceFactory.createResource((String)file.getName(), (ResourceType)(directory ? ResourceType.CATEGORY : ResourceType.DOCUMENT), (Resource)parent);
        if (directory && (files = file.listFiles()).length > 0) {
            for (int i = 0; i < files.length; ++i) {
                this.toResource(files[i], resource);
            }
        }
        return resource;
    }

    public Resource toResource(File file, Resource parent) {
        if (this.templateHierarchy && file.isFile()) {
            return ResourceFactory.createTemplate((String)file.getName(), (Resource)parent);
        }
        return this.toSimpleResource(file, parent);
    }
}

