/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.dvcs;

import io.gatling.recorder.internal.bouncycastle.cms.CMSException;
import io.gatling.recorder.internal.bouncycastle.cms.CMSProcessableByteArray;
import io.gatling.recorder.internal.bouncycastle.cms.CMSSignedData;
import io.gatling.recorder.internal.bouncycastle.cms.CMSSignedDataGenerator;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSException;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

