/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.Mono;
import reactor.netty.internal.shaded.reactor.pool.AbstractPool;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquirePendingLimitException;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.SimplePool;
import reactor.util.concurrent.Queues;

final class SimpleFifoPool<POOLABLE>
extends SimplePool<POOLABLE> {
    private static final Queue TERMINATED = (Queue)Queues.empty().get();
    volatile Queue<AbstractPool.Borrower<POOLABLE>> pending = new ConcurrentLinkedQueue<AbstractPool.Borrower<POOLABLE>>();
    private static final AtomicReferenceFieldUpdater<SimpleFifoPool, Queue> PENDING = AtomicReferenceFieldUpdater.newUpdater(SimpleFifoPool.class, Queue.class, "pending");

    public SimpleFifoPool(PoolConfig<POOLABLE> poolConfig) {
        super(poolConfig);
    }

    @Override
    boolean pendingOffer(AbstractPool.Borrower<POOLABLE> pending) {
        int currentPending;
        int maxPending = this.poolConfig.maxPending();
        do {
            currentPending = PENDING_COUNT.get(this);
            if (maxPending < 0 || currentPending != maxPending) continue;
            pending.fail(new PoolAcquirePendingLimitException(maxPending));
            return false;
        } while (!PENDING_COUNT.compareAndSet(this, currentPending, currentPending + 1));
        this.pending.offer(pending);
        return true;
    }

    @Override
    AbstractPool.Borrower<POOLABLE> pendingPoll() {
        Queue<AbstractPool.Borrower<POOLABLE>> q = this.pending;
        AbstractPool.Borrower<POOLABLE> b = q.poll();
        if (b != null) {
            PENDING_COUNT.decrementAndGet(this);
        }
        return b;
    }

    @Override
    void cancelAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        Queue<AbstractPool.Borrower<POOLABLE>> q;
        if (!this.isDisposed() && (q = this.pending).remove(borrower)) {
            PENDING_COUNT.decrementAndGet(this);
        }
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            Queue q = PENDING.getAndSet(this, TERMINATED);
            if (q != TERMINATED) {
                while (!q.isEmpty()) {
                    ((AbstractPool.Borrower)q.poll()).fail(new PoolShutdownException());
                }
                Queue e = ELEMENTS.getAndSet(this, null);
                if (e != null) {
                    Mono destroyMonos = Mono.empty();
                    while (!e.isEmpty()) {
                        SimplePool.QueuePooledRef ref = (SimplePool.QueuePooledRef)e.poll();
                        if (!ref.markInvalidate()) continue;
                        destroyMonos = destroyMonos.and(this.destroyPoolable(ref));
                    }
                    return destroyMonos;
                }
            }
            return Mono.empty();
        });
    }

    public boolean isDisposed() {
        return PENDING.get(this) == TERMINATED;
    }
}

