/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamBlock;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLOnCompletion;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;

public class XSLIterate
extends StyleElement {
    Expression select = null;
    boolean compilable;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam || child instanceof XSLOnCompletion;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean mayContainParam() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        }
    }

    public void setCompilable(boolean compilable) {
        this.compilable = compilable;
    }

    public boolean isCompilable() {
        return this.compilable;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:iterate instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        NodeInfo node;
        AxisIterator children = this.iterateAxis((byte)3);
        ArrayList<NodeInfo> nonFinallyChildren = new ArrayList<NodeInfo>();
        Expression finallyExp = null;
        ArrayList<XSLLocalParam> params = new ArrayList<XSLLocalParam>();
        while ((node = (NodeInfo)children.next()) != null) {
            if (node instanceof XSLLocalParam) {
                params.add((XSLLocalParam)node);
                continue;
            }
            if (node instanceof XSLOnCompletion) {
                finallyExp = ((XSLOnCompletion)node).compile(exec, decl);
                continue;
            }
            nonFinallyChildren.add(node);
        }
        LocalParam[] compiledParams = new LocalParam[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            compiledParams[i] = (LocalParam)((XSLLocalParam)params.get(i)).compile(exec, decl);
            if (!compiledParams[i].isImplicitlyRequiredParam()) continue;
            this.compileError("The parameter must be given an initial value because () is not valid, given the declared type", "XTSE3520");
        }
        LocalParamBlock paramBlock = new LocalParamBlock(compiledParams);
        Expression action = this.compileSequenceConstructor(exec, decl, new ListIterator(nonFinallyChildren), false);
        if (action == null) {
            return Literal.makeEmptySequence();
        }
        try {
            action = action.simplify();
            return new IterateInstr(this.select, paramBlock, action, finallyExp);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

