/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-jxr-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven JXR Plugin", 0);
        this.append(sb, "Maven is a software project management and comprehension tool. Based on the concept of a project object model (POM), Maven can manage a project's build, reporting and documentation from a central piece of information.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jxr:help", 0);
            this.append(sb, "Display help information on maven-jxr-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jxr:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jxr".equals(this.goal)) {
            this.append(sb, "jxr:jxr", 0);
            this.append(sb, "Creates an html-based, cross referenced version of Java source code for a project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {projectOrganizationName}. All Rights Reserved.)", 2);
                this.append(sb, "String uses at the bottom of the Xref HTML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "Folder where the Xref files will be copied to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "docTitle", 2);
                this.append(sb, "Title of main page of the Xref HTML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclude patterns to use. By default no files are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of include patterns to use. By default all .java files are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "File input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javadocDir", 2);
                this.append(sb, "Folder where Javadoc is generated for this project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkJavadoc (Default: true)", 2);
                this.append(sb, "Link the Javadoc from the Source XRef. Defaults to true and will link automatically if javadoc plugin is being used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Output folder where the main page of the report will be generated. Note that this parameter is only relevant if the goal is run directly from the command line or from the default lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin will be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "File output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcePath", 2);
                this.append(sb, "Specifies the source path where the java files are located. The paths are separated by ';'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stylesheet (Default: stylesheet.css)", 2);
                this.append(sb, "Style sheet used for the Xref HTML files. Should not be used. If used, should be an absolute path, like '${basedir}/myStyles.css'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDir (Default: templates)", 2);
                this.append(sb, "Directory where Velocity templates can be found to generate overviews, frames and summaries. Should not be used. If used, should be an absolute path, like '${basedir}/myTemplates'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "windowTitle", 2);
                this.append(sb, "Title of window of the Xref HTML files.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-jxr".equals(this.goal)) {
            this.append(sb, "jxr:test-jxr", 0);
            this.append(sb, "Creates an html-based, cross referenced version of Java source code for a project's test sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {projectOrganizationName}. All Rights Reserved.)", 2);
                this.append(sb, "String uses at the bottom of the Xref HTML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir", 2);
                this.append(sb, "Folder where the Xref files will be copied to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "docTitle", 2);
                this.append(sb, "Title of main page of the Xref HTML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclude patterns to use. By default no files are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of include patterns to use. By default all .java files are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "File input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkJavadoc (Default: true)", 2);
                this.append(sb, "Link the Javadoc from the Source XRef. Defaults to true and will link automatically if javadoc plugin is being used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Output folder where the main page of the report will be generated. Note that this parameter is only relevant if the goal is run directly from the command line or from the default lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin will be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "File output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stylesheet (Default: stylesheet.css)", 2);
                this.append(sb, "Style sheet used for the Xref HTML files. Should not be used. If used, should be an absolute path, like '${basedir}/myStyles.css'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDir (Default: templates)", 2);
                this.append(sb, "Directory where Velocity templates can be found to generate overviews, frames and summaries. Should not be used. If used, should be an absolute path, like '${basedir}/myTemplates'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testJavadocDir", 2);
                this.append(sb, "Folder where Test Javadoc is generated for this project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "windowTitle", 2);
                this.append(sb, "Title of window of the Xref HTML files.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

