/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree.traversal;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public class SerializingDependencyNodeVisitor
implements DependencyNodeVisitor {
    public static final TreeTokens WHITESPACE_TOKENS = new TreeTokens("   ", "   ", "   ", "   ");
    public static final TreeTokens STANDARD_TOKENS = new TreeTokens("+- ", "\\- ", "|  ", "   ");
    public static final TreeTokens EXTENDED_TOKENS = new TreeTokens("\u00c3\u00c4 ", "\u00c0\u00c4 ", "\u00b3  ", "   ");
    private final PrintWriter writer;
    private final TreeTokens tokens;
    private int depth;

    public SerializingDependencyNodeVisitor(Writer writer) {
        this(writer, WHITESPACE_TOKENS);
    }

    public SerializingDependencyNodeVisitor(Writer writer, TreeTokens tokens) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
        this.tokens = tokens;
        this.depth = 0;
    }

    public boolean visit(DependencyNode node) {
        this.indent(node);
        this.writer.println(node.toNodeString());
        ++this.depth;
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        --this.depth;
        return true;
    }

    private void indent(DependencyNode node) {
        for (int i = 1; i < this.depth; ++i) {
            this.writer.write(this.tokens.getFillIndent(this.isLast(node, i)));
        }
        if (this.depth > 0) {
            this.writer.write(this.tokens.getNodeIndent(this.isLast(node)));
        }
    }

    private boolean isLast(DependencyNode node) {
        List<DependencyNode> siblings;
        DependencyNode parent = node.getParent();
        boolean last = parent == null ? true : (siblings = parent.getChildren()).indexOf(node) == siblings.size() - 1;
        return last;
    }

    private boolean isLast(DependencyNode node, int ancestorDepth) {
        int distance = this.depth - ancestorDepth;
        while (distance-- > 0) {
            node = node.getParent();
        }
        return this.isLast(node);
    }

    public static class TreeTokens {
        private final String nodeIndent;
        private final String lastNodeIndent;
        private final String fillIndent;
        private final String lastFillIndent;

        public TreeTokens(String nodeIndent, String lastNodeIndent, String fillIndent, String lastFillIndent) {
            this.nodeIndent = nodeIndent;
            this.lastNodeIndent = lastNodeIndent;
            this.fillIndent = fillIndent;
            this.lastFillIndent = lastFillIndent;
        }

        public String getNodeIndent(boolean last) {
            return last ? this.lastNodeIndent : this.nodeIndent;
        }

        public String getFillIndent(boolean last) {
            return last ? this.lastFillIndent : this.fillIndent;
        }
    }
}

