/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sshd.cli.CliLogger;
import org.apache.sshd.cli.client.CliClientModuleProperties;
import org.apache.sshd.cli.client.SshClientCliSupport;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.PtyChannelConfiguration;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseOutputStream;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.slf4j.Logger;

public class SshClientMain
extends SshClientCliSupport {
    protected SshClientMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block91: {
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            boolean agentForward = false;
            ArrayList<String> command = null;
            int socksPort = -1;
            int numArgs = GenericUtils.length((Object[])args);
            boolean error = false;
            String target = null;
            Level level = Level.WARNING;
            OutputStream logStream = stderr;
            for (int i = 0; i < numArgs; ++i) {
                String argName = args[i];
                if (GenericUtils.isEmpty(command) && SshClientMain.isArgumentedOption("-p", argName)) {
                    if (i + 1 >= numArgs) {
                        error = CliLogger.showError(stderr, "option requires an argument: " + argName);
                        break;
                    }
                    ++i;
                    continue;
                }
                if (GenericUtils.isEmpty(command) && ("-v".equals(argName) || "-vv".equals(argName) || "-vvv".equals(argName))) continue;
                if (GenericUtils.isEmpty(command) && "-D".equals(argName)) {
                    if (i + 1 >= numArgs) {
                        error = CliLogger.showError(stderr, "option requires an argument: " + argName);
                        break;
                    }
                    if (socksPort > 0) {
                        error = CliLogger.showError(stderr, argName + " option value re-specified: " + socksPort);
                        break;
                    }
                    if ((socksPort = Integer.parseInt(args[++i])) > 0) continue;
                    error = CliLogger.showError(stderr, "Bad option value for " + argName + ": " + socksPort);
                    break;
                }
                if (GenericUtils.isEmpty(command) && "-A".equals(argName)) {
                    agentForward = true;
                    continue;
                }
                if (GenericUtils.isEmpty(command) && "-a".equals(argName)) {
                    agentForward = false;
                    continue;
                }
                level = CliLogger.resolveLoggingVerbosity(args, i);
                logStream = SshClientMain.resolveLoggingTargetStream(stdout, stderr, args, i);
                if (logStream == null) {
                    error = true;
                    break;
                }
                if (GenericUtils.isEmpty(command) && target == null) {
                    target = argName;
                    continue;
                }
                if (command == null) {
                    command = new ArrayList<String>();
                }
                command.add(argName);
            }
            ClientSession session = null;
            try (BufferedReader stdin = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(System.in), Charset.defaultCharset()));){
                if (!error) {
                    SshClientMain.setupLogging(level, stdout, stderr, logStream);
                    session = SshClientMain.setupClientSession("-p", stdin, level, stdout, stderr, args);
                    if (session == null) {
                        error = true;
                    }
                }
                if (error) {
                    System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-E logoutputfile] [-D socksPort] [-J proxyJump] [-l login] [-p port] [-o option=value] [-w password] [-c cipherslist] [-m maclist] [-C] hostname/user@host [command]");
                    System.exit(-1);
                    return;
                }
                Logger logger = CliLogger.resolveSystemLogger(SshClientMain.class, level);
                boolean verbose = logger.isInfoEnabled();
                try (SshClient client = (SshClient)session.getFactoryManager();){
                    try {
                        String cmdValue;
                        ChannelShell channel;
                        if (socksPort >= 0) {
                            if (verbose) {
                                logger.info("Start dynamic port forwarding to {}:{}", (Object)"localhost", (Object)socksPort);
                            }
                            session.startDynamicPortForwarding(new SshdSocketAddress("localhost", socksPort));
                            Thread.sleep(Long.MAX_VALUE);
                            break block91;
                        }
                        Map<String, ?> env = SshClientMain.resolveClientEnvironment((PropertyResolver)client);
                        PtyChannelConfiguration ptyConfig = SshClientMain.resolveClientPtyOptions((PropertyResolver)client);
                        if (GenericUtils.isEmpty(command)) {
                            channel = session.createShellChannel((PtyChannelConfigurationHolder)ptyConfig, env);
                            channel.setAgentForwarding(agentForward);
                            channel.setIn((InputStream)new NoCloseInputStream(System.in));
                            cmdValue = "shell";
                        } else {
                            cmdValue = String.join((CharSequence)" ", command).trim();
                            channel = session.createExecChannel(cmdValue, (PtyChannelConfigurationHolder)ptyConfig, env);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("PTY={} for command={}", (Object)ptyConfig, (Object)cmdValue);
                            logger.debug("ENV={} for command={}", env, (Object)cmdValue);
                        }
                        try (NoCloseOutputStream channelOut = new NoCloseOutputStream((OutputStream)System.out);
                             NoCloseOutputStream channelErr = new NoCloseOutputStream((OutputStream)System.err);){
                            channel.setOut((OutputStream)channelOut);
                            channel.setErr((OutputStream)channelErr);
                            Duration maxWait = (Duration)CliClientModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired((PropertyResolver)channel);
                            if (verbose) {
                                logger.info("Wait {} for open channel for command={}", (Object)maxWait, (Object)cmdValue);
                            }
                            channel.open().verify(maxWait);
                            if (verbose) {
                                logger.info("Channel opened for command={}", (Object)cmdValue);
                            }
                            Set result = channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                            if (verbose) {
                                logger.info("command={} - waitFor result={}", (Object)cmdValue, (Object)result);
                                if (result.contains(ClientChannelEvent.EXIT_SIGNAL)) {
                                    logger.info("    {}={}", (Object)ClientChannelEvent.EXIT_SIGNAL, (Object)channel.getExitSignal());
                                }
                                if (result.contains(ClientChannelEvent.EXIT_STATUS)) {
                                    logger.info("    {}={}", (Object)ClientChannelEvent.EXIT_STATUS, (Object)channel.getExitStatus());
                                }
                            }
                        }
                        finally {
                            channel.close();
                        }
                        session.close(false);
                    }
                    finally {
                        client.stop();
                    }
                }
                finally {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            finally {
                if (logStream != null && logStream != stdout && logStream != stderr) {
                    logStream.close();
                }
            }
        }
    }
}

