/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ToStringSorter<T> {
    private final Function<T, String> toString;

    public ToStringSorter(Function<T, String> toString) {
        this.toString = toString;
    }

    public List<Pair<T>> sort(Collection<T> unSorted) {
        int size = unSorted.size();
        ArrayList<Pair<T>> sortedObjects = new ArrayList<Pair<T>>(size);
        unSorted.forEach(k -> {
            boolean bl = sortedObjects.add(new Pair<Object>(k, this.toString.apply(k)));
        });
        Collections.sort(sortedObjects);
        return sortedObjects;
    }

    static class Pair<T>
    implements Comparable<Pair<T>> {
        final T object;
        final String string;

        public Pair(T k, String s) {
            this.object = k;
            this.string = s;
        }

        @Override
        public int compareTo(Pair<T> other) {
            return this.string.compareTo(other.string);
        }
    }
}

