/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.temporal.Temporal;
import java.util.Comparator;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.error.ShouldBeCloseTo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractTemporalAssert<SELF extends AbstractTemporalAssert<SELF, TEMPORAL>, TEMPORAL extends Temporal>
extends AbstractAssert<SELF, TEMPORAL> {
    @VisibleForTesting
    Comparables comparables = new Comparables();

    protected AbstractTemporalAssert(TEMPORAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isCloseTo(TEMPORAL other, TemporalOffset<? super TEMPORAL> offset) {
        Objects.instance().assertNotNull(this.info, this.actual);
        java.util.Objects.requireNonNull(other, "The temporal object to compare actual with should not be null");
        java.util.Objects.requireNonNull(offset, "The offset should not be null");
        if (offset.isBeyondOffset((Temporal)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeCloseTo.shouldBeCloseTo((Temporal)this.actual, other, offset.getBeyondOffsetDifferenceDescription((Temporal)this.actual, other)));
        }
        return (SELF)((AbstractTemporalAssert)this.myself);
    }

    public SELF isCloseTo(String otherAsString, TemporalOffset<? super TEMPORAL> offset) {
        java.util.Objects.requireNonNull(otherAsString, "The String representing of the temporal object to compare actual with should not be null");
        return this.isCloseTo(this.parse(otherAsString), offset);
    }

    protected abstract TEMPORAL parse(String var1);

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super TEMPORAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super TEMPORAL> customComparator, String customComparatorDescription) {
        this.comparables = new Comparables(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractTemporalAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.comparables = new Comparables();
        return (SELF)((AbstractTemporalAssert)super.usingDefaultComparator());
    }
}

