/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.PriorityQueue;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.Behavior;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.PointInTimeTrigger;

public class SlidingTimeWindow
implements Externalizable,
Behavior {
    protected long size;
    private static final BehaviorJob job = new BehaviorJob();
    protected int nodeId;

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
        this.nodeId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
        out.writeInt(this.nodeId);
    }

    @Override
    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public void setWindowNode(WindowNode windowNode) {
        this.nodeId = windowNode.getId();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public Behavior.Context createContext() {
        return new SlidingTimeWindowContext();
    }

    @Override
    public boolean assertFact(Object context, InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        long currentTime = workingMemory.getTimerService().getCurrentTime();
        if (this.isExpired(currentTime, handle)) {
            return false;
        }
        queue.add(handle);
        if (queue.peek() == handle) {
            this.updateNextExpiration(handle, workingMemory, queue, this.nodeId);
        }
        return true;
    }

    @Override
    public void retractFact(Object context, InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        if (queue.getExpiringHandle() != handle) {
            if (queue.peek() == handle) {
                queue.poll();
                this.updateNextExpiration(queue.peek(), workingMemory, queue, this.nodeId);
            } else {
                queue.remove(handle);
            }
        }
    }

    @Override
    public void expireFacts(Object context, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = queue.peek();
        while (handle != null && this.isExpired(currentTime, handle)) {
            queue.setExpiringHandle(handle);
            queue.remove();
            if (handle.isValid()) {
                PropagationContext expiresPctx = PhreakPropagationContextFactory.createPropagationContextForFact(workingMemory, handle, PropagationContext.Type.EXPIRATION);
                ObjectTypeNode.doRetractObject(handle, expiresPctx, workingMemory);
            }
            queue.setExpiringHandle(null);
            handle = queue.peek();
        }
        this.updateNextExpiration(handle, workingMemory, queue, this.nodeId);
    }

    protected boolean isExpired(long currentTime, EventFactHandle handle) {
        return handle.getStartTimestamp() + this.size <= currentTime;
    }

    protected void updateNextExpiration(InternalFactHandle fact, InternalWorkingMemory workingMemory, Behavior.Context context, int nodeId) {
        TimerService clock = workingMemory.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((EventFactHandle)fact).getStartTimestamp() + this.getSize();
            if (nextTimestamp < clock.getCurrentTime()) {
                workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(nodeId, this, context));
            } else {
                BehaviorJobContext jobctx = new BehaviorJobContext(nodeId, workingMemory, this, context);
                JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
                jobctx.setJobHandle(handle);
            }
        }
    }

    @Override
    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    public static class BehaviorExpireWMAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private final Behavior behavior;
        private final Behavior.Context context;
        private final int nodeId;

        public BehaviorExpireWMAction(int nodeId, Behavior behavior, Behavior.Context context) {
            this.nodeId = nodeId;
            this.behavior = behavior;
            this.context = context;
        }

        public BehaviorExpireWMAction(MarshallerReaderContext inCtx) throws IOException {
            this.nodeId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(this.nodeId);
            WindowNode.WindowMemory memory = inCtx.wm.getNodeMemory(windowNode);
            Behavior.Context[] behaviorContext = memory.behaviorContext;
            int i = inCtx.readInt();
            this.behavior = windowNode.getBehaviors()[i];
            this.context = behaviorContext[i];
        }

        public BehaviorExpireWMAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.nodeId = _action.getBehaviorExpire().getNodeId();
            WindowNode windowNode = (WindowNode)context.sinks.get(this.nodeId);
            WindowNode.WindowMemory memory = context.wm.getNodeMemory(windowNode);
            Behavior.Context[] behaviorContext = memory.behaviorContext;
            int i = 0;
            this.behavior = windowNode.getBehaviors()[i];
            this.context = behaviorContext[i];
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.behavior.expireFacts(this.context, null, workingMemory);
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext outputCtx) {
            ProtobufMessages.ActionQueue.BehaviorExpire _be = ProtobufMessages.ActionQueue.BehaviorExpire.newBuilder().setNodeId(this.nodeId).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.BEHAVIOR_EXPIRE).setBehaviorExpire(_be).build();
        }
    }

    public static class BehaviorJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(context.nodeId, context.behavior, context.behaviorContext));
        }
    }

    public static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public InternalWorkingMemory workingMemory;
        public int nodeId;
        public Behavior behavior;
        public Behavior.Context behaviorContext;
        public JobHandle handle;

        public BehaviorJobContext(int nodeId, InternalWorkingMemory workingMemory, Behavior behavior, Behavior.Context behaviorContext) {
            this.nodeId = nodeId;
            this.workingMemory = workingMemory;
            this.behavior = behavior;
            this.behaviorContext = behaviorContext;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }
    }

    public static class BehaviorJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            int sinkId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(sinkId);
            WindowNode.WindowMemory memory = inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = memory.behaviorContext;
            int i = inCtx.readInt();
        }

        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            int i = _timer.getBehavior().getHandleId();
        }
    }

    public static class BehaviorJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(51);
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.peek();
            outputCtx.writeInt(handle.getId());
        }

        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.peek();
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.BEHAVIOR).setBehavior(ProtobufMessages.Timers.BehaviorTimer.newBuilder().setHandleId(handle.getId()).build()).build();
        }
    }

    public static class SlidingTimeWindowContext
    implements Behavior.Context,
    Externalizable {
        private PriorityQueue<EventFactHandle> queue = new PriorityQueue(16);
        private EventFactHandle expiringHandle;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
            this.expiringHandle = (EventFactHandle)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.expiringHandle);
        }

        public EventFactHandle getExpiringHandle() {
            return this.expiringHandle;
        }

        public void setExpiringHandle(EventFactHandle expiringHandle) {
            this.expiringHandle = expiringHandle;
        }

        public void setExpiringTuple(EventFactHandle expiringHandle) {
            this.expiringHandle = expiringHandle;
        }

        public void add(EventFactHandle handle) {
            this.queue.add(handle);
        }

        public void remove(EventFactHandle handle) {
            this.queue.remove(handle);
        }

        public EventFactHandle peek() {
            return this.queue.peek();
        }

        public EventFactHandle poll() {
            return this.queue.poll();
        }

        public EventFactHandle remove() {
            return (EventFactHandle)this.queue.remove();
        }

        @Override
        public Collection<EventFactHandle> getFactHandles() {
            return this.queue;
        }
    }
}

