/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineSegmentData;
import mockit.external.asm.Label;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LineCoverageData
extends LineSegmentData {
    private static final long serialVersionUID = -6233980722802474992L;
    @NotNull
    private List<BranchCoverageData> branches = Collections.emptyList();
    private transient int segments;

    LineCoverageData() {
    }

    public int addBranchingPoint(@NotNull Label jumpSource, @NotNull Label jumpTarget) {
        int initialIndex = this.branches.size();
        if (initialIndex == 0) {
            this.branches = new ArrayList<BranchCoverageData>(4);
        }
        this.branches.add(new BranchCoverageData(jumpSource));
        this.branches.add(new BranchCoverageData(jumpTarget));
        return initialIndex;
    }

    public boolean noBranchesYet() {
        return this.branches == Collections.emptyList();
    }

    @NotNull
    public BranchCoverageData getBranchData(int index) {
        return this.branches.get(index);
    }

    boolean acceptsAdditionalCallPoints(int branchIndex) {
        BranchCoverageData data = this.branches.get(branchIndex);
        return data.acceptsAdditionalCallPoints();
    }

    void registerExecution(int branchIndex, @Nullable CallPoint callPoint) {
        BranchCoverageData data = this.branches.get(branchIndex);
        data.registerExecution(callPoint);
    }

    public boolean containsBranches() {
        return !this.noBranchesYet();
    }

    @NotNull
    public List<BranchCoverageData> getBranches() {
        return this.branches;
    }

    public int getNumberOfSegments() {
        int previouslyCounted = this.segments;
        if (previouslyCounted > 0) {
            return previouslyCounted;
        }
        int n = this.branches.size();
        if (n == 0) {
            return 1;
        }
        BranchCoverageData branch = this.branches.get(0);
        int sourceLine = branch.getLine();
        int count = 1;
        for (int i = 1; i < n; i += 2) {
            branch = this.branches.get(i);
            int targetLine = branch.getLine();
            if (targetLine == sourceLine) {
                ++count;
            }
            ++count;
        }
        this.segments = count;
        return count;
    }

    public int getNumberOfCoveredSegments() {
        int segmentsCovered = this.executionCount > 0 ? 1 : 0;
        int n = this.branches.size();
        if (n == 0) {
            return segmentsCovered;
        }
        for (int i = 0; i < n; i += 2) {
            int targetLine;
            BranchCoverageData sourceBranch = this.branches.get(i);
            BranchCoverageData targetBranch = this.branches.get(i + 1);
            if (sourceBranch.isCovered()) {
                ++segmentsCovered;
            }
            if (!targetBranch.isCovered() || (targetLine = targetBranch.getLine()) != sourceBranch.getLine()) continue;
            ++segmentsCovered;
        }
        return segmentsCovered;
    }

    void addCountsFromPreviousTestRun(@NotNull LineCoverageData previousData) {
        this.addExecutionCountAndCallPointsFromPreviousTestRun(previousData);
        if (this.containsBranches()) {
            int n = this.branches.size();
            for (int i = 0; i < n; ++i) {
                BranchCoverageData segmentData = this.branches.get(i);
                BranchCoverageData previousSegmentData = previousData.branches.get(i);
                segmentData.addExecutionCountAndCallPointsFromPreviousTestRun(previousSegmentData);
            }
        }
    }

    @Override
    void reset() {
        super.reset();
        for (BranchCoverageData branchData : this.branches) {
            branchData.reset();
        }
    }
}

