/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mockit.coverage.Configuration;
import mockit.coverage.standalone.Startup;
import mockit.internal.util.ClassLoad;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassSelection {
    private static final String THIS_CLASS_NAME = ClassSelection.class.getName();
    private static final Pattern CSV = Pattern.compile(",");
    final boolean loadedOnly;
    @Nullable
    private final Matcher classesToInclude;
    @Nullable
    private final Matcher classesToExclude;
    @Nullable
    private final Matcher testCode;

    ClassSelection() {
        String classes = Configuration.getProperty("classes", "");
        this.loadedOnly = "loaded".equals(classes);
        this.classesToInclude = this.loadedOnly ? null : ClassSelection.newMatcherForClassSelection(classes);
        String excludes = Configuration.getProperty("excludes", "");
        this.classesToExclude = ClassSelection.newMatcherForClassSelection(excludes);
        this.testCode = Startup.isTestRun() ? Pattern.compile(".+Test(\\$.+)?").matcher("") : null;
    }

    @Nullable
    private static Matcher newMatcherForClassSelection(@NotNull String specification) {
        if (specification.isEmpty()) {
            return null;
        }
        String[] specs = CSV.split(specification);
        StringBuilder finalRegexBuilder = new StringBuilder();
        String sep = "";
        for (String spec : specs) {
            String regex = null;
            if (spec.indexOf(92) >= 0) {
                regex = spec;
            } else if (!spec.isEmpty()) {
                regex = spec.replace(".", "\\.").replace("*", ".*").replace('?', '.');
            }
            if (regex == null) continue;
            finalRegexBuilder.append(sep).append(regex);
            sep = "|";
        }
        String finalRegex = finalRegexBuilder.toString();
        return finalRegex.isEmpty() ? null : Pattern.compile(finalRegex).matcher("");
    }

    boolean isSelected(@NotNull String className, @NotNull ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || className.charAt(0) == '[' || className.startsWith("mockit.") || className.startsWith("org.junit.") || className.startsWith("junit.") || className.startsWith("org.testng.") || ClassLoad.isGeneratedSubclass(className)) {
            return false;
        }
        if (!this.canAccessJMockitFromClassToBeMeasured(protectionDomain.getClassLoader())) {
            return false;
        }
        if (this.classesToExclude != null && this.classesToExclude.reset(className).matches()) {
            return false;
        }
        if (this.testCode != null && this.testCode.reset(className).matches()) {
            return false;
        }
        if (this.classesToInclude != null) {
            return this.classesToInclude.reset(className).matches();
        }
        URL codeSourceLocation = codeSource.getLocation();
        boolean selected = codeSourceLocation != null && !this.isClassFromExternalLibrary(codeSourceLocation.getPath());
        return selected;
    }

    private boolean canAccessJMockitFromClassToBeMeasured(@NotNull ClassLoader loaderOfClassToBeMeasured) {
        try {
            Class<?> thisClass = loaderOfClassToBeMeasured.loadClass(THIS_CLASS_NAME);
            return thisClass == this.getClass();
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    private boolean isClassFromExternalLibrary(@NotNull String location) {
        return location.endsWith(".jar") || location.endsWith("/.cp/") || this.testCode != null && (location.endsWith("/test-classes/") || location.endsWith("/jmockit1.org/main/classes/"));
    }
}

