/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.io.PrintWriter;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.reporting.lineCoverage.LineCoverageFormatter;
import mockit.coverage.reporting.parsing.LineParser;
import org.jetbrains.annotations.NotNull;

public final class LineCoverageOutput {
    @NotNull
    private final PrintWriter output;
    @NotNull
    private final PerFileLineCoverage lineCoverageData;
    @NotNull
    private final LineCoverageFormatter lineCoverageFormatter;

    public LineCoverageOutput(@NotNull PrintWriter output, @NotNull PerFileLineCoverage lineCoverageData, boolean withCallPoints) {
        this.output = output;
        this.lineCoverageData = lineCoverageData;
        this.lineCoverageFormatter = new LineCoverageFormatter(withCallPoints);
    }

    public boolean writeLineWithCoverageInfo(@NotNull LineParser lineParser) {
        int line = lineParser.getNumber();
        if (!this.lineCoverageData.hasLineData(line)) {
            return false;
        }
        int lineExecutionCount = this.lineCoverageData.getExecutionCount(line);
        if (lineExecutionCount < 0) {
            return false;
        }
        this.writeLineExecutionCount(lineExecutionCount);
        this.writeExecutableCode(lineParser);
        return true;
    }

    private void writeLineExecutionCount(int lineExecutionCount) {
        this.output.write("<td class='count'>");
        this.output.print(lineExecutionCount);
        this.output.println("</td>");
    }

    private void writeExecutableCode(@NotNull LineParser lineParser) {
        String formattedLine = this.lineCoverageFormatter.format(lineParser, this.lineCoverageData);
        this.output.write("      <td>");
        this.output.write(formattedLine);
        this.output.println("</td>");
    }
}

