/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.mockups.MockStates;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.MockClasses;
import mockit.internal.state.MockFixture;
import mockit.internal.util.StackTrace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestRun {
    private static final TestRun INSTANCE = new TestRun();
    private static final ThreadLocal<Integer> noMockingCount = new /* Unavailable Anonymous Inner Class!! */;
    private int testId;
    @Nullable
    private Class<?> currentTestClass;
    @Nullable
    private Object currentTestInstance;
    @Nullable
    private FieldTypeRedefinitions fieldTypeRedefinitions;
    @NotNull
    private final MockFixture mockFixture = new MockFixture();
    @NotNull
    private final ExecutingTest executingTest = new ExecutingTest();
    @NotNull
    private final MockClasses mockClasses = new MockClasses();

    private TestRun() {
    }

    public static boolean isInsideNoMockingZone() {
        return noMockingCount.get() > 0;
    }

    @Nullable
    public static Class<?> getCurrentTestClass() {
        return TestRun.INSTANCE.currentTestClass;
    }

    @Nullable
    public static Object getCurrentTestInstance() {
        return TestRun.INSTANCE.currentTestInstance;
    }

    public static int getTestId() {
        return TestRun.INSTANCE.testId;
    }

    @Nullable
    public static FieldTypeRedefinitions getFieldTypeRedefinitions() {
        return TestRun.INSTANCE.fieldTypeRedefinitions;
    }

    @NotNull
    public static MockFixture mockFixture() {
        return TestRun.INSTANCE.mockFixture;
    }

    @NotNull
    public static ExecutingTest getExecutingTest() {
        return TestRun.INSTANCE.executingTest;
    }

    @Nullable
    public static RecordAndReplayExecution getRecordAndReplayForRunningTest() {
        return TestRun.INSTANCE.executingTest.getCurrentRecordAndReplay();
    }

    @NotNull
    public static RecordAndReplayExecution getOrCreateRecordAndReplayForRunningTest() {
        return TestRun.INSTANCE.executingTest.getOrCreateRecordAndReplay();
    }

    @NotNull
    public static RecordAndReplayExecution getRecordAndReplayForVerifications() {
        if (TestRun.INSTANCE.fieldTypeRedefinitions == null) {
            IllegalStateException failure = new IllegalStateException("Invalid place to verify expectations");
            StackTrace.filterStackTrace(failure);
            throw failure;
        }
        return TestRun.INSTANCE.executingTest.getRecordAndReplayForVerifications();
    }

    @NotNull
    public static MockClasses getMockClasses() {
        return TestRun.INSTANCE.mockClasses;
    }

    @NotNull
    public static MockStates getMockStates() {
        return TestRun.INSTANCE.mockClasses.mockStates;
    }

    public static void setCurrentTestClass(@Nullable Class<?> testClass) {
        TestRun.INSTANCE.currentTestClass = testClass;
    }

    public static void prepareForNextTest() {
        ++TestRun.INSTANCE.testId;
        TestRun.INSTANCE.executingTest.setRecordAndReplay(null);
    }

    public static void enterNoMockingZone() {
        noMockingCount.set(1);
    }

    public static void exitNoMockingZone() {
        noMockingCount.set(-1);
    }

    public static void setRunningIndividualTest(@Nullable Object testInstance) {
        TestRun.INSTANCE.currentTestInstance = testInstance;
    }

    public static void setFieldTypeRedefinitions(@Nullable FieldTypeRedefinitions redefinitions) {
        TestRun.INSTANCE.fieldTypeRedefinitions = redefinitions;
    }

    public static void finishCurrentTestExecution() {
        TestRun.INSTANCE.executingTest.finishExecution();
    }

    public static boolean updateMockState(@NotNull String mockUpClassDesc, @Nullable Object mockedInstance, int mockStateIndex) {
        Object mockUp = TestRun.getMock(mockUpClassDesc, mockedInstance);
        if (mockUp == null) {
            return false;
        }
        if (mockStateIndex < 0) {
            return true;
        }
        return TestRun.getMockStates().updateMockState(mockUp, mockStateIndex);
    }

    @Nullable
    public static Object getMock(@NotNull String mockUpClassDesc, @Nullable Object mockedInstance) {
        return TestRun.INSTANCE.mockClasses.getMock(mockUpClassDesc, mockedInstance);
    }
}

