/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.beans.factory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.springframework.aot.beans.factory.InjectedElementAttributes;
import org.springframework.aot.beans.factory.InjectedElementResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.MethodParameter;

class InjectedMethodResolver
implements InjectedElementResolver {
    private final Method method;
    private final Class<?> target;
    private final String beanName;

    InjectedMethodResolver(Method method, Class<?> target, String beanName) {
        this.method = method;
        this.target = target;
        this.beanName = beanName;
    }

    @Override
    public InjectedElementAttributes resolve(DefaultListableBeanFactory beanFactory, boolean required) {
        int argumentCount = this.method.getParameterCount();
        ArrayList<Object> arguments = new ArrayList<Object>();
        LinkedHashSet autowiredBeans = new LinkedHashSet(argumentCount);
        TypeConverter typeConverter = beanFactory.getTypeConverter();
        for (int i = 0; i < argumentCount; ++i) {
            MethodParameter methodParam = new MethodParameter(this.method, i);
            DependencyDescriptor depDescriptor = new DependencyDescriptor(methodParam, required);
            depDescriptor.setContainingClass(this.target);
            try {
                Object arg = beanFactory.resolveDependency(depDescriptor, this.beanName, autowiredBeans, typeConverter);
                if (arg == null && !required) {
                    arguments = null;
                    break;
                }
                arguments.add(arg);
                continue;
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(null, this.beanName, new InjectionPoint(methodParam), ex);
            }
        }
        return new InjectedElementAttributes(arguments);
    }
}

