/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.context.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class InitDestroyBeanPostProcessor
implements BeanPostProcessor,
DestructionAwareBeanPostProcessor,
Ordered {
    private static final Log logger = LogFactory.getLog(InitDestroyBeanPostProcessor.class);
    private final ConfigurableBeanFactory beanFactory;
    private final Map<String, List<String>> initMethods;
    private final Map<String, List<String>> destroyMethods;

    public InitDestroyBeanPostProcessor(ConfigurableBeanFactory beanFactory, Map<String, List<String>> initMethods, Map<String, List<String>> destroyMethods) {
        this.beanFactory = beanFactory;
        this.initMethods = initMethods;
        this.destroyMethods = destroyMethods;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        List methodNames = this.initMethods.getOrDefault(beanName, Collections.emptyList());
        for (String methodName : methodNames) {
            this.invokeInitMethod(bean, beanName, methodName);
        }
        return bean;
    }

    private void invokeInitMethod(Object bean, String beanName, String methodName) {
        Method method = this.findMethod(bean, methodName, () -> this.getBeanType(beanName));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Invoking init method on bean '" + beanName + "': " + method));
        }
        try {
            this.invokeMethod(bean, method);
        }
        catch (InvocationTargetException ex) {
            throw new BeanCreationException(beanName, "Invocation of init method failed", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Failed to invoke init method", ex);
        }
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        List methodNames = this.destroyMethods.getOrDefault(beanName, Collections.emptyList());
        for (String methodName : methodNames) {
            this.invokeDestroyMethod(bean, beanName, methodName);
        }
    }

    private void invokeDestroyMethod(Object bean, String beanName, String methodName) {
        Method method = this.findMethod(bean, methodName, () -> this.getBeanType(beanName));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Invoking destroy method on bean '" + beanName + "': " + method));
        }
        try {
            this.invokeMethod(bean, method);
        }
        catch (InvocationTargetException ex) {
            String msg = "Destroy method on bean with name '" + beanName + "' threw an exception";
            if (logger.isDebugEnabled()) {
                logger.warn((Object)msg, ex.getTargetException());
            } else {
                logger.warn((Object)(msg + ": " + ex.getTargetException()));
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to invoke destroy method on bean with name '" + beanName + "'"), ex);
        }
    }

    private Class<?> getBeanType(String beanName) {
        return this.beanFactory.containsBean(beanName) ? this.beanFactory.getMergedBeanDefinition(beanName).getResolvableType().toClass() : Object.class;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private Method findMethod(Object bean, String methodName, Supplier<Class<?>> beanTypeSupplier) {
        Method method = ReflectionUtils.findMethod(bean.getClass(), (String)methodName);
        if (method != null) {
            return method;
        }
        return ReflectionUtils.findMethod(beanTypeSupplier.get(), (String)methodName);
    }

    private void invokeMethod(Object target, Method method) throws InvocationTargetException, IllegalAccessException {
        ReflectionUtils.makeAccessible((Method)method);
        method.invoke(target, (Object[])null);
    }
}

