/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.core.NativeDetector;

public class ClassNotFoundExceptionNativeFailureAnalyzer
extends AbstractFailureAnalyzer<ClassNotFoundException> {
    private static final String ACTION = String.format("Native configuration for a class accessed reflectively is likely missing.%nYou can try to configure native hints in order to specify it explicitly.%nSee https://docs.spring.io/spring-native/docs/current/reference/htmlsingle/#native-hints for more details.", new Object[0]);

    protected FailureAnalysis analyze(Throwable rootFailure, ClassNotFoundException ex) {
        if (NativeDetector.inNativeImage()) {
            return new FailureAnalysis("Native reflection configuration for " + ex.getMessage() + " is missing.", ACTION, (Throwable)ex);
        }
        return null;
    }
}

