/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.tdpaas.beans.ftp;

import com.irdstudio.tdpaas.beans.ftp.dto.FTPComponentDownloadFileInput;
import com.irdstudio.tdpaas.beans.ftp.dto.FTPComponentDownloadFileOutput;
import com.irdstudio.tdpaas.beans.ftp.dto.FTPComponentUploadFileInput;
import com.irdstudio.tdpaas.beans.ftp.dto.FTPComponentUploadFileOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FTPComponent {
    private static Properties prop = null;
    private String host;
    private int port;
    private String username;
    private String password;
    private String localPath;
    private String remotePath;

    public FTPComponent() {
        if (prop == null) {
            String profile = System.getProperty("spring.profiles.active", "");
            Properties localProp = new Properties();
            try {
                String propertiesFile = "application";
                propertiesFile = profile != null && profile.length() > 0 ? propertiesFile + "-" + profile + ".properties" : propertiesFile + ".properties";
                localProp.load(FTPComponent.class.getClassLoader().getResourceAsStream(propertiesFile));
                if (prop == null) {
                    prop = localProp;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.host = prop.getProperty("ftp.host");
        this.port = Integer.valueOf(prop.getProperty("ftp.port"));
        this.username = prop.getProperty("ftp.username");
        this.password = prop.getProperty("ftp.password");
        this.localPath = prop.getProperty("ftp.local.path");
        this.remotePath = prop.getProperty("ftp.remote.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPComponentUploadFileOutput uploadFile(FTPComponentUploadFileInput input) {
        FTPComponentUploadFileOutput output = new FTPComponentUploadFileOutput();
        FTPClient ftp = new FTPClient();
        InputStream in = null;
        try {
            ftp.connect(this.host, this.port);
            ftp.setControlEncoding("UTF-8");
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                output.setFtpRspCode("9999");
                output.setSuccess("false");
                FTPComponentUploadFileOutput fTPComponentUploadFileOutput = output;
                return fTPComponentUploadFileOutput;
            }
            if (ftp.login(this.username, this.password)) {
                in = new FileInputStream(this.localPath + File.separator + input.getFullFilePath());
                ftp.changeWorkingDirectory(this.remotePath);
                String fileName = input.getFullFilePath();
                fileName = fileName.replaceAll("\\\\", File.separator);
                fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                boolean result = ftp.storeFile(fileName, in);
                output.setFtpRspCode(result ? "0000" : "9999");
                output.setSuccess(Boolean.toString(result));
                ftp.logout();
            } else {
                output.setFtpRspCode("9999");
                output.setSuccess("false");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            output.setFtpRspCode("9999");
            output.setSuccess("false");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPComponentDownloadFileOutput downloadFile(FTPComponentDownloadFileInput input) {
        FTPComponentDownloadFileOutput output = new FTPComponentDownloadFileOutput();
        FTPClient ftp = new FTPClient();
        OutputStream out = null;
        try {
            ftp.connect(this.host, this.port);
            ftp.setControlEncoding("UTF-8");
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                output.setFtpRspCode("9999");
                output.setSuccess("false");
                FTPComponentDownloadFileOutput fTPComponentDownloadFileOutput = output;
                return fTPComponentDownloadFileOutput;
            }
            if (ftp.login(this.username, this.password)) {
                out = new FileOutputStream(this.localPath + File.separator + input.getFileName());
                ftp.changeWorkingDirectory(this.remotePath);
                ftp.enterLocalPassiveMode();
                String fileName = input.getFileName();
                fileName = fileName.replaceAll("\\\\", File.separator);
                fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                FTPFile[] files = ftp.listFiles(fileName);
                boolean result = false;
                if (files.length == 0) {
                    throw new IOException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                result = ftp.retrieveFile(fileName, out);
                output.setFtpRspCode(result ? "0000" : "9999");
                output.setSuccess(Boolean.toString(result));
                ftp.logout();
            } else {
                output.setFtpRspCode("9999");
                output.setSuccess("false");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            output.setFtpRspCode("9999");
            output.setSuccess("false");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return output;
    }
}

