/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.tdpaas.beans.word.util;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.policy.RenderPolicy;
import com.irdstudio.tdpaas.beans.word.policy.TableModelPolicy;
import com.irdstudio.tdpaas.beans.word.util.WordResourceCloseUtil;
import com.irdstudio.tdpaas.beans.word.vo.tablemodel.PkgTableModelInfo;
import com.irdstudio.tdpaas.beans.word.vo.tablemodel.ProjectInfo;
import com.irdstudio.tdpaas.beans.word.vo.tablemodel.SingleTable;
import com.irdstudio.tdpaas.beans.word.vo.tablemodel.TableGroup;
import com.irdstudio.tdpaas.beans.word.vo.tablemodel.TableModelInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TableModelUtil {
    private static String SINGLE_TABLE_MODEL_TEMPLATE_NAME = "single_table_model_info.docx";
    private static String SINGLE_TABLE_MODEL_RESULT_NAME = "_single_table_model_result.docx";
    private static String SINGLE_TABLE_MODEL_TEMPLATE_G_NAME = "single_table_model_info_g.docx";
    private static String MULTIPLE_TABLES_TEMPLATE_NAME = "multiple_tables_info.docx";
    private static String GROUP_TEMPLATE_NAME = "table_group.docx";
    private static String PROJECT_TEMPLATE_NAME = "project.docx";
    private static String PROJECT_RESULT_NAME = "_project_result.docx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String writeSingleTableModelInfo(String projectId, TableModelInfo tableModelInfo, String templatePath, String tamplateName, String resultPath) {
        String resultFilePath;
        block7: {
            resultFilePath = resultPath + projectId + SINGLE_TABLE_MODEL_RESULT_NAME;
            XWPFTemplate template = null;
            FileOutputStream out = null;
            try {
                Configure config = Configure.newBuilder().customPolicy("single_table_model_info", (RenderPolicy)new TableModelPolicy()).build();
                template = XWPFTemplate.compile((String)(templatePath + tamplateName), (Configure)config).render((Object)tableModelInfo);
                out = new FileOutputStream(resultFilePath);
                template.write((OutputStream)out);
                out.flush();
                WordResourceCloseUtil.closeXWPFTemplate(template);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                break block7;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                WordResourceCloseUtil.closeXWPFTemplate(template);
                WordResourceCloseUtil.closeOutputStream(out);
            }
            WordResourceCloseUtil.closeOutputStream(out);
        }
        return resultFilePath;
    }

    public static List<SingleTable> getTableModelInfos(String projectId, List<TableModelInfo> modelInfos, String templatePath, String tamplateName, String resultPath) {
        ArrayList<SingleTable> list = new ArrayList<SingleTable>();
        SingleTable tableModelInfo = null;
        for (TableModelInfo modelInfo : modelInfos) {
            tableModelInfo = new SingleTable();
            tableModelInfo.setSingleTableInfo(new DocxRenderData(new File(TableModelUtil.writeSingleTableModelInfo(projectId, modelInfo, templatePath, tamplateName, resultPath))));
            list.add(tableModelInfo);
        }
        return list;
    }

    public static void setTableGroupInfos(String projectId, List<TableGroup> tableGroups, String groupName, List<TableModelInfo> modelInfos, String templatePath, String resultPath) {
        TableGroup tableGroup = new TableGroup();
        tableGroup.setTableGroupName(groupName);
        List<SingleTable> list = TableModelUtil.getTableModelInfos(projectId, modelInfos, templatePath, SINGLE_TABLE_MODEL_TEMPLATE_G_NAME, resultPath);
        tableGroup.setSingleTableInfo(new DocxRenderData(new File(templatePath + MULTIPLE_TABLES_TEMPLATE_NAME), list));
        tableGroups.add(tableGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String genWord4AllTableModelInfo(String projectId, List<PkgTableModelInfo> pkgTableModelInfos, String templatePath, String resultPath) {
        String resultFile;
        block11: {
            resultFile = null;
            if (Objects.isNull(pkgTableModelInfos) || pkgTableModelInfos.size() == 0) {
                return null;
            }
            XWPFTemplate template = null;
            FileOutputStream out = null;
            try {
                boolean isGroup;
                ProjectInfo projectInfo = new ProjectInfo();
                boolean bl = isGroup = pkgTableModelInfos.size() > 1;
                if (isGroup) {
                    String groupName = null;
                    ArrayList<TableGroup> tableGroups = new ArrayList<TableGroup>();
                    for (PkgTableModelInfo pkgTableModelInfo : pkgTableModelInfos) {
                        groupName = pkgTableModelInfo.getPkgName();
                        TableModelUtil.setTableGroupInfos(projectId, tableGroups, groupName, pkgTableModelInfo.getTableInfos(), templatePath, resultPath);
                    }
                    projectInfo.setTableModelInfo(new DocxRenderData(new File(templatePath + GROUP_TEMPLATE_NAME), tableGroups));
                } else {
                    List<SingleTable> singleTables = TableModelUtil.getTableModelInfos(projectId, pkgTableModelInfos.get(0).getTableInfos(), templatePath, SINGLE_TABLE_MODEL_TEMPLATE_NAME, resultPath);
                    projectInfo.setTableModelInfo(new DocxRenderData(new File(templatePath + MULTIPLE_TABLES_TEMPLATE_NAME), singleTables));
                }
                template = XWPFTemplate.compile((String)(templatePath + PROJECT_TEMPLATE_NAME)).render((Object)projectInfo);
                resultFile = projectId + PROJECT_RESULT_NAME;
                out = new FileOutputStream(resultPath + resultFile);
                template.write((OutputStream)out);
                out.flush();
                WordResourceCloseUtil.closeXWPFTemplate(template);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                break block11;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                WordResourceCloseUtil.closeXWPFTemplate(template);
                WordResourceCloseUtil.closeOutputStream(out);
            }
            WordResourceCloseUtil.closeOutputStream(out);
        }
        return resultFile;
    }
}

