/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.tdpaas.beans.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtil {
    private static Logger logger = LoggerFactory.getLogger(ZipUtil.class);
    public static final String EXT = ".zip";
    private static final int BUFFER = 4096;

    private ZipUtil() {
    }

    public static File zip(String filePath) {
        File target = null;
        File source = new File(filePath);
        if (source.exists()) {
            String zipName = source.getName() + EXT;
            target = source.isDirectory() ? new File(source.getAbsoluteFile(), zipName) : new File(source.getParent(), zipName);
            if (target.exists()) {
                target.delete();
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(target);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipUtil.addEntry("", source, zos);
            }
            catch (IOException e) {
                logger.error("\u538b\u7f29\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                if (zos != null) {
                    try {
                        zos.closeEntry();
                        zos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addEntry(String base, File source, ZipOutputStream zos) throws IOException {
        String entry = base + source.getName();
        if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().endsWith(EXT)) {
                    ZipUtil.addEntry(entry + "/", file, zos);
                }
                ++n2;
            }
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[10240];
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis, buffer.length);
            int read = 0;
            zos.putNextEntry(new ZipEntry(entry));
            while ((read = bis.read(buffer, 0, buffer.length)) != -1) {
                zos.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(bis, fis);
                throw throwable;
            }
            ZipUtil.closeQuietly(bis, fis);
            return;
        }
        ZipUtil.closeQuietly(bis, fis);
        return;
    }

    public static boolean unzip(String filePath, String savePath) {
        boolean result = false;
        File source = new File(filePath);
        if (source.exists()) {
            File savePathFile = new File(savePath);
            if (!savePathFile.isDirectory()) {
                savePathFile.mkdirs();
            }
            ZipInputStream zis = null;
            FilterOutputStream bos = null;
            try {
                zis = new ZipInputStream(new FileInputStream(source));
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String currentEntry = entry.getName();
                    String path = savePath + entry.getName();
                    File unzipFile = new File(path);
                    if (entry.isDirectory()) {
                        if (!unzipFile.isDirectory()) {
                            unzipFile.mkdirs();
                        }
                    } else {
                        bos = new BufferedOutputStream(new FileOutputStream(path));
                        int read = 0;
                        byte[] buffer = new byte[10240];
                        while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                            ((BufferedOutputStream)bos).write(buffer, 0, read);
                        }
                        ((BufferedOutputStream)bos).flush();
                        zis.closeEntry();
                    }
                    if (!currentEntry.endsWith(EXT)) continue;
                    ZipUtil.unzip(path, savePath);
                    System.out.println(path);
                }
                result = true;
            }
            catch (IOException e) {
                logger.error("\u89e3\u538b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static void close(Closeable ... closeables) throws IOException {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
    }

    public static boolean moveDirectory(String srcDirName, String destDirName) {
        File[] sourceFiles;
        File srcDir = new File(srcDirName);
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        File destDir = new File(destDirName);
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else {
            ZipUtil.deleteFolder(destDirName);
        }
        for (File sourceFile : sourceFiles = srcDir.listFiles()) {
            if (sourceFile.isFile()) {
                ZipUtil.moveFile(sourceFile.getAbsolutePath(), destDir.getAbsolutePath());
                continue;
            }
            if (!sourceFile.isDirectory()) continue;
            ZipUtil.moveDirectory(sourceFile.getAbsolutePath(), destDir.getAbsolutePath() + File.separator + sourceFile.getName());
        }
        return srcDir.delete();
    }

    public static boolean moveFile(String srcFileName, String destDirName) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        File destDir = new File(destDirName);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return srcFile.renameTo(new File(destDirName + File.separator + srcFile.getName()));
    }

    public static boolean moveFile(String srcFileName, String destPath, String newFileName) {
        File destFile;
        File srcFile = new File(srcFileName);
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        File destDir = new File(destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if ((destFile = new File(destPath + File.separator + newFileName)).exists()) {
            destFile.delete();
        }
        return srcFile.renameTo(new File(destPath + File.separator + newFileName));
    }

    public static boolean moveFile(String srcFileName, String destPath, String newFileName, boolean delFlag) {
        File destFile;
        File srcFile = new File(srcFileName);
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        File destDir = new File(destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if ((destFile = new File(destPath + File.separator + newFileName)).exists() && delFlag) {
            destFile.delete();
        }
        return srcFile.renameTo(new File(destPath + File.separator + newFileName));
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = ZipUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = ZipUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static boolean deleteFolder(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            return ZipUtil.deleteFile(sPath);
        }
        return ZipUtil.deleteDirectory(sPath);
    }

    public static void closeQuietly(Closeable ... closeables) {
        try {
            ZipUtil.close(closeables);
        }
        catch (IOException e) {
            logger.error("\u5173\u95ed\u8d44\u6e90\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZipAll(File source, File destination) throws IOException {
        boolean result = false;
        logger.info("\u89e3\u538b\u6587\u4ef6\uff1a" + source.getName());
        try (ZipFile zip = new ZipFile(source);){
            destination.getParentFile().mkdirs();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(destination, currentEntry);
                File destinationParent = destFile.getParentFile();
                if (!destinationParent.exists()) {
                    destinationParent.mkdirs();
                }
                if (!entry.isDirectory()) {
                    BufferedInputStream is = null;
                    FileOutputStream fos = null;
                    FilterOutputStream dest = null;
                    try {
                        int currentByte;
                        is = new BufferedInputStream(zip.getInputStream(entry));
                        byte[] data = new byte[4096];
                        fos = new FileOutputStream(destFile);
                        dest = new BufferedOutputStream(fos, 4096);
                        while ((currentByte = is.read(data, 0, 4096)) != -1) {
                            ((BufferedOutputStream)dest).write(data, 0, currentByte);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u538b\u6587\u4ef6\u51fa\u9519\uff1a" + source.getName());
                        e.printStackTrace();
                        throw e;
                    }
                    finally {
                        if (dest != null) {
                            dest.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                } else {
                    destFile.mkdirs();
                }
                if (currentEntry.endsWith(EXT)) {
                    ZipUtil.unZipAll(destFile, destinationParent);
                    if (!destFile.delete()) {
                        logger.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u51fa\u9519\uff1a" + destFile.getName());
                    }
                }
                result = true;
            }
        }
        logger.info("\u89e3\u538b\u7f29\u6587\u4ef6\u6587\u4ef6\u6210\u529f\uff1a" + source.getName());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZipSig(File source, File destination) throws IOException {
        boolean result = false;
        logger.info("\u89e3\u538b\u6587\u4ef6\uff1a" + source.getName());
        try (ZipFile zip = new ZipFile(source);){
            destination.getParentFile().mkdirs();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(destination, currentEntry);
                File destinationParent = destFile.getParentFile();
                if (!destinationParent.exists()) {
                    destinationParent.mkdirs();
                }
                if (!entry.isDirectory()) {
                    BufferedInputStream is = null;
                    FileOutputStream fos = null;
                    FilterOutputStream dest = null;
                    try {
                        int currentByte;
                        is = new BufferedInputStream(zip.getInputStream(entry));
                        byte[] data = new byte[4096];
                        fos = new FileOutputStream(destFile);
                        dest = new BufferedOutputStream(fos, 4096);
                        while ((currentByte = is.read(data, 0, 4096)) != -1) {
                            ((BufferedOutputStream)dest).write(data, 0, currentByte);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u538b\u6587\u4ef6\u51fa\u9519\uff1a" + source.getName());
                        e.printStackTrace();
                        throw e;
                    }
                    finally {
                        if (dest != null) {
                            dest.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                } else {
                    destFile.mkdirs();
                }
                result = true;
            }
        }
        logger.info("\u89e3\u538b\u7f29\u6587\u4ef6\u6587\u4ef6\u6210\u529f\uff1a" + source.getName());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZipAll(File source, File destination, boolean isMoveFile) throws IOException {
        boolean result = false;
        boolean unZipResult = ZipUtil.unZipAll(source, destination);
        if (unZipResult && isMoveFile) {
            File[] destFiles = destination.listFiles();
            if (destFiles.length > 0) {
                for (File destFile : destFiles) {
                    if (!destFile.isDirectory()) continue;
                    try {
                        File[] desFiles = destFile.listFiles();
                        if (desFiles.length <= 0) continue;
                        for (File desFile : desFiles) {
                            String movePath = destFile.getParent() + File.separator;
                            ZipUtil.moveFile(desFile.getAbsolutePath(), movePath, desFile.getName(), true);
                        }
                    }
                    catch (Exception e) {
                        result = false;
                        logger.error("\u79fb\u52a8\u6587\u4ef6\u51fa\u9519\uff1a" + destFile.getName());
                        break;
                    }
                    finally {
                        destFile.delete();
                    }
                }
            }
            result = true;
        }
        return result;
    }
}

