/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.web.controller;

import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSON;
import com.irdstudio.sdk.beans.core.cache.CacheManager;
import com.irdstudio.sdk.beans.core.enums.DataRuleType;
import com.irdstudio.sdk.beans.core.enums.OperationType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.core.vo.KeyValue;
import com.irdstudio.sdk.beans.core.vo.ResourceCtrl;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.IController;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractController
implements IController {
    @Autowired
    protected HttpServletRequest httpRequest;
    @Autowired
    protected HttpServletResponse httpResponse;
    protected static Logger logger = LoggerFactory.getLogger(AbstractController.class);

    public final List<String> getUserRoles() {
        UserInfo userInfo = this.getUserInfo();
        ArrayList<String> roles = new ArrayList<String>();
        userInfo.getUserRoles().forEach(role -> roles.add(role.getRoleCode()));
        return roles;
    }

    private final void setUserInfoToVO(UserInfo userInfo, Object[] params) {
        for (Object object : params) {
            if (!(object instanceof BaseInfo)) continue;
            BaseInfo baseInfo = (BaseInfo)object;
            baseInfo.setLoginUserId(userInfo.getUserId());
            baseInfo.setLoginUserOrgLocation(userInfo.getOrgInfo().getOrgLocation());
            baseInfo.setLoginUserOrgCode(userInfo.getOrgInfo().getOrgCode());
            baseInfo.setLoginUserLeageOrgCode(userInfo.getLegalOrg().getOrgCode());
        }
    }

    private final Method getCallMethod(Object serviceClass, String methodName, String dataRuleType) throws Exception {
        try {
            Method[] methods = serviceClass.getClass().getMethods();
            String mtdName = this.getCallMethodByDataRuleType(methodName, dataRuleType);
            List lists = Arrays.stream(methods).filter(m -> m.getName().equals(mtdName)).collect(Collectors.toList());
            if (Objects.nonNull(lists) && lists.size() > 0) {
                return (Method)lists.get(0);
            }
        }
        catch (Exception e) {
            logger.error("\u5f53\u524d\u83b7\u53d6\u8c03\u7528\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            throw e;
        }
        return null;
    }

    private final String getCallMethodByDataRuleType(String methodName, String dataRuleType) {
        if (StringUtils.isEmpty((String)dataRuleType)) {
            dataRuleType = DataRuleType.Owner.getValue();
        }
        String suffix = "";
        if (StringUtils.isNotEmpty((String)dataRuleType)) {
            for (DataRuleType type : DataRuleType.values()) {
                if (!dataRuleType.equals(type.getValue())) continue;
                suffix = type.toString();
                break;
            }
        }
        return methodName + suffix;
    }

    public final <T> T setUserInfoToVO(BaseInfo baseInfo) {
        UserInfo userInfo = this.getUserInfo();
        Object[] obj = new Object[]{baseInfo};
        this.setUserInfoToVO(userInfo, obj);
        return (T)obj[0];
    }

    public final UserInfo getUserInfo() {
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.httpRequest.getSession().getAttribute("userInfo");
        }
        catch (ClassCastException e) {
            Object obj = this.httpRequest.getSession().getAttribute("userInfo");
            String json = JSON.toJSONString((Object)obj);
            userInfo = (UserInfo)JSON.parseObject((String)json, UserInfo.class);
        }
        return userInfo;
    }

    public final <T> Collection<T> displayNames(Collection<T> datas, KeyValue userColumnMapping, KeyValue orgColumnMapping) {
        if (Objects.nonNull(datas) && !datas.isEmpty()) {
            for (T data : datas) {
                if (Objects.nonNull(userColumnMapping)) {
                    this.displayUserName(data, userColumnMapping.getKey(), userColumnMapping.getValue());
                }
                if (!Objects.nonNull(orgColumnMapping)) continue;
                this.displayOrgName(data, orgColumnMapping.getKey(), orgColumnMapping.getValue());
            }
        }
        return datas;
    }

    public final <T> Collection<T> displayNames(Collection<T> datas, Collection<KeyValue> userColumnMappings, Collection<KeyValue> orgColumnMappings) {
        if (Objects.nonNull(datas) && !datas.isEmpty()) {
            for (Object data : datas) {
                if (Objects.nonNull(userColumnMappings) && !userColumnMappings.isEmpty()) {
                    userColumnMappings.forEach(s -> this.displayUserName(data, s.getKey(), s.getValue()));
                }
                if (!Objects.nonNull(orgColumnMappings) || orgColumnMappings.isEmpty()) continue;
                orgColumnMappings.forEach(s -> this.displayOrgName(data, s.getKey(), s.getValue()));
            }
        }
        return datas;
    }

    public final <T> T displayOrgName(T data, String srcColumn, String targetColumn) {
        return this.displayName(data, srcColumn, targetColumn, "CACHE_KEY_ORG_INFOS", "orgName");
    }

    public final <T> T displayUserName(T data, String srcColumn, String targetColumn) {
        return this.displayName(data, srcColumn, targetColumn, "CACHE_KEY_USER_INFOS", "userName");
    }

    private final <T> T displayName(T data, String srcColumn, String targetColumn, String cacheKey, String cacheObjectName) {
        if (Objects.nonNull(data) && StringUtil.isNotEmpty((String)srcColumn) && StringUtil.isNotEmpty((String)targetColumn)) {
            try {
                Object cacheObject;
                String code = StringUtil.replaceObjNull((Object)BeanUtility.getProptery(data, (String)srcColumn));
                if (StringUtil.isNotEmpty((String)code) && Objects.nonNull(cacheObject = CacheManager.getCacheObject((String)cacheKey, (String)code))) {
                    Object displayName = BeanUtility.getProptery((Object)cacheObject, (String)cacheObjectName);
                    BeanUtility.setProptery(data, (String)targetColumn, (Object)displayName);
                }
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u5b57\u6bb5\uff1a" + srcColumn + ", \u76ee\u6807\u5b57\u6bb5\uff1a" + targetColumn + "\u8f6c\u6362\u7ffb\u8bd1\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            }
        }
        return data;
    }

    protected boolean checkOptionalAuthority(Map<String, String> primaryKey, String configUrl, Object service) {
        String cfgUrl = this.httpRequest.getContextPath() + configUrl;
        UserInfo userInfo = this.getUserInfo();
        ArrayList roles = new ArrayList();
        userInfo.getUserRoles().forEach(role -> roles.add(role.getRoleCode()));
        String dataRuleType = (String)((GenericService)SpringContextUtils.getBean((String)"sRoleDataRuleService")).$invoke("getDataRuleType", new String[]{"java.lang.String", "java.util.List"}, new Object[]{cfgUrl, roles});
        if (StringUtils.isEmpty((String)dataRuleType)) {
            dataRuleType = DataRuleType.Owner.getValue();
        }
        primaryKey.put("loginUserId", userInfo.getUserId());
        primaryKey.put("loginUserOrgCode", userInfo.getOrgInfo().getOrgCode());
        primaryKey.put("loginUserLeageOrgCode", userInfo.getLegalOrg().getOrgCode());
        primaryKey.put("loginUserOrgLocation", userInfo.getOrgInfo().getOrgLocation());
        Object rtnObj = ((GenericService)service).$invoke("checkOptionalAuthority", new String[]{"java.util.Map", "java.lang.String"}, new Object[]{primaryKey, dataRuleType});
        logger.info("\u6570\u636e\u6743\u9650\u9a8c\u8bc1\u6210\u529f, \u9a8c\u8bc1\u6570\u636e\u8fde\u63a5\uff1a" + configUrl + ",\u9a8c\u8bc1\u7ed3\u679c\uff1a" + rtnObj);
        return Boolean.valueOf(StringUtil.replaceObjNull((Object)rtnObj));
    }

    protected boolean checkOperationAuthorityForCreate(String rescCode) {
        return this.checkOperationAuthority(rescCode, OperationType.Create);
    }

    protected boolean checkOperationAuthorityForEdit(String rescCode) {
        return this.checkOperationAuthority(rescCode, OperationType.Edit);
    }

    protected boolean checkOperationAuthorityForDelete(String rescCode) {
        return this.checkOperationAuthority(rescCode, OperationType.Delete);
    }

    protected boolean checkOperationAuthority(String rescCode, OperationType type) {
        if (StringUtil.isNotEmpty((String)rescCode)) {
            UserInfo userInfo = this.getUserInfo();
            List menuCtrls = userInfo.getMenuCtrls();
            if (menuCtrls != null) {
                for (int i = 0; i < menuCtrls.size(); ++i) {
                    ResourceCtrl resCtrl = (ResourceCtrl)menuCtrls.get(i);
                    if (resCtrl == null || !resCtrl.getRescCode().equals(rescCode) || !resCtrl.getRescActCode().equals(type.getOperationId())) continue;
                    logger.info("\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u6210\u529f\uff0c \u64cd\u4f5c\u8d44\u6e90ID: " + resCtrl.getRescCode() + ",\u64cd\u4f5c\u7801: " + resCtrl.getRescActCode());
                    return true;
                }
            }
            logger.error("\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u64cd\u4f5c\u6743\u9650\u96c6\u5408\uff1a" + menuCtrls);
        }
        return false;
    }
}

