/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.tdpaas.beans.idempotent.service;

import com.alibaba.fastjson.JSON;
import com.irdstudio.tdpaas.beans.idempotent.constant.AppConstant;
import com.irdstudio.tdpaas.beans.idempotent.dto.AppCheckInput;
import com.irdstudio.tdpaas.beans.idempotent.dto.AppDeleteInput;
import com.irdstudio.tdpaas.beans.idempotent.dto.AppOutput;
import com.irdstudio.tdpaas.beans.idempotent.dto.AppUpdateInput;
import com.irdstudio.tdpaas.beans.idempotent.po.SIdempotentPO;
import com.irdstudio.tdpaas.beans.idempotent.service.AppService;
import com.irdstudio.tdpaas.beans.idempotent.service.SIdempotentService;
import com.irdstudio.tdpaas.beans.idempotent.types.StateEnum;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppServiceImpl
implements AppService {
    private static final Logger log = LoggerFactory.getLogger(AppServiceImpl.class);
    @Autowired
    private SIdempotentService sIdempotentService;

    @Override
    public AppOutput check(AppCheckInput appCheckInput) {
        try {
            String className = Thread.currentThread().getStackTrace()[2].getClassName();
            String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
            Class<?> parentClass = Class.forName(className);
            Method parentMethodObj = Arrays.stream(parentClass.getDeclaredMethods()).filter(method -> methodName.equals(method.getName()) || method.getParameterTypes().length == 1).findAny().orElse(null);
            if (parentMethodObj == null) {
                throw new RuntimeException(StringUtils.join((Object[])new String[]{"\u6839\u636e\u51fd\u6570\u540d", methodName, "\u83b7\u53d6\u4e0d\u5230\u51fd\u6570\u5bf9\u8c61"}));
            }
            Class<?> parentReturnType = parentMethodObj.getReturnType();
            Class<?> parentParameterType = parentMethodObj.getParameterTypes()[0];
            SIdempotentPO sIdempotentPO = this.sIdempotentService.selectOne(appCheckInput.getSeqNo(), parentClass.getName(), parentMethodObj.getName());
            if (sIdempotentPO != null) {
                if (AppConstant.TXSTCD_0.equals(sIdempotentPO.getTxStCd())) {
                    throw new RuntimeException("\u5f53\u524d\u6d41\u6c34\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u5f53\u524d\u8bf7\u6c42\u62d2\u7edd");
                }
                String outputTpCl = sIdempotentPO.getOutputTpCl();
                String outputPara = sIdempotentPO.getOutputPara();
                return new AppOutput(StateEnum.state1.getState(), StateEnum.state1.getMsg(), JSON.parseObject((String)outputPara, Class.forName(outputTpCl)));
            }
            SIdempotentPO saveEntity = this.constructSaveEntity(appCheckInput, parentClass, parentMethodObj, parentParameterType, parentReturnType);
            this.sIdempotentService.save(saveEntity);
            return new AppOutput(StateEnum.state0.getState(), StateEnum.state0.getMsg(), null);
        }
        catch (Exception e) {
            log.error("\u5e42\u7b49\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public AppOutput update(AppUpdateInput appUpdateInput) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        SIdempotentPO sIdempotentPO = this.sIdempotentService.selectOne(appUpdateInput.getSeqNo(), className, methodName);
        if (Objects.isNull(sIdempotentPO)) {
            throw new RuntimeException("\u83b7\u53d6\u4e0d\u5230\u8c03\u7528\u8bb0\u5f55");
        }
        sIdempotentPO.setUpdateTime(new Date());
        sIdempotentPO.setOutputPara(JSON.toJSONString((Object)appUpdateInput.getOutputPara()));
        sIdempotentPO.setTxStCd(StringUtils.isEmpty((CharSequence)appUpdateInput.getBizHandleFlag()) ? AppConstant.TXSTCD_1 : appUpdateInput.getBizHandleFlag());
        long currentTimeMillis = System.currentTimeMillis();
        sIdempotentPO.setEndTm(currentTimeMillis);
        sIdempotentPO.setInvokeTm(currentTimeMillis - sIdempotentPO.getStartTm());
        if (!this.sIdempotentService.updateById(sIdempotentPO)) {
            throw new RuntimeException("\u66f4\u65b0\u5e42\u7b49\u8f93\u51fa\u62a5\u6587\u5931\u8d25");
        }
        return new AppOutput(StateEnum.state2.getState(), StateEnum.state2.getMsg(), null);
    }

    @Override
    public AppOutput delete(AppDeleteInput appDeleteInput) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        Integer integer = this.sIdempotentService.removeOne(appDeleteInput.getSeqNo(), className, methodName);
        if (integer == null || integer < 1) {
            log.info("\u5220\u9664\u5e42\u7b49\u8bb0\u5f55\u53d8\u66f4\u6570\u91cf\u4e3a:[{}],\u6d41\u6c34\u53f7\u4e3a\uff1a[{}],\u63a5\u53e3\u540d\uff1a[{}],\u51fd\u6570\u540d\uff1a[{}]", new Object[]{integer, appDeleteInput.getSeqNo(), className, methodName});
        }
        return new AppOutput(StateEnum.state3.getState(), StateEnum.state3.getMsg(), null);
    }

    private SIdempotentPO constructSaveEntity(AppCheckInput appCheckInput, Class<?> parentClass, Method parentMethodObj, Class<?> parentParameterType, Class<?> parentReturnType) {
        SIdempotentPO saveEntity = new SIdempotentPO();
        saveEntity.setSeqNo(appCheckInput.getSeqNo());
        saveEntity.setTxStCd(AppConstant.TXSTCD_0);
        saveEntity.setProcTpCd(AppConstant.PROCTPCD_1);
        saveEntity.setIntfcNm(parentClass.getName());
        saveEntity.setIntfcMethd(parentMethodObj.getName());
        saveEntity.setStartTm(System.currentTimeMillis());
        saveEntity.setInputTpCl(parentParameterType.getName());
        saveEntity.setInputPara(JSON.toJSONString((Object)appCheckInput.getInputPara()));
        saveEntity.setOutputTpCl(parentReturnType.getName());
        saveEntity.setEventNo(appCheckInput.getEventNo());
        saveEntity.setIntfcAppNm(appCheckInput.getIntfcAppNm());
        saveEntity.setConsumerSysNo(appCheckInput.getConsumerSysNo());
        saveEntity.setTraceId(appCheckInput.getTraceId());
        saveEntity.setCreateTime(new Date());
        return saveEntity;
    }
}

