create table s_idempotent
(
    id              bigint      not null auto_increment comment '主键',
    seq_no          varchar(60) not null comment '交易流水号',
    event_no        varchar(60) default '' comment '全局流水号',
    tx_st_cd        varchar(2)  not null comment '交易状态代码（0:进行中,1:成功,2:失败）',
    proc_tp_cd      varchar(1) comment '处理类型代码（1:首次调用,2:幂等）',
    intfc_nm        varchar(500) comment '接口类名',
    intfc_methd     varchar(60) comment '接口方法',
    start_tm        bigint comment '开始时间（毫秒）',
    end_tm          bigint comment '结束时间（毫秒）',
    invoke_tm       bigint comment '执行时间（毫秒）',
    input_tp_cl     varchar(500) comment '输入类名',
    input_para      blob comment '输入参数',
    output_tp_cl    varchar(500) comment '输出类名',
    output_para     longtext comment '输出参数',
    intfc_app_nm    varchar(200) comment '接口归属应用名称',
    consumer_sys_no varchar(60) comment '调用方系统编号',
    trace_id        varchar(60) default '' comment '链路跟踪编号',
    create_time     datetime    not null comment '落表时间',
    update_time     datetime comment '更新时间',
    PRIMARY KEY (id),
    UNIQUE INDEX uk_pow_etc_seq_no (seq_no, intfc_nm, intfc_methd),
    index idex_event_no_trace_id (event_no, trace_id)
) COMMENT ='防重幂等流水表(先只支持正向交易)';
